/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.DiffTool;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.impl.DiffRequestPanelImpl;
import com.intellij.diff.impl.DiffWindow;
import com.intellij.diff.merge.BinaryMergeTool;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.MergeWindow;
import com.intellij.diff.merge.TextMergeTool;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.binary.BinaryDiffTool;
import com.intellij.diff.tools.dir.DirDiffTool;
import com.intellij.diff.tools.external.ExternalDiffTool;
import com.intellij.diff.tools.external.ExternalMergeTool;
import com.intellij.diff.tools.fragmented.UnifiedDiffTool;
import com.intellij.diff.tools.simple.SimpleDiffTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffManagerImpl
extends DiffManagerEx {
    public void showDiff(@Nullable Project project2, @NotNull DiffRequest request) {
        this.showDiff(project2, request, DiffDialogHints.DEFAULT);
    }

    public void showDiff(@Nullable Project project2, @NotNull DiffRequest request, @NotNull DiffDialogHints hints) {
        SimpleDiffRequestChain requestChain = new SimpleDiffRequestChain(request);
        this.showDiff(project2, (DiffRequestChain)requestChain, hints);
    }

    public void showDiff(@Nullable Project project2, @NotNull DiffRequestChain requests, @NotNull DiffDialogHints hints) {
        if (ExternalDiffTool.isDefault()) {
            ExternalDiffTool.show(project2, requests, hints);
            return;
        }
        this.showDiffBuiltin(project2, requests, hints);
    }

    public void showDiffBuiltin(@Nullable Project project2, @NotNull DiffRequest request) {
        this.showDiffBuiltin(project2, request, DiffDialogHints.DEFAULT);
    }

    public void showDiffBuiltin(@Nullable Project project2, @NotNull DiffRequest request, @NotNull DiffDialogHints hints) {
        SimpleDiffRequestChain requestChain = new SimpleDiffRequestChain(request);
        this.showDiffBuiltin(project2, (DiffRequestChain)requestChain, hints);
    }

    public void showDiffBuiltin(@Nullable Project project2, @NotNull DiffRequestChain requests, @NotNull DiffDialogHints hints) {
        new DiffWindow(project2, requests, hints).show();
    }

    @NotNull
    public DiffRequestPanel createRequestPanel(@Nullable Project project2, @NotNull Disposable parent, @Nullable Window window) {
        DiffRequestPanelImpl panel2 = new DiffRequestPanelImpl(project2, window);
        Disposer.register((Disposable)parent, (Disposable)panel2);
        return panel2;
    }

    @NotNull
    public List<DiffTool> getDiffTools() {
        ArrayList<DiffTool> result2 = new ArrayList<DiffTool>();
        Collections.addAll(result2, DiffTool.EP_NAME.getExtensions());
        result2.add((DiffTool)SimpleDiffTool.INSTANCE);
        result2.add((DiffTool)UnifiedDiffTool.INSTANCE);
        result2.add((DiffTool)BinaryDiffTool.INSTANCE);
        result2.add((DiffTool)DirDiffTool.INSTANCE);
        return result2;
    }

    @NotNull
    public List<MergeTool> getMergeTools() {
        ArrayList<MergeTool> result2 = new ArrayList<MergeTool>();
        Collections.addAll(result2, MergeTool.EP_NAME.getExtensions());
        result2.add(TextMergeTool.INSTANCE);
        result2.add(BinaryMergeTool.INSTANCE);
        return result2;
    }

    public void showMerge(@Nullable Project project2, @NotNull MergeRequest request) {
        if (ExternalMergeTool.isDefault()) {
            ExternalMergeTool.show(project2, request);
            return;
        }
        this.showMergeBuiltin(project2, request);
    }

    public void showMergeBuiltin(@Nullable Project project2, @NotNull MergeRequest request) {
        new MergeWindow(project2, request).show();
    }
}

