/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff;

import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.InvalidDiffRequestException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.TextMergeRequest;
import com.intellij.diff.requests.BinaryMergeRequestImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.requests.TextMergeRequestImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    private final DiffContentFactoryEx myContentFactory = DiffContentFactoryEx.getInstanceEx();

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project2, @NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        DiffContent content1 = this.myContentFactory.create(project2, file1);
        DiffContent content2 = this.myContentFactory.create(project2, file2);
        String title1 = this.getContentTitle(file1);
        String title2 = this.getContentTitle(file2);
        String title = this.getTitle(file1, file2);
        return new SimpleDiffRequest(title, content1, content2, title1, title2);
    }

    @NotNull
    public ContentDiffRequest createFromFiles(@Nullable Project project2, @NotNull VirtualFile leftFile, @NotNull VirtualFile baseFile, @NotNull VirtualFile rightFile) {
        DiffContent content1 = this.myContentFactory.create(project2, leftFile);
        DiffContent content2 = this.myContentFactory.create(project2, baseFile);
        DiffContent content3 = this.myContentFactory.create(project2, rightFile);
        String title1 = this.getContentTitle(leftFile);
        String title2 = this.getContentTitle(baseFile);
        String title3 = this.getContentTitle(rightFile);
        return new SimpleDiffRequest(null, content1, content2, content3, title1, title2, title3);
    }

    @NotNull
    public ContentDiffRequest createClipboardVsValue(@NotNull String value2) {
        DiffContent content1 = this.myContentFactory.createClipboardContent();
        DocumentContent content2 = this.myContentFactory.create(value2);
        String title1 = DiffBundle.message((String)"diff.content.clipboard.content.title", (Object[])new Object[0]);
        String title2 = DiffBundle.message((String)"diff.content.selected.value", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"diff.clipboard.vs.value.dialog.title", (Object[])new Object[0]);
        return new SimpleDiffRequest(title, content1, (DiffContent)content2, title1, title2);
    }

    @NotNull
    public String getContentTitle(@NotNull VirtualFile file2) {
        return DiffRequestFactoryImpl.getContentTitle(VcsUtil.getFilePath((VirtualFile)file2));
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return DiffRequestFactoryImpl.getTitle(VcsUtil.getFilePath((VirtualFile)file1), VcsUtil.getFilePath((VirtualFile)file2), " vs ");
    }

    @NotNull
    public String getTitle(@NotNull VirtualFile file2) {
        return this.getTitle(file2, file2);
    }

    @NotNull
    public static String getContentTitle(@NotNull FilePath path) {
        if (path.isDirectory()) {
            return path.getPresentableUrl();
        }
        FilePath parent = path.getParentPath();
        return DiffRequestFactoryImpl.getContentTitle(path.getName(), path.getPresentableUrl(), parent != null ? parent.getPresentableUrl() : null);
    }

    @NotNull
    public static String getTitle(@NotNull FilePath path1, @NotNull FilePath path2, @NotNull String separator) {
        if ((path1.isDirectory() || path2.isDirectory()) && path1.getPath().equals(path2.getPath())) {
            return path1.getPresentableUrl();
        }
        String name1 = path1.getName();
        String name2 = path2.getName();
        if (path1.isDirectory() ^ path2.isDirectory()) {
            if (path1.isDirectory()) {
                name1 = name1 + File.separatorChar;
            }
            if (path2.isDirectory()) {
                name2 = name2 + File.separatorChar;
            }
        }
        FilePath parent1 = path1.getParentPath();
        FilePath parent2 = path2.getParentPath();
        return DiffRequestFactoryImpl.getRequestTitle(name1, path1.getPresentableUrl(), parent1 != null ? parent1.getPresentableUrl() : null, name2, path2.getPresentableUrl(), parent2 != null ? parent2.getPresentableUrl() : null, separator);
    }

    @NotNull
    private static String getContentTitle(@NotNull String name, @NotNull String path, @Nullable String parentPath) {
        if (parentPath != null) {
            return name + " (" + parentPath + ")";
        }
        return path;
    }

    @NotNull
    private static String getRequestTitle(@NotNull String name1, @NotNull String path1, @Nullable String parentPath1, @NotNull String name2, @NotNull String path2, @Nullable String parentPath2, @NotNull String sep) {
        if (path1.equals(path2)) {
            return DiffRequestFactoryImpl.getContentTitle(name1, path1, parentPath1);
        }
        if (Comparing.equal((String)parentPath1, (String)parentPath2)) {
            if (parentPath1 != null) {
                return name1 + sep + name2 + " (" + parentPath1 + ")";
            }
            return path1 + sep + path2;
        }
        if (name1.equals(name2)) {
            if (parentPath1 != null && parentPath2 != null) {
                return name1 + " (" + parentPath1 + sep + parentPath2 + ")";
            }
            return path1 + sep + path2;
        }
        if (parentPath1 != null && parentPath2 != null) {
            return name1 + sep + name2 + " (" + parentPath1 + sep + parentPath2 + ")";
        }
        return path1 + sep + path2;
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project2, @Nullable FileType fileType, @NotNull Document outputDocument, @NotNull List<String> textContents, @Nullable String title, @NotNull List<String> titles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (textContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (titles.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only");
        }
        DocumentContent outputContent = this.myContentFactory.create(project2, outputDocument, fileType);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (String text : textContents) {
            contents.add(this.myContentFactory.create(project2, text, fileType));
        }
        return new TextMergeRequestImpl(project2, outputContent, originalContent, contents, title, titles, applyCallback);
    }

    @NotNull
    public MergeRequest createMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            return this.createTextMergeRequest(project2, output, byteContents, title, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            return this.createBinaryMergeRequest(project2, output, byteContents, title, contentTitles, applyCallback);
        }
    }

    @NotNull
    public TextMergeRequest createTextMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        Document outputDocument = FileDocumentManager.getInstance().getDocument(output);
        if (outputDocument == null) {
            throw new InvalidDiffRequestException("Can't get output document: " + output.getPresentableUrl());
        }
        if (!DiffUtil.canMakeWritable(outputDocument)) {
            throw new InvalidDiffRequestException("Output is read only: " + output.getPresentableUrl());
        }
        DocumentContent outputContent = this.myContentFactory.create(project2, outputDocument);
        CharSequence originalContent = outputDocument.getImmutableCharSequence();
        ArrayList<DocumentContent> contents = new ArrayList<DocumentContent>(3);
        for (byte[] bytes : byteContents) {
            contents.add(this.myContentFactory.createDocumentFromBytes(project2, bytes, output));
        }
        return new TextMergeRequestImpl(project2, outputContent, originalContent, contents, title, contentTitles, applyCallback);
    }

    @NotNull
    public MergeRequest createBinaryMergeRequest(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<byte[]> byteContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (byteContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project2, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output);
            }
            byte[] originalContent = output.contentsToByteArray();
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            for (byte[] bytes : byteContents) {
                contents.add(this.myContentFactory.createFromBytes(project2, bytes, output));
            }
            return new BinaryMergeRequestImpl(project2, outputContent, originalContent, contents, byteContents, title, contentTitles, applyCallback);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<VirtualFile> fileContents, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        String title = "Merge " + output.getPresentableUrl();
        List titles = ContainerUtil.list((Object[])new String[]{"Your Version", "Base Version", "Their Version"});
        return this.createMergeRequestFromFiles(project2, output, fileContents, title, titles, applyCallback);
    }

    @NotNull
    public MergeRequest createMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            return this.createTextMergeRequestFromFiles(project2, output, fileContents, title, contentTitles, applyCallback);
        }
        catch (InvalidDiffRequestException e) {
            return this.createBinaryMergeRequestFromFiles(project2, output, fileContents, title, contentTitles, applyCallback);
        }
    }

    @NotNull
    public TextMergeRequest createTextMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
        for (VirtualFile file2 : fileContents) {
            try {
                byteContents.add(file2.contentsToByteArray());
            }
            catch (IOException e) {
                throw new InvalidDiffRequestException("Can't read from file: " + file2.getPresentableUrl(), (Throwable)e);
            }
        }
        return this.createTextMergeRequest(project2, output, byteContents, title, contentTitles, applyCallback);
    }

    @NotNull
    public MergeRequest createBinaryMergeRequestFromFiles(@Nullable Project project2, @NotNull VirtualFile output, @NotNull List<VirtualFile> fileContents, @Nullable String title, @NotNull List<String> contentTitles, @Nullable Consumer<MergeResult> applyCallback) throws InvalidDiffRequestException {
        if (fileContents.size() != 3) {
            throw new IllegalArgumentException();
        }
        if (contentTitles.size() != 3) {
            throw new IllegalArgumentException();
        }
        try {
            FileContent outputContent = this.myContentFactory.createFile(project2, output);
            if (outputContent == null) {
                throw new InvalidDiffRequestException("Can't process file: " + output.getPresentableUrl());
            }
            byte[] originalContent = output.contentsToByteArray();
            ArrayList<DiffContent> contents = new ArrayList<DiffContent>(3);
            ArrayList<byte[]> byteContents = new ArrayList<byte[]>(3);
            for (VirtualFile file2 : fileContents) {
                FileContent content = this.myContentFactory.createFile(project2, file2);
                if (content == null) {
                    throw new InvalidDiffRequestException("Can't process file: " + file2.getPresentableUrl());
                }
                contents.add((DiffContent)content);
                byteContents.add(file2.contentsToByteArray());
            }
            return new BinaryMergeRequestImpl(project2, outputContent, originalContent, contents, byteContents, title, contentTitles, applyCallback);
        }
        catch (IOException e) {
            throw new InvalidDiffRequestException("Can't read from file", (Throwable)e);
        }
    }
}

