/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.actions.BaseShowDiffAction;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.Side;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareFileWithEditorAction
extends BaseShowDiffAction {
    @Override
    protected boolean isAvailable(@NotNull AnActionEvent e) {
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e);
        if (selectedFile == null) {
            return false;
        }
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        if (currentFile == null) {
            return false;
        }
        return CompareFileWithEditorAction.canCompare(selectedFile, currentFile);
    }

    @Nullable
    private static VirtualFile getSelectedFile(@NotNull AnActionEvent e) {
        VirtualFile[] array = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (array == null || array.length != 1 || array[0].isDirectory()) {
            return null;
        }
        return array[0];
    }

    @Nullable
    private static VirtualFile getEditingFile(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        return FileEditorManagerEx.getInstanceEx(project2).getCurrentFile();
    }

    private static boolean canCompare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        return !file1.equals(file2) && CompareFileWithEditorAction.hasContent(file1) && CompareFileWithEditorAction.hasContent(file2);
    }

    @Override
    @Nullable
    protected DiffRequest getDiffRequest(@NotNull AnActionEvent e) {
        Editor[] editors;
        Project project2 = e.getProject();
        VirtualFile selectedFile = CompareFileWithEditorAction.getSelectedFile(e);
        VirtualFile currentFile = CompareFileWithEditorAction.getEditingFile(e);
        assert (selectedFile != null && currentFile != null);
        ContentDiffRequest request = DiffRequestFactory.getInstance().createFromFiles(project2, selectedFile, currentFile);
        DiffContent editorContent = (DiffContent)request.getContents().get(1);
        if (editorContent instanceof DocumentContent && (editors = EditorFactory.getInstance().getEditors(((DocumentContent)editorContent).getDocument())).length != 0) {
            request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)editors[0].getCaretModel().getLogicalPosition().line));
        }
        return request;
    }
}

