/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions.impl;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInEditorAction
extends EditSourceAction
implements DumbAware {
    public static final DataKey<OpenInEditorAction> KEY = DataKey.create((String)"DiffOpenInEditorAction");
    @Nullable
    private final Runnable myAfterRunnable;

    public OpenInEditorAction(@Nullable Runnable afterRunnable) {
        ActionUtil.copyFrom((AnAction)this, (String)"EditSource");
        this.myAfterRunnable = afterRunnable;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        DiffContext context;
        if (!ActionPlaces.isToolbarPlace((String)e.getPlace())) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        DiffRequest request = (DiffRequest)e.getData(DiffDataKeys.DIFF_REQUEST);
        if (DiffUtil.isUserDataFlagSet((Key<Boolean>)DiffUserDataKeys.GO_TO_SOURCE_DISABLE, new UserDataHolder[]{request, context = (DiffContext)e.getData(DiffDataKeys.DIFF_CONTEXT)})) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        }
        if (e.getProject() == null) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        Object[] navigatables = (Navigatable[])e.getData(DiffDataKeys.NAVIGATABLE_ARRAY);
        if (navigatables == null || !ContainerUtil.exists((Object[])navigatables, it -> it.canNavigate())) {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Navigatable[] navigatables = (Navigatable[])e.getData(DiffDataKeys.NAVIGATABLE_ARRAY);
        if (navigatables == null) {
            return;
        }
        this.openEditor(project2, navigatables);
    }

    public void openEditor(@NotNull Project project2, @NotNull Navigatable navigatable) {
        this.openEditor(project2, new Navigatable[]{navigatable});
    }

    public void openEditor(@NotNull Project project2, @NotNull Navigatable[] navigatables) {
        boolean success = false;
        for (Navigatable navigatable : navigatables) {
            if (!navigatable.canNavigate()) continue;
            navigatable.navigate(true);
            success = true;
        }
        if (success && this.myAfterRunnable != null) {
            this.myAfterRunnable.run();
        }
    }
}

