/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeLineFragmentImpl;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.fragments.MergeWordFragmentImpl;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.IntPair;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonManagerImpl
extends ComparisonManager {
    private static final Logger LOG = Logger.getInstance(ComparisonManagerImpl.class);

    @NotNull
    public static ComparisonManagerImpl getInstanceImpl() {
        return (ComparisonManagerImpl)ComparisonManagerImpl.getInstance();
    }

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List lineTexts1 = ContainerUtil.map(lines1, Line::getContent);
        List lineTexts2 = ContainerUtil.map(lines2, Line::getContent);
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, policy, indicator);
        return ComparisonManagerImpl.convertIntoLineFragments(lines1, lines2, iterable);
    }

    @NotNull
    public List<MergeLineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull CharSequence text3, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List<Line> lines3 = ComparisonManagerImpl.getLines(text3);
        List lineTexts1 = ContainerUtil.map(lines1, Line::getContent);
        List lineTexts2 = ContainerUtil.map(lines2, Line::getContent);
        List lineTexts3 = ContainerUtil.map(lines3, Line::getContent);
        List<MergeRange> ranges = ByLine.compare(lineTexts1, lineTexts2, lineTexts3, policy, indicator);
        return ComparisonManagerImpl.convertIntoMergeLineFragments(ranges);
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        return ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, policy, indicator);
    }

    private static List<LineFragment> createInnerFragments(@NotNull List<LineFragment> lineFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) {
        ArrayList<LineFragment> result2 = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment fragment : lineFragments) {
            assert (fragment.getInnerFragments() == null);
            try {
                boolean tryComputeDifferences = tooBigChunksCount < 3;
                result2.addAll(ComparisonManagerImpl.createInnerFragments(fragment, text1, text2, policy, indicator, tryComputeDifferences));
            }
            catch (DiffTooBigException e) {
                result2.add(fragment);
                ++tooBigChunksCount;
            }
        }
        return result2;
    }

    @NotNull
    private static List<LineFragment> createInnerFragments(@NotNull LineFragment fragment, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator, boolean tryComputeDifferences) throws DiffTooBigException {
        CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
        CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
        if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
            if (ComparisonUtil.isEquals(subSequence1, subSequence2, policy)) {
                return Collections.singletonList(new LineFragmentImpl(fragment, Collections.emptyList()));
            }
            return Collections.singletonList(fragment);
        }
        if (!tryComputeDifferences) {
            return Collections.singletonList(fragment);
        }
        List<ByWord.LineBlock> lineBlocks = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
        assert (lineBlocks.size() != 0);
        int startOffset1 = fragment.getStartOffset1();
        int startOffset2 = fragment.getStartOffset2();
        int currentStartLine1 = fragment.getStartLine1();
        int currentStartLine2 = fragment.getStartLine2();
        ArrayList<LineFragment> chunks = new ArrayList<LineFragment>();
        for (int i2 = 0; i2 < lineBlocks.size(); ++i2) {
            ByWord.LineBlock block = lineBlocks.get(i2);
            Range offsets = block.offsets;
            int currentEndLine1 = i2 != lineBlocks.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
            int currentEndLine2 = i2 != lineBlocks.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
            chunks.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets.start1 + startOffset1, offsets.end1 + startOffset1, offsets.start2 + startOffset2, offsets.end2 + startOffset2, block.fragments));
            currentStartLine1 = currentEndLine1;
            currentStartLine2 = currentEndLine2;
        }
        return chunks;
    }

    @Deprecated
    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<LineFragment> lineFragments, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return this.compareLinesInner(text1, text2, policy, indicator);
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        return ByWord.compare(text1, text2, policy, indicator);
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            return ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareIgnoreWhitespaces(text1, text2, indicator));
        }
        if (policy == ComparisonPolicy.DEFAULT) {
            return ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareTwoStep(text1, text2, indicator));
        }
        LOG.warn(policy.toString() + " is not supported by ByChar comparison");
        return ComparisonManagerImpl.convertIntoDiffFragments(ByChar.compareTwoStep(text1, text2, indicator));
    }

    @NotNull
    public List<Range> compareLines(@NotNull List<? extends CharSequence> lines1, @NotNull List<? extends CharSequence> lines2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        FairDiffIterable iterable = ByLine.compare(lines1, lines2, policy, indicator);
        return ContainerUtil.newArrayList(iterable.iterateChanges());
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        return ComparisonUtil.isEquals(text1, text2, policy);
    }

    @NotNull
    public static List<DiffFragment> convertIntoDiffFragments(@NotNull DiffIterable changes) {
        ArrayList<DiffFragment> fragments = new ArrayList<DiffFragment>();
        for (Range ch : changes.iterateChanges()) {
            fragments.add((DiffFragment)new DiffFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2));
        }
        return fragments;
    }

    @NotNull
    public static List<LineFragment> convertIntoLineFragments(@NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull FairDiffIterable changes) {
        ArrayList<LineFragment> fragments = new ArrayList<LineFragment>();
        for (Range ch : changes.iterateChanges()) {
            IntPair offsets1 = ComparisonManagerImpl.getOffsets(lines1, ch.start1, ch.end1);
            IntPair offsets2 = ComparisonManagerImpl.getOffsets(lines2, ch.start2, ch.end2);
            fragments.add((LineFragment)new LineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, offsets1.val1, offsets1.val2, offsets2.val1, offsets2.val2));
        }
        return fragments;
    }

    @NotNull
    private static IntPair getOffsets(@NotNull List<Line> lines, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            int offset = startIndex < lines.size() ? lines.get(startIndex).getOffset1() : lines.get(lines.size() - 1).getOffset2();
            return new IntPair(offset, offset);
        }
        int offset1 = lines.get(startIndex).getOffset1();
        int offset2 = lines.get(endIndex - 1).getOffset2();
        return new IntPair(offset1, offset2);
    }

    @NotNull
    public static List<MergeLineFragment> convertIntoMergeLineFragments(@NotNull List<MergeRange> conflicts) {
        return ContainerUtil.map(conflicts, ch -> new MergeLineFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, ch.start3, ch.end3));
    }

    @NotNull
    public static List<MergeWordFragment> convertIntoMergeWordFragments(@NotNull List<MergeRange> conflicts) {
        return ContainerUtil.map(conflicts, ch -> new MergeWordFragmentImpl(ch.start1, ch.end1, ch.start2, ch.end2, ch.start3, ch.end3));
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments.isEmpty()) {
            return oldFragments;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> newFragments.add(ComparisonManagerImpl.doSquash(fragments))));
        return newFragments;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        if (!squash && !trim) {
            return oldFragments;
        }
        if (oldFragments.isEmpty()) {
            return oldFragments;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim))));
        return newFragments;
    }

    private static void processAdjoining(@NotNull List<LineFragment> oldFragments, @NotNull Consumer<List<LineFragment>> consumer2) {
        int startIndex = 0;
        for (int i2 = 1; i2 < oldFragments.size(); ++i2) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i2 - 1), oldFragments.get(i2))) continue;
            consumer2.consume(oldFragments.subList(startIndex, i2));
            startIndex = i2;
        }
        if (startIndex < oldFragments.size()) {
            consumer2.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<LineFragment> processAdjoining(@NotNull List<LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start;
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start = 0; start < end; ++start) {
                fragment = fragments.get(start);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
            }
            while (start < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
                --end;
            }
        }
        if (start == end) {
            return Collections.emptyList();
        }
        if (squash) {
            return Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start, end)));
        }
        return fragments.subList(start, end);
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<LineFragment> oldFragments) {
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            return oldFragments.get(0);
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment fragment : oldFragments) {
            for (DiffFragment innerFragment : ComparisonManagerImpl.extractInnerFragments(fragment)) {
                int shift1 = fragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = fragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, innerFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(innerFragment.getStartOffset1() + shift1, innerFragment.getEndOffset1() + shift1, innerFragment.getStartOffset2() + shift2, innerFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), innerFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), innerFragment.getEndOffset2() + shift2));
            }
        }
        return new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment.getInnerFragments() != null) {
            return lineFragment.getInnerFragments();
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        return Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
    }

    @NotNull
    private static List<Line> getLines(@NotNull CharSequence text) {
        int lineEnd;
        ArrayList<Line> lines = new ArrayList<Line>();
        int offset = 0;
        while ((lineEnd = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)offset)) != -1) {
            lines.add(new Line(text, offset, lineEnd, true));
            offset = lineEnd + 1;
        }
        lines.add(new Line(text, offset, text.length(), false));
        return lines;
    }

    @NotNull
    public List<LineFragment> compareLinesWithIgnoredRanges(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<TextRange> ignoredRanges1, @NotNull List<TextRange> ignoredRanges2, boolean innerFragments, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        BitSet ignored1 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges1);
        BitSet ignored2 = ComparisonManagerImpl.collectIgnoredRanges(ignoredRanges2);
        List<Line> lines1 = ComparisonManagerImpl.getLines(text1);
        List<Line> lines2 = ComparisonManagerImpl.getLines(text2);
        List lineTexts1 = ContainerUtil.map(lines1, line -> line.getNotIgnoredContent(ignored1));
        List lineTexts2 = ContainerUtil.map(lines2, line -> line.getNotIgnoredContent(ignored2));
        FairDiffIterable iterable = ByLine.compare(lineTexts1, lineTexts2, ComparisonPolicy.DEFAULT, indicator);
        List<LineFragment> lineFragments = ComparisonManagerImpl.convertIntoLineFragments(lines1, lines2, iterable);
        if (innerFragments) {
            lineFragments = ComparisonManagerImpl.createInnerFragments(lineFragments, text1, text2, ComparisonPolicy.DEFAULT, indicator);
        }
        return ContainerUtil.mapNotNull(lineFragments, fragment -> ComparisonManagerImpl.trimIgnoredChanges(fragment, lines1, lines2, ignored1, ignored2));
    }

    @NotNull
    private static BitSet collectIgnoredRanges(@NotNull List<TextRange> ignoredRanges) {
        BitSet set2 = new BitSet();
        for (TextRange range : ignoredRanges) {
            set2.set(range.getStartOffset(), range.getEndOffset());
        }
        return set2;
    }

    @Nullable
    private static LineFragment trimIgnoredChanges(@NotNull LineFragment fragment, @NotNull List<Line> lines1, @NotNull List<Line> lines2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        Range range = TrimUtil.trimExpandList(lines1, lines2, fragment.getStartLine1(), fragment.getStartLine2(), fragment.getEndLine1(), fragment.getEndLine2(), (line1, line2) -> ComparisonManagerImpl.areIgnoredEqualLines(line1, line2, ignored1, ignored2), line -> ComparisonManagerImpl.isIgnoredLine(line, ignored1), line -> ComparisonManagerImpl.isIgnoredLine(line, ignored2));
        int startLine1 = range.start1;
        int startLine2 = range.start2;
        int endLine1 = range.end1;
        int endLine2 = range.end2;
        if (startLine1 == endLine1 && startLine2 == endLine2) {
            return null;
        }
        IntPair offsets1 = ComparisonManagerImpl.getOffsets(lines1, startLine1, endLine1);
        IntPair offsets2 = ComparisonManagerImpl.getOffsets(lines2, startLine2, endLine2);
        int startOffset1 = offsets1.val1;
        int endOffset1 = offsets1.val2;
        int startOffset2 = offsets2.val1;
        int endOffset2 = offsets2.val2;
        List newInner = null;
        if (fragment.getInnerFragments() != null) {
            int shift1 = startOffset1 - fragment.getStartOffset1();
            int shift2 = startOffset2 - fragment.getStartOffset2();
            int newCount1 = endOffset1 - startOffset1;
            int newCount2 = endOffset2 - startOffset2;
            newInner = ContainerUtil.mapNotNull((Collection)fragment.getInnerFragments(), it -> {
                int start1 = DiffUtil.bound(it.getStartOffset1() - shift1, 0, newCount1);
                int start2 = DiffUtil.bound(it.getStartOffset2() - shift2, 0, newCount2);
                int end1 = DiffUtil.bound(it.getEndOffset1() - shift1, 0, newCount1);
                int end2 = DiffUtil.bound(it.getEndOffset2() - shift2, 0, newCount2);
                TextRange range1 = ComparisonManagerImpl.trimIgnoredRange(start1, end1, ignored1, startOffset1);
                TextRange range2 = ComparisonManagerImpl.trimIgnoredRange(start2, end2, ignored2, startOffset2);
                if (range1.isEmpty() && range2.isEmpty()) {
                    return null;
                }
                return new DiffFragmentImpl(range1.getStartOffset(), range1.getEndOffset(), range2.getStartOffset(), range2.getEndOffset());
            });
            if (newInner.isEmpty()) {
                return null;
            }
        }
        return new LineFragmentImpl(startLine1, endLine1, startLine2, endLine2, startOffset1, endOffset1, startOffset2, endOffset2, newInner);
    }

    private static boolean isIgnoredLine(@NotNull Line line, @NotNull BitSet ignored) {
        return ComparisonManagerImpl.trimIgnoredRange(line.getOffset1(), line.getOffset2(), ignored, 0).isEmpty();
    }

    private static boolean areIgnoredEqualLines(@NotNull Line line1, @NotNull Line line2, @NotNull BitSet ignored1, @NotNull BitSet ignored2) {
        int start1 = line1.getOffset1();
        int end1 = line1.getOffset2();
        int start2 = line2.getOffset1();
        int end2 = line2.getOffset2();
        Range range = TrimUtil.trimExpandText(line1.getOriginalText(), line2.getOriginalText(), start1, start2, end1, end2, ignored1, ignored2);
        return range.isEmpty();
    }

    @NotNull
    private static TextRange trimIgnoredRange(int start, int end, @NotNull BitSet ignored, int offset) {
        IntPair intPair = TrimUtil.trim(offset + start, offset + end, ignored);
        return new TextRange(intPair.val1 - offset, intPair.val2 - offset);
    }

    private static class Line {
        @NotNull
        private final CharSequence myChars;
        private final int myOffset1;
        private final int myOffset2;
        private final boolean myNewline;

        public Line(@NotNull CharSequence chars, int offset1, int offset2, boolean newline) {
            this.myChars = chars;
            this.myOffset1 = offset1;
            this.myOffset2 = offset2;
            this.myNewline = newline;
        }

        public int getOffset1() {
            return this.myOffset1;
        }

        public int getOffset2() {
            return this.myOffset2 + (this.myNewline ? 1 : 0);
        }

        @NotNull
        public CharSequence getContent() {
            return new CharSequenceSubSequence(this.myChars, this.myOffset1, this.myOffset2);
        }

        @NotNull
        public CharSequence getNotIgnoredContent(@NotNull BitSet ignored) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = this.myOffset1; i2 < this.myOffset2; ++i2) {
                if (ignored.get(i2)) continue;
                sb.append(this.myChars.charAt(i2));
            }
            return sb.toString();
        }

        @NotNull
        public CharSequence getOriginalText() {
            return this.myChars;
        }
    }
}

