/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.MergeResolveUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComparisonMergeUtil {
    @NotNull
    public static List<MergeRange> buildFair(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull ProgressIndicator indicator) {
        assert (fragments1.getLength1() == fragments2.getLength1());
        return new FairMergeBuilder().execute(fragments1, fragments2);
    }

    @Nullable
    public static CharSequence tryResolveConflict(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        if (Registry.is((String)"diff.merge.resolve.conflict.action.use.greedy.approach")) {
            return MergeResolveUtil.tryGreedyResolve(leftText, baseText, rightText);
        }
        return MergeResolveUtil.tryResolve(leftText, baseText, rightText);
    }

    private static class PeekIterator<T> {
        @NotNull
        private final Iterator<T> myIterator;
        private T myValue = null;

        public PeekIterator(@NotNull Iterator<T> iterator) {
            this.myIterator = iterator;
            this.advance();
        }

        public boolean atEnd() {
            return this.myValue == null;
        }

        public boolean hasNext() {
            return this.myIterator.hasNext();
        }

        public T peek() {
            return this.myValue;
        }

        public void advance() {
            this.myValue = this.myIterator.hasNext() ? this.myIterator.next() : null;
        }
    }

    private static class ChangeBuilder {
        @NotNull
        private final List<MergeRange> myChanges = new ArrayList<MergeRange>();
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private int myIndex3 = 0;

        private ChangeBuilder() {
        }

        private void addChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            if (start1 == end1 && start2 == end2 && start3 == end3) {
                return;
            }
            this.myChanges.add(new MergeRange(start1, end1, start2, end2, start3, end3));
        }

        public void markEqual(int start1, int start2, int start3, int end1, int end2, int end3) {
            assert (this.myIndex1 <= start1);
            assert (this.myIndex2 <= start2);
            assert (this.myIndex3 <= start3);
            assert (start1 <= end1);
            assert (start2 <= end2);
            assert (start3 <= end3);
            this.addChange(this.myIndex1, this.myIndex2, this.myIndex3, start1, start2, start3);
            this.myIndex1 = end1;
            this.myIndex2 = end2;
            this.myIndex3 = end3;
        }

        @NotNull
        public List<MergeRange> finish(int length1, int length2, int length3) {
            assert (this.myIndex1 <= length1);
            assert (this.myIndex2 <= length2);
            assert (this.myIndex3 <= length3);
            this.addChange(this.myIndex1, this.myIndex2, this.myIndex3, length1, length2, length3);
            return this.myChanges;
        }
    }

    private static class FairMergeBuilder {
        @NotNull
        private final ChangeBuilder myChangesBuilder = new ChangeBuilder();

        private FairMergeBuilder() {
        }

        @NotNull
        public List<MergeRange> execute(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2) {
            PeekIterator<Range> unchanged1 = new PeekIterator<Range>(fragments1.unchanged());
            PeekIterator<Range> unchanged2 = new PeekIterator<Range>(fragments2.unchanged());
            while (!unchanged1.atEnd() && !unchanged2.atEnd()) {
                Side side = this.add(unchanged1.peek(), unchanged2.peek());
                ((PeekIterator)side.select(unchanged1, unchanged2)).advance();
            }
            return this.finish(fragments1, fragments2);
        }

        @NotNull
        private Side add(@NotNull Range range1, @NotNull Range range2) {
            int start1 = range1.start1;
            int end1 = range1.end1;
            int start2 = range2.start1;
            int end2 = range2.end1;
            if (end1 <= start2) {
                return Side.LEFT;
            }
            if (end2 <= start1) {
                return Side.RIGHT;
            }
            int startBase = Math.max(start1, start2);
            int endBase = Math.min(end1, end2);
            int startShift1 = startBase - start1;
            int endCut1 = end1 - endBase;
            int startShift2 = startBase - start2;
            int endCut2 = end2 - endBase;
            int startLeft = range1.start2 + startShift1;
            int endLeft = range1.end2 - endCut1;
            int startRight = range2.start2 + startShift2;
            int endRight = range2.end2 - endCut2;
            this.myChangesBuilder.markEqual(startLeft, startBase, startRight, endLeft, endBase, endRight);
            return Side.fromLeft((end1 <= end2 ? 1 : 0) != 0);
        }

        @NotNull
        private List<MergeRange> finish(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2) {
            int length1 = fragments1.getLength2();
            int length2 = fragments1.getLength1();
            int length3 = fragments2.getLength2();
            return this.myChangesBuilder.finish(length1, length2, length3);
        }
    }
}

