/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.Helper;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\r\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a*\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"tryGreedyResolve", "", "leftText", "baseText", "rightText", "policy", "Lcom/intellij/diff/comparison/ComparisonPolicy;", "tryResolve", "diff-impl"})
public final class MergeResolveUtilKt {
    private static final CharSequence tryResolve(CharSequence leftText, CharSequence baseText, CharSequence rightText, ComparisonPolicy policy) {
        List texts = CollectionsKt.listOf((Object[])new CharSequence[]{leftText, baseText, rightText});
        List<MergeWordFragment> changes = ByWord.compare(leftText, baseText, rightText, policy, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        StringBuilder newContent = new StringBuilder();
        int last = 0;
        for (MergeWordFragment fragment : changes) {
            MergeConflictType type2 = DiffUtil.getWordMergeType(fragment, texts, policy);
            if (Intrinsics.areEqual((Object)type2.getDiffType(), (Object)TextDiffType.CONFLICT)) {
                return null;
            }
            int baseStart = fragment.getStartOffset(ThreeSide.BASE);
            int baseEnd = fragment.getEndOffset(ThreeSide.BASE);
            newContent.append(baseText, last, baseStart);
            if (type2.isChange(Side.LEFT)) {
                int leftStart = fragment.getStartOffset(ThreeSide.LEFT);
                int leftEnd = fragment.getEndOffset(ThreeSide.LEFT);
                newContent.append(leftText, leftStart, leftEnd);
            } else {
                int rightStart = fragment.getStartOffset(ThreeSide.RIGHT);
                int rightEnd = fragment.getEndOffset(ThreeSide.RIGHT);
                newContent.append(rightText, rightStart, rightEnd);
            }
            last = baseEnd;
        }
        newContent.append(baseText, last, baseText.length());
        return newContent.toString();
    }

    private static final CharSequence tryGreedyResolve(CharSequence leftText, CharSequence baseText, CharSequence rightText, ComparisonPolicy policy) {
        return new Helper(leftText, baseText, rightText).execute(policy);
    }

    @Nullable
    public static final /* synthetic */ CharSequence access$tryResolve(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText, @NotNull ComparisonPolicy policy) {
        return MergeResolveUtilKt.tryResolve(leftText, baseText, rightText, policy);
    }

    @Nullable
    public static final /* synthetic */ CharSequence access$tryGreedyResolve(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText, @NotNull ComparisonPolicy policy) {
        return MergeResolveUtilKt.tryGreedyResolve(leftText, baseText, rightText, policy);
    }
}

