/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryContentImpl
extends DiffContentBase
implements DirectoryContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;

    public DirectoryContentImpl(@Nullable Project project2, @NotNull VirtualFile file2) {
        assert (file2.isValid() && file2.isDirectory());
        this.myProject = project2;
        this.myFile = file2;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (this.myProject == null || this.myProject.isDefault() || !this.myFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myFile);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public FileType getContentType() {
        return null;
    }
}

