/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends DiffContentBase
implements FileContent {
    @NotNull
    private final VirtualFile myFile;
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileType myType;
    @Nullable
    private final VirtualFile myHighlightFile;

    public FileContentImpl(@Nullable Project project2, @NotNull VirtualFile file2) {
        this(project2, file2, FileContentImpl.getHighlightFile(file2));
    }

    public FileContentImpl(@Nullable Project project2, @NotNull VirtualFile file2, @Nullable VirtualFile highlightFile) {
        assert (file2.isValid() && !file2.isDirectory());
        this.myFile = file2;
        this.myProject = project2;
        this.myType = file2.getFileType();
        this.myHighlightFile = highlightFile;
    }

    @Nullable
    public Navigatable getNavigatable() {
        if (this.myProject == null || this.myProject.isDefault()) {
            return null;
        }
        if (this.myHighlightFile == null || !this.myHighlightFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myHighlightFile);
    }

    @Nullable
    private static VirtualFile getHighlightFile(@NotNull VirtualFile file2) {
        if (file2.isInLocalFileSystem()) {
            return file2;
        }
        return null;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public FileType getContentType() {
        return this.myType;
    }

    @NotNull
    public String getFilePath() {
        return this.myFile.getPath();
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }
}

