/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineCol;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentImpl
implements FileContent {
    @NotNull
    private final VirtualFile myFile;

    public FileDocumentContentImpl(@Nullable Project project2, @NotNull Document document, @NotNull VirtualFile file2) {
        super(project2, document, file2.getFileType(), file2, FileDocumentContentImpl.getSeparator(file2), file2.getCharset(), file2.getBOM() != null);
        this.myFile = file2;
    }

    @Override
    @Nullable
    public Navigatable getNavigatable(@NotNull LineCol position) {
        Project project2 = this.getProject();
        if (!DiffUtil.canNavigateToFile(project2, this.myFile)) {
            return null;
        }
        return new OpenFileDescriptor(project2, this.myFile, position.line, position.column);
    }

    @Nullable
    private static LineSeparator getSeparator(@NotNull VirtualFile file2) {
        String s = LoadTextUtil.detectLineSeparator(file2, true);
        if (s == null) {
            return null;
        }
        return LineSeparator.fromString((String)s);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            DiffUtil.markDirtyAndRefresh(true, false, false, this.myFile);
        }
    }
}

