/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.ErrorDiffRequest;
import com.intellij.diff.requests.LoadingDiffRequest;
import com.intellij.diff.requests.NoDiffRequest;
import com.intellij.diff.requests.OperationCanceledDiffRequest;
import com.intellij.diff.tools.util.SoftHardCacheMap;
import com.intellij.diff.util.DiffTaskQueue;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Function;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheDiffRequestProcessor<T>
extends DiffRequestProcessor {
    private static final Logger LOG = Logger.getInstance(CacheDiffRequestProcessor.class);
    @NotNull
    private final SoftHardCacheMap<T, DiffRequest> myRequestCache = new SoftHardCacheMap(5, 5);
    @NotNull
    private final DiffTaskQueue myQueue = new DiffTaskQueue();

    public CacheDiffRequestProcessor(@Nullable Project project2) {
        super(project2);
    }

    public CacheDiffRequestProcessor(@Nullable Project project2, @NotNull String place) {
        super(project2, place);
    }

    public CacheDiffRequestProcessor(@Nullable Project project2, @NotNull UserDataHolder context) {
        super(project2, context);
    }

    @Nullable
    protected abstract String getRequestName(@NotNull T var1);

    protected abstract T getCurrentRequestProvider();

    @NotNull
    protected abstract DiffRequest loadRequest(@NotNull T var1, @NotNull ProgressIndicator var2) throws ProcessCanceledException, DiffRequestProducerException;

    @Override
    protected void reloadRequest() {
        this.updateRequest(true, false, null);
    }

    @Override
    public void updateRequest(boolean force, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        this.updateRequest(force, true, scrollToChangePolicy);
    }

    public void updateRequest(boolean force, boolean useCache, @Nullable DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
        DiffRequest cachedRequest;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.isDisposed()) {
            return;
        }
        T requestProvider = this.getCurrentRequestProvider();
        if (requestProvider == null) {
            this.applyRequest((DiffRequest)NoDiffRequest.INSTANCE, force, scrollToChangePolicy);
            return;
        }
        DiffRequest diffRequest = cachedRequest = useCache ? this.loadRequestFast(requestProvider) : null;
        if (cachedRequest != null) {
            this.applyRequest(cachedRequest, force, scrollToChangePolicy);
            return;
        }
        this.myQueue.executeAndTryWait((Function<ProgressIndicator, Runnable>)((Function)indicator -> {
            DiffRequest request = this.doLoadRequest(requestProvider, (ProgressIndicator)indicator);
            return () -> {
                this.myRequestCache.put(requestProvider, request);
                this.applyRequest(request, force, scrollToChangePolicy);
            };
        }), () -> this.applyRequest((DiffRequest)new LoadingDiffRequest(this.getRequestName(requestProvider)), force, scrollToChangePolicy), 300L);
    }

    @Nullable
    protected DiffRequest loadRequestFast(@NotNull T provider2) {
        return this.myRequestCache.get(provider2);
    }

    @NotNull
    private DiffRequest doLoadRequest(@NotNull T provider2, @NotNull ProgressIndicator indicator) {
        String name = this.getRequestName(provider2);
        try {
            return this.loadRequest(provider2, indicator);
        }
        catch (ProcessCanceledException e) {
            OperationCanceledDiffRequest request = new OperationCanceledDiffRequest(name);
            request.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, Collections.singletonList(new ReloadRequestAction(provider2)));
            return request;
        }
        catch (DiffRequestProducerException e) {
            return new ErrorDiffRequest(name, (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return new ErrorDiffRequest(name, (Throwable)e);
        }
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        this.myQueue.abort();
        this.myRequestCache.clear();
    }

    protected class ReloadRequestAction
    extends DumbAwareAction {
        @NotNull
        private final T myProducer;

        public ReloadRequestAction(T provider2) {
            super("Reload", null, AllIcons.Actions.Refresh);
            this.myProducer = provider2;
        }

        public void actionPerformed(AnActionEvent e) {
            CacheDiffRequestProcessor.this.myRequestCache.remove(this.myProducer);
            CacheDiffRequestProcessor.this.updateRequest(true);
        }
    }
}

