/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.lang;

import com.intellij.diff.lang.LangDiffIgnoredRangeProvider;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaDiffIgnoredRangeProvider
extends LangDiffIgnoredRangeProvider {
    @Override
    @NotNull
    public String getDescription() {
        return "Ignore imports and formatting";
    }

    @Override
    protected boolean accepts(@NotNull Project project2, @NotNull Language language) {
        return JavaLanguage.INSTANCE.equals(language);
    }

    @Override
    @NotNull
    protected List<TextRange> computeIgnoredRanges(@NotNull Project project2, @NotNull CharSequence text, @NotNull Language language) {
        return (List)ReadAction.compute(() -> {
            final ArrayList result2 = new ArrayList();
            PsiFile psiFile = PsiFileFactory.getInstance((Project)project2).createFileFromText("", language, text);
            psiFile.accept(new PsiElementVisitor(){

                public void visitElement(PsiElement element) {
                    if (element.getTextLength() == 0) {
                        return;
                    }
                    if (JavaDiffIgnoredRangeProvider.isIgnored(element)) {
                        result2.add(element.getTextRange());
                    } else {
                        element.acceptChildren((PsiElementVisitor)this);
                    }
                }
            });
            return result2;
        });
    }

    private static boolean isIgnored(@NotNull PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        return element instanceof PsiImportList;
    }
}

