/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffContext;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.merge.MergeContext;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeTool;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergeUtil {
    @NotNull
    public static Action createSimpleResolveAction(final @NotNull MergeResult result2, final @NotNull MergeRequest request, final @NotNull MergeContext context, final @NotNull MergeTool.MergeViewer viewer) {
        String caption = MergeUtil.getResolveActionTitle(result2, request, context);
        return new AbstractAction(caption){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (result2 == MergeResult.CANCEL && !MergeUtil.showExitWithoutApplyingChangesDialog(viewer, request, context)) {
                    return;
                }
                context.finishMerge(result2);
            }
        };
    }

    @NotNull
    public static String getResolveActionTitle(@NotNull MergeResult result2, @NotNull MergeRequest request, @NotNull MergeContext context) {
        String message2;
        Function<MergeResult, String> getter = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_ACTION_CAPTIONS);
        String string = message2 = getter != null ? (String)getter.fun((Object)result2) : null;
        if (message2 != null) {
            return message2;
        }
        switch (result2) {
            case CANCEL: {
                return "Abort";
            }
            case LEFT: {
                return "Accept Left";
            }
            case RIGHT: {
                return "Accept Right";
            }
            case RESOLVED: {
                return "Apply";
            }
        }
        throw new IllegalArgumentException(result2.toString());
    }

    @NotNull
    public static List<String> notNullizeContentTitles(@NotNull List<String> mergeContentTitles) {
        String left = StringUtil.notNullize((String)((String)ThreeSide.LEFT.select(mergeContentTitles)), (String)"Your Version");
        String base = StringUtil.notNullize((String)((String)ThreeSide.BASE.select(mergeContentTitles)), (String)"Base Version");
        String right = StringUtil.notNullize((String)((String)ThreeSide.RIGHT.select(mergeContentTitles)), (String)"Server Version");
        return ContainerUtil.list((Object[])new String[]{left, base, right});
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull MergeTool.MergeViewer viewer, @NotNull MergeRequest request, @NotNull MergeContext context) {
        Condition<MergeTool.MergeViewer> customHandler = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_HANDLER);
        if (customHandler != null) {
            return customHandler.value((Object)viewer);
        }
        return MergeUtil.showExitWithoutApplyingChangesDialog(viewer.getComponent(), request, context);
    }

    public static boolean showExitWithoutApplyingChangesDialog(@NotNull JComponent component, @NotNull MergeRequest request, @NotNull MergeContext context) {
        String message2 = DiffBundle.message((String)"merge.dialog.exit.without.applying.changes.confirmation.message", (Object[])new Object[0]);
        String title = DiffBundle.message((String)"cancel.visual.merge.dialog.title", (Object[])new Object[0]);
        Couple<String> customMessage = DiffUtil.getUserData((UserDataHolder)request, (UserDataHolder)context, DiffUserDataKeysEx.MERGE_CANCEL_MESSAGE);
        if (customMessage != null) {
            title = (String)customMessage.first;
            message2 = (String)customMessage.second;
        }
        return Messages.showYesNoDialog((Component)component.getRootPane(), (String)message2, (String)title, (Icon)Messages.getQuestionIcon()) == 0;
    }

    public static void putRevisionInfos(@NotNull MergeRequest request, @NotNull MergeData data) {
        if (request instanceof ThreesideMergeRequest) {
            List contents = ((ThreesideMergeRequest)request).getContents();
            MergeUtil.putRevisionInfo(contents, data);
        }
    }

    public static void putRevisionInfos(@NotNull DiffRequest request, @NotNull MergeData data) {
        List contents;
        if (request instanceof ContentDiffRequest && (contents = ((ContentDiffRequest)request).getContents()).size() == 3) {
            MergeUtil.putRevisionInfo(contents, data);
        }
    }

    private static void putRevisionInfo(@NotNull List<? extends DiffContent> contents, @NotNull MergeData data) {
        for (ThreeSide side : ThreeSide.values()) {
            DiffContent content = (DiffContent)side.select(contents);
            FilePath filePath = (FilePath)side.select((Object)data.CURRENT_FILE_PATH, (Object)data.ORIGINAL_FILE_PATH, (Object)data.LAST_FILE_PATH);
            VcsRevisionNumber revision = (VcsRevisionNumber)side.select((Object)data.CURRENT_REVISION_NUMBER, (Object)data.ORIGINAL_REVISION_NUMBER, (Object)data.LAST_REVISION_NUMBER);
            if (filePath == null || revision == null) continue;
            content.putUserData(DiffUserDataKeysEx.REVISION_INFO, (Object)Pair.create((Object)filePath, (Object)revision));
        }
    }

    public static class ProxyDiffContext
    extends DiffContext {
        @NotNull
        private final MergeContext myMergeContext;

        public ProxyDiffContext(@NotNull MergeContext mergeContext) {
            this.myMergeContext = mergeContext;
        }

        @Nullable
        public Project getProject() {
            return this.myMergeContext.getProject();
        }

        public boolean isWindowFocused() {
            return true;
        }

        public boolean isFocused() {
            return this.myMergeContext.isFocused();
        }

        public void requestFocus() {
            this.myMergeContext.requestFocus();
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key2) {
            return (T)this.myMergeContext.getUserData(key2);
        }

        public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
            this.myMergeContext.putUserData(key2, value2);
        }
    }
}

