/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.settings;

import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.jetbrains.annotations.NotNull;

public class DiffSettingsPanel {
    private JPanel myPane;
    private ContextRangePanel myContextRangeComponent;
    private JCheckBox myGoToNextFileOnNextDifferenceCheckbox;
    private JCheckBox myAutoApplyNonConflictedChangesCheckbox;
    private JCheckBox myMergeLstGutterMarkers;
    @NotNull
    private TextDiffSettingsHolder.TextDiffSettings myTextSettings;
    @NotNull
    private DiffSettingsHolder.DiffSettings myDiffSettings;

    public DiffSettingsPanel() {
        this.$$$setupUI$$$();
        this.myTextSettings = TextDiffSettingsHolder.TextDiffSettings.getSettings();
        this.myDiffSettings = DiffSettingsHolder.DiffSettings.getSettings();
    }

    @NotNull
    public JComponent getPanel() {
        return this.myPane;
    }

    public boolean isModified() {
        if (this.myContextRangeComponent.isModified()) {
            return true;
        }
        if (this.myGoToNextFileOnNextDifferenceCheckbox.isSelected() != this.myDiffSettings.isGoToNextFileOnNextDifference()) {
            return true;
        }
        if (this.myAutoApplyNonConflictedChangesCheckbox.isSelected() != this.myTextSettings.isAutoApplyNonConflictedChanges()) {
            return true;
        }
        return this.myMergeLstGutterMarkers.isSelected() != this.myTextSettings.isEnableLstGutterMarkersInMerge();
    }

    public void apply() {
        this.myContextRangeComponent.apply();
        this.myDiffSettings.setGoToNextFileOnNextDifference(this.myGoToNextFileOnNextDifferenceCheckbox.isSelected());
        this.myTextSettings.setAutoApplyNonConflictedChanges(this.myAutoApplyNonConflictedChangesCheckbox.isSelected());
        this.myTextSettings.setEnableLstGutterMarkersInMerge(this.myMergeLstGutterMarkers.isSelected());
    }

    public void reset() {
        this.myContextRangeComponent.reset();
        this.myGoToNextFileOnNextDifferenceCheckbox.setSelected(this.myDiffSettings.isGoToNextFileOnNextDifference());
        this.myAutoApplyNonConflictedChangesCheckbox.setSelected(this.myTextSettings.isAutoApplyNonConflictedChanges());
        this.myMergeLstGutterMarkers.setSelected(this.myTextSettings.isEnableLstGutterMarkersInMerge());
    }

    private void createUIComponents() {
        this.myContextRangeComponent = new ContextRangePanel();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JPanel jPanel;
        this.createUIComponents();
        this.myPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText("Diff");
        jPanel.add((Component)titledSeparator, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Context lines:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ContextRangePanel contextRangePanel = this.myContextRangeComponent;
        jPanel.add((Component)contextRangePanel, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myGoToNextFileOnNextDifferenceCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Go to the next file after reaching last change");
        jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText("Merge");
        jPanel.add((Component)titledSeparator2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        this.myAutoApplyNonConflictedChangesCheckbox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Automatically apply non-conflicting changes");
        jPanel.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMergeLstGutterMarkers = jCheckBox = new JCheckBox();
        jCheckBox.setText("Highlight modified lines in gutter");
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPane;
    }

    protected class ContextRangePanel
    extends JSlider {
        public ContextRangePanel() {
            super(0, 0, TextDiffSettingsHolder.CONTEXT_RANGE_MODES.length - 1, 0);
            this.setMinorTickSpacing(1);
            this.setPaintTicks(true);
            this.setPaintTrack(true);
            this.setSnapToTicks(true);
            UIUtil.setSliderIsFilled((JSlider)this, (boolean)true);
            this.setPaintLabels(true);
            Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            for (int i2 = 0; i2 < TextDiffSettingsHolder.CONTEXT_RANGE_MODES.length; ++i2) {
                ((Dictionary)sliderLabels).put(i2, new JLabel(TextDiffSettingsHolder.CONTEXT_RANGE_MODE_LABELS[i2]));
            }
            this.setLabelTable(sliderLabels);
        }

        public void apply() {
            DiffSettingsPanel.this.myTextSettings.setContextRange(this.getContextRange());
        }

        public void reset() {
            this.setContextRange(DiffSettingsPanel.this.myTextSettings.getContextRange());
        }

        public boolean isModified() {
            return this.getContextRange() != DiffSettingsPanel.this.myTextSettings.getContextRange();
        }

        private int getContextRange() {
            return TextDiffSettingsHolder.CONTEXT_RANGE_MODES[this.getValue()];
        }

        private void setContextRange(int value2) {
            for (int i2 = 0; i2 < TextDiffSettingsHolder.CONTEXT_RANGE_MODES.length; ++i2) {
                int mark = TextDiffSettingsHolder.CONTEXT_RANGE_MODES[i2];
                if (mark != value2) continue;
                this.setValue(i2);
            }
        }
    }
}

