/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.holders.BinaryEditorHolder;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.TransferableFileEditorStateSupport;
import com.intellij.diff.tools.util.side.OnesideDiffViewer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnesideBinaryDiffViewer
extends OnesideDiffViewer<BinaryEditorHolder> {
    @NotNull
    private final TransferableFileEditorStateSupport myTransferableStateSupport;

    public OnesideBinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        super(context, (ContentDiffRequest)request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
        this.myTransferableStateSupport = new TransferableFileEditorStateSupport(DiffUtil.getDiffSettings(context), Collections.singletonList(this.getEditorHolder()), (Disposable)this);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myTransferableStateSupport.processContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myTransferableStateSupport.updateContextHints((DiffRequest)this.myRequest, this.myContext);
    }

    @Override
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(this.myTransferableStateSupport.createToggleAction());
        group.addAll(super.createToolbarActions());
        return group;
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        JComponent notification = (JComponent)this.getSide().select((Object)DiffNotifications.createRemovedContent(), (Object)DiffNotifications.createInsertedContent());
        return this.applyNotification(notification);
    }

    @NotNull
    private Runnable applyNotification(@Nullable JComponent notification) {
        return () -> {
            this.clearDiffPresentation();
            if (notification != null) {
                this.myPanel.addNotification(notification);
            }
        };
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
    }

    @NotNull
    FileEditor getEditor() {
        return ((BinaryEditorHolder)this.getEditorHolder()).getEditor();
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        return OnesideDiffViewer.canShowRequest(context, request, BinaryEditorHolder.BinaryEditorHolderFactory.INSTANCE);
    }
}

