/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.BooleanProperty;
import com.intellij.util.config.StringProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalDiffSettings", storages={@Storage(value="diff.xml")})
public class ExternalDiffSettings
implements PersistentStateComponent<State> {
    private State myState = new State();

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    public static ExternalDiffSettings getInstance() {
        return (ExternalDiffSettings)ServiceManager.getService(ExternalDiffSettings.class);
    }

    @NotNull
    private static AbstractProperty.AbstractPropertyContainer getProperties() {
        return DiffManagerImpl.getInstanceEx().getProperties();
    }

    @NotNull
    private static String getProperty(@Nullable StringProperty oldProperty, @Nullable String newValue, @NotNull String defaultValue) {
        String oldValue;
        if (newValue != null) {
            return newValue;
        }
        if (oldProperty != null && !StringUtil.isEmptyOrSpaces((String)(oldValue = (String)oldProperty.get(ExternalDiffSettings.getProperties())))) {
            return oldValue;
        }
        return defaultValue;
    }

    private static boolean getProperty(@Nullable BooleanProperty oldProperty, @Nullable Boolean newValue, boolean defaultValue) {
        if (newValue != null) {
            return newValue;
        }
        if (oldProperty != null) {
            return oldProperty.value(ExternalDiffSettings.getProperties());
        }
        return defaultValue;
    }

    private static void setProperty(@Nullable StringProperty oldProperty, @NotNull String value2) {
        if (oldProperty != null) {
            oldProperty.set(ExternalDiffSettings.getProperties(), (Object)value2);
        }
    }

    private static void setProperty(@Nullable BooleanProperty oldProperty, boolean value2) {
        if (oldProperty != null) {
            oldProperty.set(ExternalDiffSettings.getProperties(), (Object)value2);
        }
    }

    public boolean isDiffEnabled() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.ENABLE_FILES, this.myState.DIFF_ENABLED, false);
    }

    public void setDiffEnabled(boolean value2) {
        this.myState.DIFF_ENABLED = value2;
    }

    public boolean isDiffDefault() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.ENABLE_FILES, this.myState.DIFF_DEFAULT, false);
    }

    public void setDiffDefault(boolean value2) {
        this.myState.DIFF_DEFAULT = value2;
        ExternalDiffSettings.setProperty(DiffManagerImpl.ENABLE_FILES, value2);
    }

    @NotNull
    public String getDiffExePath() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.FILES_TOOL, this.myState.DIFF_EXE_PATH, "");
    }

    public void setDiffExePath(@NotNull String path) {
        this.myState.DIFF_EXE_PATH = path;
        ExternalDiffSettings.setProperty(DiffManagerImpl.FILES_TOOL, path);
    }

    @NotNull
    public String getDiffParameters() {
        return ExternalDiffSettings.getProperty(null, this.myState.DIFF_PARAMETERS, "%1 %2 %3");
    }

    public void setDiffParameters(@NotNull String path) {
        this.myState.DIFF_PARAMETERS = path;
    }

    public boolean isMergeEnabled() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.ENABLE_MERGE, this.myState.MERGE_ENABLED, false);
    }

    public void setMergeEnabled(boolean value2) {
        this.myState.MERGE_ENABLED = value2;
        ExternalDiffSettings.setProperty(DiffManagerImpl.ENABLE_MERGE, value2);
    }

    @NotNull
    public String getMergeExePath() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.MERGE_TOOL, this.myState.MERGE_EXE_PATH, "");
    }

    public void setMergeExePath(@NotNull String path) {
        this.myState.MERGE_EXE_PATH = path;
        ExternalDiffSettings.setProperty(DiffManagerImpl.MERGE_TOOL, path);
    }

    @NotNull
    public String getMergeParameters() {
        return ExternalDiffSettings.getProperty(DiffManagerImpl.MERGE_TOOL_PARAMETERS, this.myState.MERGE_PARAMETERS, "%1 %2 %3 %4");
    }

    public void setMergeParameters(@NotNull String path) {
        this.myState.MERGE_PARAMETERS = path;
        ExternalDiffSettings.setProperty(DiffManagerImpl.MERGE_TOOL_PARAMETERS, path);
    }

    public boolean isMergeTrustExitCode() {
        return this.myState.MERGE_TRUST_EXIT_CODE;
    }

    public void setMergeTrustExitCode(boolean value2) {
        this.myState.MERGE_TRUST_EXIT_CODE = value2;
    }

    public static class State {
        @Nullable
        public Boolean DIFF_ENABLED = null;
        @Nullable
        public Boolean DIFF_DEFAULT = null;
        @Nullable
        public String DIFF_EXE_PATH = null;
        @Nullable
        public String DIFF_PARAMETERS = null;
        @Nullable
        public Boolean MERGE_ENABLED = null;
        @Nullable
        public String MERGE_EXE_PATH = null;
        @Nullable
        public String MERGE_PARAMETERS = null;
        public boolean MERGE_TRUST_EXIT_CODE = false;
    }
}

