/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffTool {
    private static final Logger LOG = Logger.getInstance(ExternalDiffTool.class);

    public static boolean isDefault() {
        return ExternalDiffSettings.getInstance().isDiffEnabled() && ExternalDiffSettings.getInstance().isDiffDefault();
    }

    public static boolean isEnabled() {
        return ExternalDiffSettings.getInstance().isDiffEnabled();
    }

    public static void show(final @Nullable Project project2, final @NotNull DiffRequestChain chain, @NotNull DiffDialogHints hints) {
        try {
            final Ref requestsRef = new Ref();
            final Ref exceptionRef = new Ref();
            ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Loading Requests", true){

                public void run(@NotNull ProgressIndicator indicator) {
                    try {
                        requestsRef.set((Object)ExternalDiffTool.collectRequests(project2, chain, indicator));
                    }
                    catch (Throwable e) {
                        exceptionRef.set((Object)e);
                    }
                }
            });
            if (!exceptionRef.isNull()) {
                throw (Throwable)exceptionRef.get();
            }
            ArrayList<DiffRequest> showInBuiltin = new ArrayList<DiffRequest>();
            for (DiffRequest request : (List)requestsRef.get()) {
                if (ExternalDiffTool.canShow(request)) {
                    ExternalDiffTool.showRequest(project2, request);
                    continue;
                }
                showInBuiltin.add(request);
            }
            if (!showInBuiltin.isEmpty()) {
                DiffManagerEx.getInstance().showDiffBuiltin(project2, (DiffRequestChain)new SimpleDiffRequestChain(showInBuiltin), hints);
            }
        }
        catch (ProcessCanceledException requestsRef) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project2, (String)e.getMessage(), (String)"Can't Show Diff In External Tool");
        }
    }

    @NotNull
    private static List<DiffRequest> collectRequests(@Nullable Project project2, @NotNull DiffRequestChain chain, @NotNull ProgressIndicator indicator) {
        ArrayList<DiffRequest> requests = new ArrayList<DiffRequest>();
        UserDataHolderBase context = new UserDataHolderBase();
        ArrayList<String> errorRequests = new ArrayList<String>();
        List<DiffRequestProducer> producers = Collections.singletonList(chain.getRequests().get(chain.getIndex()));
        for (DiffRequestProducer producer : producers) {
            try {
                requests.add(producer.process((UserDataHolder)context, indicator));
            }
            catch (DiffRequestProducerException e) {
                LOG.warn((Throwable)e);
                errorRequests.add(producer.getName());
            }
        }
        if (!errorRequests.isEmpty()) {
            new Notification("diff", "Can't load some changes", StringUtil.join(errorRequests, (String)"<br>"), NotificationType.ERROR).notify(project2);
        }
        return requests;
    }

    public static void showRequest(@Nullable Project project2, @NotNull DiffRequest request) throws ExecutionException, IOException {
        request.onAssigned(true);
        ExternalDiffSettings settings = ExternalDiffSettings.getInstance();
        List contents = ((ContentDiffRequest)request).getContents();
        List titles = ((ContentDiffRequest)request).getContentTitles();
        ExternalDiffToolUtil.execute(settings, contents, titles, request.getTitle());
        request.onAssigned(false);
    }

    public static boolean canShow(@NotNull DiffRequest request) {
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2 && contents.size() != 3) {
            return false;
        }
        for (DiffContent content : contents) {
            if (ExternalDiffToolUtil.canCreateFile(content)) continue;
            return false;
        }
        return true;
    }
}

