/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content) {
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            return !(file2 instanceof VirtualFileWithoutContent);
        }
        if (content instanceof DirectoryContent) {
            return ((DirectoryContent)content).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    private static InputFile createFile(@NotNull DiffContent content, @NotNull FileNameInfo fileName) throws IOException {
        if (content instanceof EmptyContent) {
            return new TempInputFile(ExternalDiffToolUtil.createFile(new byte[0], fileName));
        }
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                return new LocalInputFile(file2);
            }
            return new TempInputFile(ExternalDiffToolUtil.createTempFile(file2, fileName));
        }
        if (content instanceof DocumentContent) {
            return new TempInputFile(ExternalDiffToolUtil.createTempFile((DocumentContent)content, fileName));
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file3 = ((DirectoryContent)content).getFile();
            if (file3.isInLocalFileSystem()) {
                return new LocalInputFile(file3);
            }
            throw new IllegalArgumentException(content.toString());
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createTempFile(@NotNull DocumentContent content, @NotNull FileNameInfo fileName) throws IOException {
        byte[] bom;
        Boolean hasBom;
        Charset charset;
        FileDocumentManager.getInstance().saveDocument(content.getDocument());
        LineSeparator separator = content.getLineSeparator();
        if (separator == null) {
            separator = LineSeparator.getSystemLineSeparator();
        }
        if ((charset = content.getCharset()) == null) {
            charset = Charset.defaultCharset();
        }
        if ((hasBom = content.hasBom()) == null) {
            hasBom = CharsetToolkit.getMandatoryBom((Charset)charset) != null;
        }
        String contentData = (String)ReadAction.compute(() -> content.getDocument().getText());
        if (separator != LineSeparator.LF) {
            contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
        }
        byte[] bytes = contentData.getBytes(charset);
        byte[] byArray = bom = hasBom != false ? CharsetToolkit.getPossibleBom((Charset)charset) : null;
        if (bom != null) {
            bytes = ArrayUtil.mergeArrays((byte[])bom, (byte[])bytes);
        }
        return ExternalDiffToolUtil.createFile(bytes, fileName);
    }

    @NotNull
    private static File createTempFile(@NotNull VirtualFile file2, @NotNull FileNameInfo fileName) throws IOException {
        byte[] bytes = file2.contentsToByteArray();
        return ExternalDiffToolUtil.createFile(bytes, fileName);
    }

    @NotNull
    private static OutputFile createOutputFile(@NotNull DiffContent content, @NotNull FileNameInfo fileName) throws IOException {
        if (content instanceof FileContent) {
            VirtualFile file2 = ((FileContent)content).getFile();
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document != null) {
                FileDocumentManager.getInstance().saveDocument(document);
            }
            if (file2.isInLocalFileSystem()) {
                return new LocalOutputFile(file2);
            }
            File tempFile = ExternalDiffToolUtil.createTempFile(file2, fileName);
            return new NonLocalOutputFile(file2, tempFile);
        }
        if (content instanceof DocumentContent) {
            File tempFile = ExternalDiffToolUtil.createTempFile((DocumentContent)content, fileName);
            return new DocumentOutputFile(((DocumentContent)content).getDocument(), ((DocumentContent)content).getCharset(), tempFile);
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    private static File createFile(@NotNull byte[] bytes, @NotNull FileNameInfo fileName) throws IOException {
        File tempFile = FileUtil.createTempFile((String)(fileName.prefix + "_"), (String)("_" + fileName.name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        return tempFile;
    }

    public static void execute(@NotNull ExternalDiffSettings settings, @NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<InputFile> files = new ArrayList<InputFile>();
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            DiffContent content = contents.get(i2);
            FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i2);
            files.add(ExternalDiffToolUtil.createFile(content, fileName));
        }
        HashMap patterns = ContainerUtil.newHashMap();
        if (files.size() == 2) {
            patterns.put("%1", ((InputFile)files.get(0)).getPath());
            patterns.put("%2", ((InputFile)files.get(1)).getPath());
            patterns.put("%3", "");
        } else {
            patterns.put("%1", ((InputFile)files.get(0)).getPath());
            patterns.put("%2", ((InputFile)files.get(2)).getPath());
            patterns.put("%3", ((InputFile)files.get(1)).getPath());
        }
        ExternalDiffToolUtil.execute(settings.getDiffExePath(), settings.getDiffParameters(), patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeMerge(@Nullable Project project2, @NotNull ExternalDiffSettings settings, @NotNull ThreesideMergeRequest request) throws IOException, ExecutionException {
        boolean success = false;
        InputFile outputFile = null;
        ArrayList<InputFile> inputFiles = new ArrayList<InputFile>();
        try {
            DiffContent outputContent = request.getOutputContent();
            List contents = request.getContents();
            List titles = request.getContentTitles();
            String windowTitle = request.getTitle();
            assert (contents.size() == 3);
            assert (titles.size() == contents.size());
            for (int i2 = 0; i2 < contents.size(); ++i2) {
                DiffContent content = (DiffContent)contents.get(i2);
                FileNameInfo fileName = FileNameInfo.create(contents, titles, windowTitle, i2);
                inputFiles.add(ExternalDiffToolUtil.createFile(content, fileName));
            }
            outputFile = ExternalDiffToolUtil.createOutputFile(outputContent, FileNameInfo.createMergeResult(outputContent, windowTitle));
            com.intellij.util.containers.hash.HashMap patterns = new com.intellij.util.containers.hash.HashMap();
            patterns.put("%1", ((InputFile)inputFiles.get(0)).getPath());
            patterns.put("%2", ((InputFile)inputFiles.get(2)).getPath());
            patterns.put("%3", ((InputFile)inputFiles.get(1)).getPath());
            patterns.put("%4", outputFile.getPath());
            final Process process2 = ExternalDiffToolUtil.execute(settings.getMergeExePath(), settings.getMergeParameters(), (Map<String, String>)patterns);
            if (settings.isMergeTrustExitCode()) {
                final Ref resultRef = new Ref();
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Waiting for External Tool", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        final Semaphore semaphore = new Semaphore(0);
                        Thread waiter = new Thread("external process waiter"){

                            @Override
                            public void run() {
                                try {
                                    resultRef.set((Object)(process2.waitFor() == 0 ? 1 : 0));
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    semaphore.release();
                                }
                            }
                        };
                        waiter.start();
                        try {
                            do {
                                indicator.checkCanceled();
                            } while (!semaphore.tryAcquire(200L, TimeUnit.MILLISECONDS));
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        finally {
                            waiter.interrupt();
                        }
                    }
                });
                success = resultRef.get() == Boolean.TRUE;
            } else {
                ProgressManager.getInstance().run((Task)new Task.Modal(project2, "Launching External Tool", false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        indicator.setIndeterminate(true);
                        TimeoutUtil.sleep((long)1000L);
                    }
                });
                boolean bl = success = Messages.showYesNoDialog((Project)project2, (String)"Press \"Mark as Resolved\" when you finish resolving conflicts in the external tool", (String)"Merge In External Tool", (String)"Mark as Resolved", (String)"Revert", null) == 0;
            }
            if (success) {
                outputFile.apply();
            }
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
        }
        catch (Throwable throwable) {
            request.applyResult(success ? MergeResult.RESOLVED : MergeResult.CANCEL);
            if (outputFile != null) {
                outputFile.cleanup();
            }
            for (InputFile file2 : inputFiles) {
                file2.cleanup();
            }
            throw throwable;
        }
        if (outputFile != null) {
            outputFile.cleanup();
        }
        for (InputFile file3 : inputFiles) {
            file3.cleanup();
        }
    }

    @NotNull
    private static Process execute(@NotNull String exePath, @NotNull String parametersTemplate, @NotNull Map<String, String> patterns) throws ExecutionException {
        List parameters2 = ParametersListUtil.parse((String)parametersTemplate, (boolean)true);
        ArrayList<String> from = new ArrayList<String>();
        ArrayList<String> to = new ArrayList<String>();
        for (Map.Entry<String, String> entry : patterns.entrySet()) {
            from.add(entry.getKey());
            to.add(entry.getValue());
        }
        ArrayList<String> args = new ArrayList<String>();
        for (String parameter : parameters2) {
            String arg = StringUtil.replace((String)parameter, from, to);
            if (StringUtil.isEmptyOrSpaces((String)arg)) continue;
            args.add(arg);
        }
        GeneralCommandLine generalCommandLine = new GeneralCommandLine();
        generalCommandLine.setExePath(exePath);
        generalCommandLine.addParameters(args);
        return generalCommandLine.createProcess();
    }

    private static class FileNameInfo {
        @NotNull
        public final String prefix;
        @NotNull
        public final String name;

        public FileNameInfo(@NotNull String prefix, @NotNull String name) {
            this.prefix = prefix;
            this.name = name;
        }

        @NotNull
        public static FileNameInfo create(@NotNull List<? extends DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle, int index) {
            if (contents.size() == 2) {
                Side side = Side.fromIndex((int)index);
                DiffContent content = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"before", (Object)"after");
                String name = FileNameInfo.getFileName(content, title, windowTitle);
                return new FileNameInfo(prefix, name);
            }
            if (contents.size() == 3) {
                ThreeSide side = ThreeSide.fromIndex((int)index);
                DiffContent content = (DiffContent)side.select(contents);
                String title = (String)side.select(titles);
                String prefix = (String)side.select((Object)"left", (Object)"base", (Object)"right");
                String name = FileNameInfo.getFileName(content, title, windowTitle);
                return new FileNameInfo(prefix, name);
            }
            throw new IllegalArgumentException(String.valueOf(contents.size()));
        }

        @NotNull
        public static FileNameInfo createMergeResult(@NotNull DiffContent content, @Nullable String windowTitle) {
            String name = FileNameInfo.getFileName(content, null, windowTitle);
            return new FileNameInfo("merge_result", name);
        }

        @NotNull
        private static String getFileName(@NotNull DiffContent content, @Nullable String title, @Nullable String windowTitle) {
            String ext;
            if (content instanceof EmptyContent) {
                return "no_content.tmp";
            }
            String fileName = (String)content.getUserData(DiffUserDataKeysEx.FILE_NAME);
            if (fileName == null && content instanceof DocumentContent) {
                VirtualFile highlightFile = ((DocumentContent)content).getHighlightFile();
                String string = fileName = highlightFile != null ? highlightFile.getName() : null;
            }
            if (fileName == null && content instanceof FileContent) {
                fileName = ((FileContent)content).getFile().getName();
            }
            if (!StringUtil.isEmptyOrSpaces((String)fileName)) {
                return fileName;
            }
            FileType fileType = content.getContentType();
            String string = ext = fileType != null ? fileType.getDefaultExtension() : null;
            if (StringUtil.isEmptyOrSpaces((String)ext)) {
                ext = "tmp";
            }
            String name = "";
            if (title != null && windowTitle != null) {
                name = title + "_" + windowTitle;
            } else if (title != null || windowTitle != null) {
                String string2 = name = title != null ? title : windowTitle;
            }
            if (name.length() > 50) {
                name = name.substring(0, 50);
            }
            return PathUtil.suggestFileName((String)(name + "." + ext), (boolean)true, (boolean)false);
        }
    }

    private static class TempInputFile
    implements InputFile {
        @NotNull
        protected final File myLocalFile;

        public TempInputFile(@NotNull File localFile) {
            this.myLocalFile = localFile;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myLocalFile.getPath();
        }

        @Override
        public void cleanup() {
            FileUtil.delete((File)this.myLocalFile);
        }
    }

    private static class LocalInputFile
    implements InputFile {
        @NotNull
        protected final VirtualFile myFile;

        public LocalInputFile(@NotNull VirtualFile file2) {
            this.myFile = file2;
        }

        @Override
        @NotNull
        public String getPath() {
            return this.myFile.getPath();
        }

        @Override
        public void cleanup() {
        }
    }

    private static class DocumentOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final Document myDocument;
        @NotNull
        private final Charset myCharset;

        public DocumentOutputFile(@NotNull Document document, @Nullable Charset charset, @NotNull File localFile) {
            super(localFile);
            this.myDocument = document;
            this.myCharset = charset != null ? charset : Charset.defaultCharset();
        }

        @Override
        public void apply() throws IOException {
            String content = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)this.myLocalFile, (Charset)this.myCharset));
            ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText((CharSequence)content));
        }
    }

    private static class NonLocalOutputFile
    extends TempInputFile
    implements OutputFile {
        @NotNull
        private final VirtualFile myFile;

        public NonLocalOutputFile(@NotNull VirtualFile file2, @NotNull File localFile) {
            super(localFile);
            this.myFile = file2;
        }

        @Override
        public void apply() throws IOException {
            this.myFile.setBinaryContent(FileUtil.loadFileBytes((File)this.myLocalFile));
        }
    }

    private static class LocalOutputFile
    extends LocalInputFile
    implements OutputFile {
        public LocalOutputFile(@NotNull VirtualFile file2) {
            super(file2);
        }

        @Override
        public void apply() {
            this.myFile.refresh(false, false);
        }
    }

    private static interface OutputFile
    extends InputFile {
        public void apply() throws IOException;
    }

    private static interface InputFile {
        @NotNull
        public String getPath();

        public void cleanup();
    }
}

