/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UnifiedEditorRangeHighlighter {
    @NotNull
    private final List<Element> myPieces = new ArrayList<Element>();

    public UnifiedEditorRangeHighlighter(@Nullable Project project2, @NotNull Document document) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, false);
        if (model == null) {
            return;
        }
        model.processRangeHighlightersOverlappingWith(0, document.getTextLength(), (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            int newStart = marker.getStartOffset();
            int newEnd = marker.getEndOffset();
            this.myPieces.add(new Element((RangeHighlighterEx)marker, newStart, newEnd));
            return true;
        }));
    }

    public UnifiedEditorRangeHighlighter(@Nullable Project project2, @NotNull Document document1, @NotNull Document document2, @NotNull List<HighlightRange> ranges) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        MarkupModelEx model1 = (MarkupModelEx)DocumentMarkupModel.forDocument(document1, project2, false);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(document2, project2, false);
        this.init(model1, model2, ranges);
    }

    private void init(@Nullable MarkupModelEx model1, @Nullable MarkupModelEx model2, @NotNull List<HighlightRange> ranges) {
        for (HighlightRange range : ranges) {
            if (range.getSide().isLeft()) {
                if (model1 == null) continue;
                this.processRange(model1, range);
                continue;
            }
            if (model2 == null) continue;
            this.processRange(model2, range);
        }
    }

    private void processRange(@NotNull MarkupModelEx model, @NotNull HighlightRange range) {
        TextRange base = range.getBase();
        TextRange changed = range.getChanged();
        int changedLength = changed.getEndOffset() - changed.getStartOffset();
        model.processRangeHighlightersOverlappingWith(changed.getStartOffset(), changed.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)marker -> {
            int relativeStart = Math.max(marker.getStartOffset() - changed.getStartOffset(), 0);
            int relativeEnd = Math.min(marker.getEndOffset() - changed.getStartOffset(), changedLength);
            int newStart = base.getStartOffset() + relativeStart;
            int newEnd = base.getStartOffset() + relativeEnd;
            if (newEnd - newStart <= 0) {
                return true;
            }
            this.myPieces.add(new Element((RangeHighlighterEx)marker, newStart, newEnd));
            return true;
        }));
    }

    public static void erase(@Nullable Project project2, @NotNull Document document) {
        MarkupModel model = DocumentMarkupModel.forDocument(document, project2, true);
        model.removeAllHighlighters();
    }

    public void apply(@Nullable Project project2, @NotNull Document document) {
        MarkupModel model = DocumentMarkupModel.forDocument(document, project2, true);
        for (Element piece : this.myPieces) {
            RangeHighlighterEx delegate = piece.getDelegate();
            if (!delegate.isValid()) continue;
            RangeHighlighter highlighter = model.addRangeHighlighter(piece.getStart(), piece.getEnd(), delegate.getLayer(), delegate.getTextAttributes(), delegate.getTargetArea());
            highlighter.setEditorFilter(delegate.getEditorFilter());
            highlighter.setCustomRenderer(delegate.getCustomRenderer());
            highlighter.setErrorStripeMarkColor(delegate.getErrorStripeMarkColor());
            highlighter.setErrorStripeTooltip(delegate.getErrorStripeTooltip());
            highlighter.setGutterIconRenderer(delegate.getGutterIconRenderer());
            highlighter.setLineMarkerRenderer(delegate.getLineMarkerRenderer());
            highlighter.setLineSeparatorColor(delegate.getLineSeparatorColor());
            highlighter.setThinErrorStripeMark(delegate.isThinErrorStripeMark());
            highlighter.setLineSeparatorPlacement(delegate.getLineSeparatorPlacement());
            highlighter.setLineSeparatorRenderer(delegate.getLineSeparatorRenderer());
        }
    }

    private static class Element {
        @NotNull
        private final RangeHighlighterEx myDelegate;
        private final int myStart;
        private final int myEnd;

        public Element(@NotNull RangeHighlighterEx delegate, int start, int end) {
            this.myDelegate = delegate;
            this.myStart = start;
            this.myEnd = end;
        }

        @NotNull
        public RangeHighlighterEx getDelegate() {
            return this.myDelegate;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }
    }
}

