/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.simple.SimpleDiffViewer;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffGutterRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffChange {
    @NotNull
    private final SimpleDiffViewer myViewer;
    @NotNull
    private final LineFragment myFragment;
    @Nullable
    private final List<DiffFragment> myInnerFragments;
    @NotNull
    private final List<RangeHighlighter> myHighlighters = new ArrayList<RangeHighlighter>();
    @NotNull
    private final List<MyGutterOperation> myOperations = new ArrayList<MyGutterOperation>();
    private boolean myIsValid = true;
    private int[] myLineStartShifts = new int[2];
    private int[] myLineEndShifts = new int[2];

    public SimpleDiffChange(@NotNull SimpleDiffViewer viewer, @NotNull LineFragment fragment, @Nullable LineFragment previousFragment) {
        this.myViewer = viewer;
        this.myFragment = fragment;
        this.myInnerFragments = fragment.getInnerFragments();
        this.installHighlighter(previousFragment);
    }

    public void installHighlighter(@Nullable LineFragment previousFragment) {
        assert (this.myHighlighters.isEmpty());
        if (this.myInnerFragments != null) {
            this.doInstallHighlighterWithInner();
        } else {
            this.doInstallHighlighterSimple();
        }
        this.doInstallNonSquashedChangesSeparator(previousFragment);
        this.doInstallActionHighlighters();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
        for (MyGutterOperation operation : this.myOperations) {
            operation.dispose();
        }
        this.myOperations.clear();
    }

    private void doInstallHighlighterSimple() {
        this.createHighlighter(Side.LEFT, false);
        this.createHighlighter(Side.RIGHT, false);
    }

    private void doInstallHighlighterWithInner() {
        assert (this.myInnerFragments != null);
        this.createHighlighter(Side.LEFT, true);
        this.createHighlighter(Side.RIGHT, true);
        for (DiffFragment fragment : this.myInnerFragments) {
            this.createInlineHighlighter(fragment, Side.LEFT);
            this.createInlineHighlighter(fragment, Side.RIGHT);
        }
    }

    private void doInstallNonSquashedChangesSeparator(@Nullable LineFragment previousFragment) {
        this.createNonSquashedChangesSeparator(previousFragment, Side.LEFT);
        this.createNonSquashedChangesSeparator(previousFragment, Side.RIGHT);
    }

    private void doInstallActionHighlighters() {
        this.myOperations.add(this.createOperation(Side.LEFT));
        this.myOperations.add(this.createOperation(Side.RIGHT));
    }

    private void createHighlighter(@NotNull Side side, boolean ignored) {
        EditorEx editor = this.myViewer.getEditor(side);
        TextDiffType type2 = DiffUtil.getLineDiffType(this.myFragment);
        int startLine = side.getStartLine(this.myFragment);
        int endLine = side.getEndLine(this.myFragment);
        this.myHighlighters.addAll(DiffDrawUtil.createHighlighter(editor, startLine, endLine, type2, ignored));
    }

    private void createInlineHighlighter(@NotNull DiffFragment fragment, @NotNull Side side) {
        int start = side.getStartOffset(fragment);
        int end = side.getEndOffset(fragment);
        TextDiffType type2 = DiffUtil.getDiffType(fragment);
        int startOffset = side.getStartOffset((DiffFragment)this.myFragment);
        EditorEx editor = this.myViewer.getEditor(side);
        this.myHighlighters.addAll(DiffDrawUtil.createInlineHighlighter(editor, start += startOffset, end += startOffset, type2));
    }

    private void createNonSquashedChangesSeparator(@Nullable LineFragment previousFragment, @NotNull Side side) {
        if (previousFragment == null) {
            return;
        }
        int startLine = side.getStartLine(this.myFragment);
        int endLine = side.getEndLine(this.myFragment);
        int prevStartLine = side.getStartLine(previousFragment);
        int prevEndLine = side.getEndLine(previousFragment);
        if (startLine == endLine) {
            return;
        }
        if (prevStartLine == prevEndLine) {
            return;
        }
        if (prevEndLine != startLine) {
            return;
        }
        this.myHighlighters.addAll(DiffDrawUtil.createLineMarker(this.myViewer.getEditor(side), startLine, TextDiffType.MODIFIED));
    }

    public void updateGutterActions(boolean force) {
        for (MyGutterOperation operation : this.myOperations) {
            operation.update(force);
        }
    }

    public int getStartLine(@NotNull Side side) {
        return side.getStartLine(this.myFragment) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull Side side) {
        return side.getEndLine(this.myFragment) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        return DiffUtil.getLineDiffType(this.myFragment);
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull Side side) {
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        int n = sideIndex;
        this.myLineStartShifts[n] = this.myLineStartShifts[n] + (newRange.startLine - line1);
        int n2 = sideIndex;
        this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + (newRange.endLine - line2);
        if (newRange.damaged) {
            for (MyGutterOperation operation : this.myOperations) {
                operation.dispose();
            }
            this.myOperations.clear();
            this.myIsValid = false;
        }
        return newRange.damaged;
    }

    public boolean isSelectedByLine(int line, @NotNull Side side) {
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        return DiffUtil.isSelectedByLine(line, line1, line2);
    }

    @NotNull
    private MyGutterOperation createOperation(@NotNull Side side) {
        int offset = side.getStartOffset((DiffFragment)this.myFragment);
        EditorEx editor = this.myViewer.getEditor(side);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.LINES_IN_RANGE);
        return new MyGutterOperation(side, highlighter);
    }

    @Nullable
    private GutterIconRenderer createApplyRenderer(@NotNull Side side) {
        return this.createIconRenderer(side, "Accept", DiffUtil.getArrowIcon(side), () -> this.myViewer.replaceChange(this, side));
    }

    @Nullable
    private GutterIconRenderer createAppendRenderer(@NotNull Side side) {
        return this.createIconRenderer(side, "Append", DiffUtil.getArrowDownIcon(side), () -> {
            UsageTrigger.trigger("diff.SimpleDiffChange.Append");
            this.myViewer.appendChange(this, side);
        });
    }

    @Nullable
    private GutterIconRenderer createIconRenderer(final @NotNull Side sourceSide, @NotNull String tooltipText, @NotNull Icon icon, final @NotNull Runnable perform) {
        if (!DiffUtil.isEditable(this.myViewer.getEditor(sourceSide.other()))) {
            return null;
        }
        return new DiffGutterRenderer(icon, tooltipText){

            @Override
            protected void performAction(AnActionEvent e) {
                if (!SimpleDiffChange.this.myIsValid) {
                    return;
                }
                Project project2 = e.getProject();
                DocumentEx document = SimpleDiffChange.this.myViewer.getEditor(sourceSide.other()).getDocument();
                DiffUtil.executeWriteCommand(document, project2, "Replace change", perform);
            }
        };
    }

    private class MyGutterOperation {
        @NotNull
        private final Side mySide;
        @NotNull
        private final RangeHighlighter myHighlighter;
        private boolean myCtrlPressed;

        private MyGutterOperation(@NotNull Side side, RangeHighlighter highlighter) {
            this.mySide = side;
            this.myHighlighter = highlighter;
            this.update(true);
        }

        public void dispose() {
            this.myHighlighter.dispose();
        }

        public void update(boolean force) {
            if (!force && !this.areModifiersChanged()) {
                return;
            }
            if (this.myHighlighter.isValid()) {
                this.myHighlighter.setGutterIconRenderer(this.createRenderer());
            }
        }

        private boolean areModifiersChanged() {
            return this.myCtrlPressed != SimpleDiffChange.this.myViewer.getModifierProvider().isCtrlPressed();
        }

        @Nullable
        public GutterIconRenderer createRenderer() {
            boolean isAppendable;
            this.myCtrlPressed = SimpleDiffChange.this.myViewer.getModifierProvider().isCtrlPressed();
            boolean isOtherEditable = DiffUtil.isEditable(SimpleDiffChange.this.myViewer.getEditor(this.mySide.other()));
            boolean bl = isAppendable = SimpleDiffChange.this.myFragment.getStartLine1() != SimpleDiffChange.this.myFragment.getEndLine1() && SimpleDiffChange.this.myFragment.getStartLine2() != SimpleDiffChange.this.myFragment.getEndLine2();
            if (isOtherEditable) {
                if (this.myCtrlPressed && isAppendable) {
                    return SimpleDiffChange.this.createAppendRenderer(this.mySide);
                }
                return SimpleDiffChange.this.createApplyRenderer(this.mySide);
            }
            return null;
        }
    }
}

