/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.tools.simple.SimpleThreesideDiffViewer;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffChange
extends ThreesideDiffChangeBase {
    @NotNull
    private final List<? extends EditorEx> myEditors;
    @Nullable
    private final MergeInnerDifferences myInnerFragments;
    private int[] myLineStarts = new int[3];
    private int[] myLineEnds = new int[3];

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @Nullable MergeInnerDifferences innerFragments, @NotNull SimpleThreesideDiffViewer viewer) {
        super(conflictType);
        this.myEditors = viewer.getEditors();
        this.myInnerFragments = innerFragments;
        for (ThreeSide side : ThreeSide.values()) {
            this.myLineStarts[side.getIndex()] = fragment.getStartLine(side);
            this.myLineEnds[side.getIndex()] = fragment.getEndLine(side);
        }
        this.reinstallHighlighters();
    }

    public void destroy() {
        this.destroyHighlighters();
        this.destroyInnerHighlighters();
    }

    public void reinstallHighlighters() {
        this.destroyHighlighters();
        this.installHighlighters();
        this.destroyInnerHighlighters();
        this.installInnerHighlighters();
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        return side.select(this.myLineStarts);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        return side.select(this.myLineEnds);
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        return false;
    }

    @Override
    @NotNull
    protected Editor getEditor(@NotNull ThreeSide side) {
        return (Editor)side.select(this.myEditors);
    }

    @Override
    @Nullable
    protected MergeInnerDifferences getInnerFragments() {
        return this.myInnerFragments;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        int sideIndex = side.getIndex();
        DiffUtil.UpdatedLineRange newRange = DiffUtil.updateRangeOnModification(line1, line2, oldLine1, oldLine2, shift);
        this.myLineStarts[sideIndex] = newRange.startLine;
        this.myLineEnds[sideIndex] = newRange.endLine;
        return newRange.damaged;
    }
}

