/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import java.awt.Color;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffNotifications {
    @NotNull
    public static JPanel createInsertedContent() {
        return DiffNotifications.createNotification("Content added", TextDiffType.INSERTED.getColor(null));
    }

    @NotNull
    public static JPanel createRemovedContent() {
        return DiffNotifications.createNotification("Content removed", TextDiffType.DELETED.getColor(null));
    }

    @NotNull
    public static JPanel createEqualContents() {
        return DiffNotifications.createEqualContents(true, true);
    }

    @NotNull
    public static JPanel createEqualContents(boolean equalCharsets, boolean equalSeparators) {
        if (!equalCharsets && !equalSeparators) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.charset.and.line.separators.message.text", (Object[])new Object[0]));
        }
        if (!equalSeparators) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.line.separators.message.text", (Object[])new Object[0]));
        }
        if (!equalCharsets) {
            return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.have.differences.only.in.charset.message.text", (Object[])new Object[0]));
        }
        return DiffNotifications.createNotification(DiffBundle.message((String)"diff.contents.are.identical.message.text", (Object[])new Object[0]));
    }

    @NotNull
    public static JPanel createError() {
        return DiffNotifications.createNotification("Can not calculate diff");
    }

    @NotNull
    public static JPanel createOperationCanceled() {
        return DiffNotifications.createNotification("Can not calculate diff. Operation canceled.");
    }

    @NotNull
    public static JPanel createDiffTooBig() {
        return DiffNotifications.createNotification("Can not calculate diff. File is too big and there are too many changes.");
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text) {
        return DiffNotifications.createNotification(text, null);
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text, @Nullable Color background) {
        return DiffNotifications.createNotification(text, background, true);
    }

    @NotNull
    public static JPanel createNotification(@NotNull String text, @Nullable Color background, boolean showHideAction) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel(background);
        panel2.text(text);
        if (showHideAction) {
            HyperlinkLabel link = panel2.createActionLabel("Hide", () -> panel2.setVisible(false));
            link.setToolTipText("Hide this notification");
        }
        return panel2;
    }
}

