/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.SoftValueHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftHardCacheMap<K, V> {
    @NotNull
    private final SLRUMap<K, V> mySLRUMap;
    @NotNull
    private final SoftValueHashMap<K, V> mySoftLinkMap;

    public SoftHardCacheMap(int protectedQueueSize, int probationalQueueSize) {
        this.mySLRUMap = new SLRUMap(protectedQueueSize, probationalQueueSize);
        this.mySoftLinkMap = new SoftValueHashMap();
    }

    @Nullable
    public V get(@NotNull K key2) {
        Object val = this.mySLRUMap.get(key2);
        if (val != null) {
            return (V)val;
        }
        val = this.mySoftLinkMap.get(key2);
        if (val != null) {
            this.mySLRUMap.put(key2, val);
        }
        return (V)val;
    }

    public void put(@NotNull K key2, @NotNull V value2) {
        this.mySLRUMap.put(key2, value2);
        this.mySoftLinkMap.put(key2, value2);
    }

    public boolean remove(@NotNull K key2) {
        boolean remove1 = this.mySLRUMap.remove(key2);
        boolean remove2 = this.mySoftLinkMap.remove(key2) != null;
        return remove1 || remove2;
    }

    public void clear() {
        this.mySLRUMap.clear();
        this.mySoftLinkMap.clear();
    }
}

