/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SyncScrollSupport {
    private static void doScrollVertically(@NotNull Editor editor, int offset, boolean animated) {
        ScrollingModel model = editor.getScrollingModel();
        if (!animated) {
            model.disableAnimation();
        }
        model.scrollVertically(offset);
        if (!animated) {
            model.enableAnimation();
        }
    }

    private static void doScrollHorizontally(@NotNull Editor editor, int offset, boolean animated) {
        ScrollingModel model = editor.getScrollingModel();
        if (!animated) {
            model.disableAnimation();
        }
        model.scrollHorizontally(offset);
        if (!animated) {
            model.enableAnimation();
        }
    }

    private static int getHeaderOffset(@NotNull Editor editor) {
        JComponent header = editor.getHeaderComponent();
        return header == null ? 0 : header.getHeight();
    }

    @NotNull
    public static int[] getTargetOffsets(@NotNull Editor editor1, @NotNull Editor editor2, int startLine1, int endLine1, int startLine2, int endLine2, int preferredTopShift) {
        return SyncScrollSupport.getTargetOffsets(new Editor[]{editor1, editor2}, new int[]{startLine1, startLine2}, new int[]{endLine1, endLine2}, preferredTopShift);
    }

    @NotNull
    private static int[] getTargetOffsets(@NotNull Editor[] editors, int[] startLines, int[] endLines, int preferredTopShift) {
        int i2;
        int count = editors.length;
        assert (startLines.length == count);
        assert (endLines.length == count);
        int[] topOffsets = new int[count];
        int[] bottomOffsets = new int[count];
        int[] rangeHeights = new int[count];
        int[] gapLines = new int[count];
        int[] editorHeights = new int[count];
        int[] maximumOffsets = new int[count];
        int[] topShifts = new int[count];
        for (int i3 = 0; i3 < count; ++i3) {
            topOffsets[i3] = editors[i3].logicalPositionToXY((LogicalPosition)new LogicalPosition((int)startLines[i3], (int)0)).y;
            bottomOffsets[i3] = editors[i3].logicalPositionToXY((LogicalPosition)new LogicalPosition((int)(endLines[i3] + 1), (int)0)).y;
            rangeHeights[i3] = bottomOffsets[i3] - topOffsets[i3];
            gapLines[i3] = 2 * editors[i3].getLineHeight();
            editorHeights[i3] = editors[i3].getScrollingModel().getVisibleArea().height;
            maximumOffsets[i3] = ((EditorEx)editors[i3]).getScrollPane().getVerticalScrollBar().getMaximum() - editorHeights[i3];
            boolean canShow = 2 * gapLines[i3] + rangeHeights[i3] <= editorHeights[i3];
            int shift = preferredTopShift != -1 ? preferredTopShift : editorHeights[i3] / 3;
            topShifts[i3] = canShow ? Math.min(editorHeights[i3] - gapLines[i3] - rangeHeights[i3], shift) : gapLines[i3];
        }
        int topShift = ArrayUtil.min((int[])topShifts);
        topShift = Math.min(topShift, ArrayUtil.min((int[])topOffsets));
        int[] offsets = new int[count];
        boolean haveEnoughSpace = true;
        for (i2 = 0; i2 < count; ++i2) {
            offsets[i2] = topOffsets[i2] - topShift;
            haveEnoughSpace &= maximumOffsets[i2] > offsets[i2];
        }
        if (haveEnoughSpace) {
            return offsets;
        }
        topShift = 0;
        for (i2 = 0; i2 < count; ++i2) {
            topShift = Math.max(topOffsets[i2] - maximumOffsets[i2], topShift);
        }
        for (i2 = 0; i2 < count; ++i2) {
            offsets[i2] = topOffsets[i2] - topShift + Math.max(topShift + rangeHeights[i2] + gapLines[i2] - editorHeights[i2], 0);
            offsets[i2] = Math.min(offsets[i2], topOffsets[i2] - gapLines[i2]);
        }
        return offsets;
    }

    private static class Anchor {
        public final int masterStartOffset;
        public final int masterEndOffset;
        public final int slaveStartOffset;
        public final int slaveEndOffset;

        public Anchor(int masterStartOffset, int masterEndOffset, int slaveStartOffset, int slaveEndOffset) {
            this.masterStartOffset = masterStartOffset;
            this.masterEndOffset = masterEndOffset;
            this.slaveStartOffset = slaveStartOffset;
            this.slaveEndOffset = slaveEndOffset;
        }
    }

    private static abstract class ScrollHelper
    implements VisibleAreaListener {
        @NotNull
        private final List<? extends Editor> myEditors;
        private final int myMasterIndex;
        private final int mySlaveIndex;
        @Nullable
        private Anchor myAnchor;

        public ScrollHelper(@NotNull List<? extends Editor> editors, int masterIndex, int slaveIndex) {
            this.myEditors = editors;
            this.myMasterIndex = masterIndex;
            this.mySlaveIndex = slaveIndex;
        }

        @NotNull
        public static ScrollHelper create(@NotNull List<? extends Editor> editors, int masterIndex, int slaveIndex, final @NotNull SyncScrollable scrollable, final @NotNull Side side) {
            return new ScrollHelper(editors, masterIndex, slaveIndex){

                @Override
                protected int convertLine(int value2) {
                    return scrollable.transfer(side, value2);
                }
            };
        }

        protected abstract int convertLine(int var1);

        public void setAnchor(int masterStartOffset, int masterEndOffset, int slaveStartOffset, int slaveEndOffset) {
            this.myAnchor = new Anchor(masterStartOffset, masterEndOffset, slaveStartOffset, slaveEndOffset);
        }

        public void removeAnchor() {
            this.myAnchor = null;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (((FoldingModelImpl)this.getSlave().getFoldingModel()).isInBatchFoldingOperation()) {
                return;
            }
            if (this.getMaster().isDisposed() || this.getSlave().isDisposed()) {
                return;
            }
            Rectangle newRectangle = e.getNewRectangle();
            Rectangle oldRectangle = e.getOldRectangle();
            if (oldRectangle == null) {
                return;
            }
            if (newRectangle.x != oldRectangle.x) {
                this.syncHorizontalScroll(false);
            }
            if (newRectangle.y != oldRectangle.y) {
                this.syncVerticalScroll(false);
            }
        }

        public int getMasterIndex() {
            return this.myMasterIndex;
        }

        public int getSlaveIndex() {
            return this.mySlaveIndex;
        }

        @NotNull
        public Editor getMaster() {
            return this.myEditors.get(this.myMasterIndex);
        }

        @NotNull
        public Editor getSlave() {
            return this.myEditors.get(this.mySlaveIndex);
        }

        private void syncVerticalScroll(boolean animated) {
            int offset;
            if (this.getMaster().getDocument().getTextLength() == 0) {
                return;
            }
            Rectangle viewRect = this.getMaster().getScrollingModel().getVisibleArea();
            int middleY = viewRect.height / 3;
            if (this.myAnchor == null) {
                LogicalPosition masterPos = this.getMaster().xyToLogicalPosition(new Point(viewRect.x, viewRect.y + middleY));
                int masterCenterLine = masterPos.line;
                int convertedCenterLine = this.convertLine(masterCenterLine);
                Point point = this.getSlave().logicalPositionToXY(new LogicalPosition(convertedCenterLine, masterPos.column));
                int correction = (viewRect.y + middleY) % this.getMaster().getLineHeight();
                offset = point.y - middleY + correction;
            } else {
                double progress = this.myAnchor.masterStartOffset == this.myAnchor.masterEndOffset || viewRect.y == this.myAnchor.masterEndOffset ? 1.0 : (double)(viewRect.y - this.myAnchor.masterStartOffset) / (double)(this.myAnchor.masterEndOffset - this.myAnchor.masterStartOffset);
                offset = this.myAnchor.slaveStartOffset + (int)((double)(this.myAnchor.slaveEndOffset - this.myAnchor.slaveStartOffset) * progress);
            }
            int deltaHeaderOffset = SyncScrollSupport.getHeaderOffset(this.getSlave()) - SyncScrollSupport.getHeaderOffset(this.getMaster());
            SyncScrollSupport.doScrollVertically(this.getSlave(), offset + deltaHeaderOffset, animated);
        }

        private void syncHorizontalScroll(boolean animated) {
            int offset = this.getMaster().getScrollingModel().getVisibleArea().x;
            SyncScrollSupport.doScrollHorizontally(this.getSlave(), offset, animated);
        }
    }

    private static abstract class SyncScrollSupportBase
    implements Support {
        private int myDuringSyncScrollDepth = 0;

        private SyncScrollSupportBase() {
        }

        public boolean isDuringSyncScroll() {
            return this.myDuringSyncScrollDepth > 0;
        }

        @Override
        public void enterDisableScrollSection() {
            ++this.myDuringSyncScrollDepth;
        }

        @Override
        public void exitDisableScrollSection() {
            --this.myDuringSyncScrollDepth;
            assert (this.myDuringSyncScrollDepth >= 0);
        }

        @NotNull
        protected abstract List<? extends Editor> getEditors();

        @NotNull
        protected abstract List<? extends ScrollHelper> getScrollHelpers();

        protected void doMakeVisible(int masterIndex, int[] startLines, int[] endLines, boolean animate) {
            List<? extends Editor> editors = this.getEditors();
            List<? extends ScrollHelper> helpers = this.getScrollHelpers();
            int count = editors.size();
            assert (startLines.length == count);
            assert (endLines.length == count);
            int[] offsets = SyncScrollSupport.getTargetOffsets(editors.toArray(new Editor[count]), startLines, endLines, -1);
            int[] startOffsets = new int[count];
            for (int i2 = 0; i2 < count; ++i2) {
                startOffsets[i2] = editors.get((int)i2).getScrollingModel().getVisibleArea().y;
            }
            Editor masterEditor = editors.get(masterIndex);
            int masterOffset = offsets[masterIndex];
            int masterStartOffset = startOffsets[masterIndex];
            for (ScrollHelper scrollHelper : helpers) {
                scrollHelper.setAnchor(startOffsets[scrollHelper.getMasterIndex()], offsets[scrollHelper.getMasterIndex()], startOffsets[scrollHelper.getSlaveIndex()], offsets[scrollHelper.getSlaveIndex()]);
            }
            SyncScrollSupport.doScrollHorizontally(masterEditor, 0, false);
            SyncScrollSupport.doScrollVertically(masterEditor, masterOffset, animate);
            masterEditor.getScrollingModel().runActionOnScrollingFinished(() -> {
                for (ScrollHelper helper : helpers) {
                    helper.removeAnchor();
                }
                int masterFinalOffset = masterEditor.getScrollingModel().getVisibleArea().y;
                boolean animateSlaves = animate && masterFinalOffset == masterStartOffset;
                for (int i2 = 0; i2 < count; ++i2) {
                    if (i2 == masterIndex) continue;
                    Editor editor = (Editor)editors.get(i2);
                    int finalOffset = editor.getScrollingModel().getVisibleArea().y;
                    if (finalOffset == offsets[i2]) continue;
                    this.enterDisableScrollSection();
                    SyncScrollSupport.doScrollVertically(editor, offsets[i2], animateSlaves);
                    editor.getScrollingModel().runActionOnScrollingFinished(this::exitDisableScrollSection);
                }
            });
        }
    }

    public static class ThreesideSyncScrollSupport
    extends SyncScrollSupportBase {
        @NotNull
        private final List<? extends Editor> myEditors;
        @NotNull
        private final SyncScrollable myScrollable12;
        @NotNull
        private final SyncScrollable myScrollable23;
        @NotNull
        private final ScrollHelper myHelper12;
        @NotNull
        private final ScrollHelper myHelper21;
        @NotNull
        private final ScrollHelper myHelper23;
        @NotNull
        private final ScrollHelper myHelper32;

        public ThreesideSyncScrollSupport(@NotNull List<? extends Editor> editors, @NotNull SyncScrollable scrollable12, @NotNull SyncScrollable scrollable23) {
            assert (editors.size() == 3);
            this.myEditors = editors;
            this.myScrollable12 = scrollable12;
            this.myScrollable23 = scrollable23;
            this.myHelper12 = this.create(ThreeSide.LEFT, ThreeSide.BASE);
            this.myHelper21 = this.create(ThreeSide.BASE, ThreeSide.LEFT);
            this.myHelper23 = this.create(ThreeSide.BASE, ThreeSide.RIGHT);
            this.myHelper32 = this.create(ThreeSide.RIGHT, ThreeSide.BASE);
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            return this.myEditors;
        }

        @Override
        @NotNull
        protected List<? extends ScrollHelper> getScrollHelpers() {
            return ContainerUtil.list((Object[])new ScrollHelper[]{this.myHelper12, this.myHelper21, this.myHelper23, this.myHelper32});
        }

        @NotNull
        public SyncScrollable getScrollable12() {
            return this.myScrollable12;
        }

        @NotNull
        public SyncScrollable getScrollable23() {
            return this.myScrollable23;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (this.isDuringSyncScroll()) {
                return;
            }
            this.enterDisableScrollSection();
            try {
                if (e.getEditor() == ThreeSide.LEFT.select(this.myEditors)) {
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper12.visibleAreaChanged(e);
                        if (this.myScrollable23.isSyncScrollEnabled()) {
                            this.myHelper23.visibleAreaChanged(e);
                        }
                    }
                } else if (e.getEditor() == ThreeSide.BASE.select(this.myEditors)) {
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                    if (this.myScrollable23.isSyncScrollEnabled()) {
                        this.myHelper23.visibleAreaChanged(e);
                    }
                } else if (e.getEditor() == ThreeSide.RIGHT.select(this.myEditors) && this.myScrollable23.isSyncScrollEnabled()) {
                    this.myHelper32.visibleAreaChanged(e);
                    if (this.myScrollable12.isSyncScrollEnabled()) {
                        this.myHelper21.visibleAreaChanged(e);
                    }
                }
            }
            finally {
                this.exitDisableScrollSection();
            }
        }

        public void makeVisible(@NotNull ThreeSide masterSide, int[] startLines, int[] endLines, boolean animate) {
            this.doMakeVisible(masterSide.getIndex(), startLines, endLines, animate);
        }

        @NotNull
        private ScrollHelper create(@NotNull ThreeSide master, @NotNull ThreeSide slave) {
            SyncScrollable scrollable;
            assert (master != slave);
            assert (master == ThreeSide.BASE || slave == ThreeSide.BASE);
            boolean leftSide = master == ThreeSide.LEFT || slave == ThreeSide.LEFT;
            SyncScrollable syncScrollable = scrollable = leftSide ? this.myScrollable12 : this.myScrollable23;
            Side side = leftSide ? Side.fromLeft((master == ThreeSide.LEFT ? 1 : 0) != 0) : Side.fromLeft((master == ThreeSide.BASE ? 1 : 0) != 0);
            return ScrollHelper.create(this.myEditors, master.getIndex(), slave.getIndex(), scrollable, side);
        }
    }

    public static class TwosideSyncScrollSupport
    extends SyncScrollSupportBase {
        @NotNull
        private final List<? extends Editor> myEditors;
        @NotNull
        private final SyncScrollable myScrollable;
        @NotNull
        private final ScrollHelper myHelper1;
        @NotNull
        private final ScrollHelper myHelper2;

        public TwosideSyncScrollSupport(@NotNull List<? extends Editor> editors, @NotNull SyncScrollable scrollable) {
            this.myEditors = editors;
            this.myScrollable = scrollable;
            this.myHelper1 = this.create(Side.LEFT);
            this.myHelper2 = this.create(Side.RIGHT);
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            return this.myEditors;
        }

        @Override
        @NotNull
        protected List<? extends ScrollHelper> getScrollHelpers() {
            return ContainerUtil.list((Object[])new ScrollHelper[]{this.myHelper1, this.myHelper2});
        }

        @NotNull
        public SyncScrollable getScrollable() {
            return this.myScrollable;
        }

        public void visibleAreaChanged(VisibleAreaEvent e) {
            if (!this.myScrollable.isSyncScrollEnabled() || this.isDuringSyncScroll()) {
                return;
            }
            this.enterDisableScrollSection();
            try {
                if (e.getEditor() == Side.LEFT.select(this.myEditors)) {
                    this.myHelper1.visibleAreaChanged(e);
                } else if (e.getEditor() == Side.RIGHT.select(this.myEditors)) {
                    this.myHelper2.visibleAreaChanged(e);
                }
            }
            finally {
                this.exitDisableScrollSection();
            }
        }

        public void makeVisible(@NotNull Side masterSide, int startLine1, int endLine1, int startLine2, int endLine2, boolean animate) {
            this.doMakeVisible(masterSide.getIndex(), new int[]{startLine1, startLine2}, new int[]{endLine1, endLine2}, animate);
        }

        @NotNull
        private ScrollHelper create(@NotNull Side side) {
            return ScrollHelper.create(this.myEditors, side.getIndex(), side.other().getIndex(), this.myScrollable, side);
        }
    }

    public static interface Support {
        public void enterDisableScrollSection();

        public void exitDisableScrollSection();
    }

    public static interface SyncScrollable {
        public boolean isSyncScrollEnabled();

        public int transfer(@NotNull Side var1, int var2);
    }
}

