/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Condition;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HighlightingLevel {
    INSPECTIONS("Inspections", AllIcons.Ide.HectorOn, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> true)),
    ADVANCED("Syntax", AllIcons.Ide.HectorSyntax, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> rangeHighlighter.getLayer() <= 3000)),
    SIMPLE("None", AllIcons.Ide.HectorOff, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> rangeHighlighter.getLayer() <= 1000));

    @NotNull
    private final String myText;
    @Nullable
    private final Icon myIcon;
    @NotNull
    private final Condition<RangeHighlighter> myCondition;

    private HighlightingLevel(@NotNull String text, Icon icon, Condition<RangeHighlighter> condition2) {
        this.myText = text;
        this.myIcon = icon;
        this.myCondition = condition2;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Condition<RangeHighlighter> getCondition() {
        return this.myCondition;
    }
}

