/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.diff.comparison.ComparisonPolicy;
import org.jetbrains.annotations.NotNull;

public enum IgnorePolicy {
    DEFAULT("Do not ignore"),
    TRIM_WHITESPACES("Trim whitespaces"),
    IGNORE_WHITESPACES("Ignore whitespaces"),
    IGNORE_WHITESPACES_CHUNKS("Ignore whitespaces and empty lines"),
    FORMATTING("Ignore formatting");

    @NotNull
    private final String myText;

    private IgnorePolicy(String text) {
        this.myText = text;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public ComparisonPolicy getComparisonPolicy() {
        switch (this) {
            case DEFAULT: {
                return ComparisonPolicy.DEFAULT;
            }
            case TRIM_WHITESPACES: {
                return ComparisonPolicy.TRIM_WHITESPACES;
            }
            case IGNORE_WHITESPACES: {
                return ComparisonPolicy.IGNORE_WHITESPACES;
            }
            case IGNORE_WHITESPACES_CHUNKS: {
                return ComparisonPolicy.IGNORE_WHITESPACES;
            }
            case FORMATTING: {
                return ComparisonPolicy.DEFAULT;
            }
        }
        throw new IllegalArgumentException(this.name());
    }

    public boolean isShouldTrimChunks() {
        return this == IGNORE_WHITESPACES_CHUNKS;
    }
}

