/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public class LineOffsets {
    private final int[] myLineEnds;
    private final int myTextLength;

    private LineOffsets(int[] ends, int length) {
        this.myLineEnds = ends;
        this.myTextLength = length;
    }

    public int getLineStart(int line) {
        this.checkLineIndex(line);
        if (line == 0) {
            return 0;
        }
        return this.myLineEnds[line - 1] + 1;
    }

    public int getLineEnd(int line) {
        this.checkLineIndex(line);
        return this.myLineEnds[line];
    }

    public int getLineCount() {
        return this.myLineEnds.length;
    }

    public int getTextLength() {
        return this.myTextLength;
    }

    private void checkLineIndex(int index) {
        if (index < 0 || index >= this.getLineCount()) {
            throw new IndexOutOfBoundsException("Wrong line: " + index + ". Available lines count: " + this.getLineCount());
        }
    }

    @NotNull
    public static LineOffsets create(@NotNull CharSequence text) {
        int lineEnd;
        TIntArrayList ends = new TIntArrayList();
        int index = 0;
        while ((lineEnd = StringUtil.indexOf((CharSequence)text, (char)'\n', (int)index)) != -1) {
            ends.add(lineEnd);
            index = lineEnd + 1;
        }
        ends.add(text.length());
        return new LineOffsets(ends.toNativeArray(), text.length());
    }
}

