/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.text;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.text.TextDiffProviderBase;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TwosideTextDiffProviderBase
extends TextDiffProviderBase
implements TwosideTextDiffProvider {
    protected TwosideTextDiffProviderBase(@NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable, @NotNull IgnorePolicy[] ignorePolicies, @NotNull HighlightPolicy[] highlightPolicies) {
        super(settings, rediff, disposable, ignorePolicies, highlightPolicies);
    }

    @Override
    @Nullable
    public List<LineFragment> compare(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ProgressIndicator indicator) {
        IgnorePolicy ignorePolicy = this.getIgnorePolicy();
        HighlightPolicy highlightPolicy = this.getHighlightPolicy();
        if (!highlightPolicy.isShouldCompare()) {
            return null;
        }
        ComparisonPolicy policy = ignorePolicy.getComparisonPolicy();
        boolean innerFragments = highlightPolicy.isFineFragments();
        boolean squashFragments = highlightPolicy.isShouldSquash();
        boolean trimFragments = ignorePolicy.isShouldTrimChunks();
        indicator.checkCanceled();
        List<LineFragment> fragments = this.doCompare(text1, text2, ignorePolicy, innerFragments, indicator);
        indicator.checkCanceled();
        return ComparisonManager.getInstance().processBlocks(fragments, text1, text2, policy, squashFragments, trimFragments);
    }

    @NotNull
    protected abstract List<LineFragment> doCompare(@NotNull CharSequence var1, @NotNull CharSequence var2, @NotNull IgnorePolicy var3, boolean var4, @NotNull ProgressIndicator var5);
}

