/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.openapi.diff.impl.splitter.Transformation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDividerDrawUtil {
    public static final BasicStroke BOLD_DOTTED_STROKE = new BasicStroke(2.3f, 0, 0, 10.0f, new float[]{2.0f, 2.0f}, 0.0f);

    @NotNull
    public static Graphics2D getDividerGraphics(@NotNull Graphics g, @NotNull Component divider, @NotNull Component base) {
        int width = divider.getWidth();
        int editorHeight = base.getHeight();
        int dividerOffset = divider.getLocationOnScreen().y;
        int editorOffset = base.getLocationOnScreen().y;
        return (Graphics2D)g.create(0, editorOffset - dividerOffset, width, editorHeight);
    }

    public static void paintSeparators(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        List<DividerSeparator> polygons = DiffDividerDrawUtil.createVisibleSeparators(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerSeparator polygon : polygons) {
            polygon.paint(gg, width);
        }
        config.restore();
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        DiffDividerDrawUtil.paintPolygons(gg, width, true, true, editor1, editor2, paintable);
    }

    public static void paintSimplePolygons(@NotNull Graphics2D gg, int width, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        DiffDividerDrawUtil.paintPolygons(gg, width, true, false, editor1, editor2, paintable);
    }

    public static void paintPolygons(@NotNull Graphics2D gg, int width, boolean paintBorder, boolean curved, @NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        List<DividerPolygon> polygons = DiffDividerDrawUtil.createVisiblePolygons(editor1, editor2, paintable);
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)gg);
        for (DividerPolygon polygon : polygons) {
            polygon.paint(gg, width, paintBorder, curved);
        }
        config.restore();
    }

    @NotNull
    public static List<DividerPolygon> createVisiblePolygons(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerPaintable paintable) {
        final ArrayList<DividerPolygon> polygons = new ArrayList<DividerPolygon>();
        final Transformation[] transformations = new Transformation[]{DiffDividerDrawUtil.getTransformation(editor1), DiffDividerDrawUtil.getTransformation(editor2)};
        final LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        final LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        paintable.process(new DividerPaintable.Handler(){

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color, boolean resolved) {
                if (leftInterval.start > endLine1 && rightInterval.start > endLine2) {
                    return true;
                }
                if (leftInterval.end < startLine1 && rightInterval.end < startLine2) {
                    return false;
                }
                polygons.add(DiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, color, resolved));
                return true;
            }

            @Override
            public boolean process(int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
                return this.process(startLine1, endLine1, startLine2, endLine2, color, false);
            }
        });
        return polygons;
    }

    @NotNull
    public static List<DividerSeparator> createVisibleSeparators(@NotNull Editor editor1, @NotNull Editor editor2, @NotNull DividerSeparatorPaintable paintable) {
        ArrayList<DividerSeparator> separators = new ArrayList<DividerSeparator>();
        Transformation[] transformations = new Transformation[]{DiffDividerDrawUtil.getTransformation(editor1), DiffDividerDrawUtil.getTransformation(editor2)};
        LineRange leftInterval = DiffDividerDrawUtil.getVisibleInterval(editor1);
        LineRange rightInterval = DiffDividerDrawUtil.getVisibleInterval(editor2);
        int height1 = editor1.getLineHeight();
        int height2 = editor2.getLineHeight();
        EditorColorsScheme scheme2 = editor1.getColorsScheme();
        paintable.process((line1, line2) -> {
            if (leftInterval.start > line1 + 1 && rightInterval.start > line2 + 1) {
                return true;
            }
            if (leftInterval.end < line1 && rightInterval.end < line2) {
                return false;
            }
            separators.add(DiffDividerDrawUtil.createSeparator(transformations, line1, line2, height1, height2, scheme2));
            return true;
        });
        return separators;
    }

    @NotNull
    private static Transformation getTransformation(@NotNull Editor editor) {
        return line -> {
            int yOffset = editor.logicalPositionToXY((LogicalPosition)new LogicalPosition((int)line, (int)0)).y;
            JComponent header = editor.getHeaderComponent();
            int headerOffset = header == null ? 0 : header.getHeight();
            return yOffset - editor.getScrollingModel().getVerticalScrollOffset() + headerOffset;
        };
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color) {
        return DiffDividerDrawUtil.createPolygon(transformations, startLine1, endLine1, startLine2, endLine2, color, false);
    }

    @NotNull
    private static DividerPolygon createPolygon(@NotNull Transformation[] transformations, int startLine1, int endLine1, int startLine2, int endLine2, @NotNull Color color, boolean resolved) {
        int start1 = transformations[0].transform(startLine1);
        int end1 = transformations[0].transform(endLine1);
        int start2 = transformations[1].transform(startLine2);
        int end2 = transformations[1].transform(endLine2);
        return new DividerPolygon(start1, start2, end1, end2, color, resolved);
    }

    @NotNull
    private static DividerSeparator createSeparator(@NotNull Transformation[] transformations, int line1, int line2, int height1, int height2, @Nullable EditorColorsScheme scheme2) {
        int start1 = transformations[0].transform(line1);
        int start2 = transformations[1].transform(line2);
        return new DividerSeparator(start1, start2, start1 + height1, start2 + height2, scheme2);
    }

    @NotNull
    private static LineRange getVisibleInterval(Editor editor) {
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        if (area.height < 0) {
            return new LineRange(0, 0);
        }
        LogicalPosition position1 = editor.xyToLogicalPosition(new Point(0, area.y));
        LogicalPosition position2 = editor.xyToLogicalPosition(new Point(0, area.y + area.height));
        return new LineRange(position1.line, position2.line);
    }

    public static class DividerSeparator {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @Nullable
        private final EditorColorsScheme myScheme;

        public DividerSeparator(int start1, int start2, int end1, int end2) {
            this(start1, start2, end1, end2, null);
        }

        public DividerSeparator(int start1, int start2, int end1, int end2, @Nullable EditorColorsScheme scheme2) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myScheme = scheme2;
        }

        public void paint(Graphics2D g, int width) {
            DiffDrawUtil.drawConnectorLineSeparator(g, 0, width, this.myStart1, this.myEnd1, this.myStart2, this.myEnd2, this.myScheme);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> ";
        }
    }

    public static class DividerPolygon {
        private final int myStart1;
        private final int myStart2;
        private final int myEnd1;
        private final int myEnd2;
        @NotNull
        private final Color myColor;
        private final boolean myResolved;

        public DividerPolygon(int start1, int start2, int end1, int end2, @NotNull Color color) {
            this(start1, start2, end1, end2, color, false);
        }

        public DividerPolygon(int start1, int start2, int end1, int end2, @NotNull Color color, boolean resolved) {
            this.myStart1 = start1;
            this.myStart2 = start2;
            this.myEnd1 = end1;
            this.myEnd2 = end2;
            this.myColor = color;
            this.myResolved = resolved;
        }

        public void paint(Graphics2D g, int width, boolean paintBorder, boolean curve) {
            Color borderColor;
            int endY2;
            int startY2;
            int endY1;
            int startY1;
            if (this.myEnd1 - this.myStart1 < 2) {
                startY1 = this.myStart1 - 1;
                endY1 = this.myStart1;
            } else {
                startY1 = this.myStart1;
                endY1 = this.myEnd1 - 1;
            }
            if (this.myEnd2 - this.myStart2 < 2) {
                startY2 = this.myStart2 - 1;
                endY2 = this.myStart2;
            } else {
                startY2 = this.myStart2;
                endY2 = this.myEnd2 - 1;
            }
            Stroke oldStroke = g.getStroke();
            if (this.myResolved) {
                g.setStroke(BOLD_DOTTED_STROKE);
            }
            Color fillColor = this.myResolved ? null : this.myColor;
            Color color = borderColor = this.myResolved ? this.myColor : null;
            if (curve) {
                DiffDrawUtil.drawCurveTrapezium(g, 0, width, startY1, endY1, startY2, endY2, fillColor, borderColor);
            } else {
                DiffDrawUtil.drawTrapezium(g, 0, width, startY1, endY1, startY2, endY2, fillColor, borderColor);
            }
            g.setStroke(oldStroke);
        }

        public String toString() {
            return "<" + this.myStart1 + ", " + this.myEnd1 + " : " + this.myStart2 + ", " + this.myEnd2 + "> " + this.myColor;
        }
    }

    public static interface DividerSeparatorPaintable {
        public void process(@NotNull Handler var1);

        public static interface Handler {
            public boolean process(int var1, int var2);
        }
    }

    public static interface DividerPaintable {
        public void process(@NotNull Handler var1);

        public static abstract class Handler {
            public abstract boolean process(int var1, int var2, int var3, int var4, @NotNull Color var5);

            public abstract boolean process(int var1, int var2, int var3, int var4, @NotNull Color var5, boolean var6);
        }
    }
}

