/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDrawUtil {
    public static final int STRIPE_LAYER = 4999;
    public static final int DEFAULT_LAYER = 5997;
    public static final int INLINE_LAYER = 5998;
    public static final int LINE_MARKER_LAYER = 5999;
    public static final int LST_LINE_MARKER_LAYER = 5999;
    private static final double CTRL_PROXIMITY_X = 0.3;
    public static final LineSeparatorRenderer BORDER_LINE_RENDERER = new LineSeparatorRenderer(){

        public void drawLine(Graphics g, int x1, int x2, int y) {
            Rectangle clip = g.getClipBounds();
            x2 = clip.x + clip.width;
            g.setColor(JBColor.border());
            g.drawLine(x1, y, x2, y);
        }
    };

    private DiffDrawUtil() {
    }

    @NotNull
    public static Color getDividerColor() {
        return DiffDrawUtil.getDividerColor(null);
    }

    @NotNull
    public static Color getDividerColor(@Nullable Editor editor) {
        return DiffDrawUtil.getDividerColorFromScheme(editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme());
    }

    @NotNull
    public static Color getDividerColorFromScheme(@NotNull EditorColorsScheme scheme2) {
        Color gutterBackground = scheme2.getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        return gutterBackground;
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2) {
        DiffDrawUtil.drawConnectorLineSeparator(g, x1, x2, start1, end1, start2, end2, null);
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable EditorColorsScheme scheme2) {
        DiffLineSeparatorRenderer.drawConnectorLine(g, x1, x2, start1, start2, end1 - start1, scheme2);
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        if (dottedLine && doubleLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
        } else if (dottedLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
        } else if (doubleLine) {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)(y + 1), (int)x2, (int)(y + 1), null, (Color)color);
        } else {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
        }
    }

    public static void drawTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (fillColor != null) {
            int[] xPoints = new int[]{x1, x2, x2, x1};
            int[] yPoints = new int[]{start1, start2, end2 + 1, end1 + 1};
            g.setColor(fillColor);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawLine(x1, start1, x2, start2);
            g.drawLine(x1, end1, x2, end2);
        }
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        Shape upperCurve = DiffDrawUtil.makeCurve(x1, x2, start1, start2, true);
        Shape lowerCurve = DiffDrawUtil.makeCurve(x1, x2, end1 + 1, end2 + 1, false);
        Shape lowerCurveBorder = DiffDrawUtil.makeCurve(x1, x2, end1, end2, false);
        if (fillColor != null) {
            Path2D.Double path = new Path2D.Double();
            path.append(upperCurve, true);
            path.append(lowerCurve, true);
            g.setColor(fillColor);
            g.fill(path);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.draw(upperCurve);
            g.draw(lowerCurveBorder);
        }
    }

    private static Shape makeCurve(int x1, int x2, int y1, int y2, boolean forward) {
        int width = x2 - x1;
        if (forward) {
            return new CubicCurve2D.Double(x1, y1, (double)x1 + (double)width * 0.3, y1, (double)x1 + (double)width * 0.7, y2, x1 + width, y2);
        }
        return new CubicCurve2D.Double(x1 + width, y2, (double)x1 + (double)width * 0.7, y2, (double)x1 + (double)width * 0.3, y1, x1, y1);
    }

    public static int lineToY(@NotNull Editor editor, int line) {
        Document document = editor.getDocument();
        if (line >= DiffUtil.getLineCount(document)) {
            int y = DiffDrawUtil.lineToY(editor, DiffUtil.getLineCount(document) - 1);
            return y + editor.getLineHeight() * (line - DiffUtil.getLineCount(document) + 1);
        }
        return editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document.getLineStartOffset((int)line))).y;
    }

    @NotNull
    private static TextAttributes getTextAttributes(final @NotNull TextDiffType type2, final @Nullable Editor editor, final boolean ignored) {
        return new TextAttributes(){

            public Color getBackgroundColor() {
                return ignored ? type2.getIgnoredColor(editor) : type2.getColor(editor);
            }
        };
    }

    @NotNull
    private static TextAttributes getStripeTextAttributes(final @NotNull TextDiffType type2, final @NotNull Editor editor) {
        return new TextAttributes(){

            public Color getErrorStripeColor() {
                return type2.getMarkerColor(editor);
            }
        };
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type2) {
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type2));
    }

    @NotNull
    private static LineSeparatorRenderer createDiffLineRenderer(final @NotNull Editor editor, final @NotNull TextDiffType type2, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        return new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Rectangle clip = g.getClipBounds();
                x2 = clip.x + clip.width;
                if (placement == SeparatorPlacement.TOP) {
                    ++y;
                }
                DiffDrawUtil.drawChunkBorderLine((Graphics2D)g, x1, x2, y, type2.getColor(editor), doubleLine, resolved);
            }
        };
    }

    @NotNull
    private static LineMarkerRenderer createFoldingGutterLineRenderer(final @NotNull TextDiffType type2, final @NotNull SeparatorPlacement placement, final boolean doubleLine, final boolean resolved) {
        return new LineMarkerRendererEx(){

            public void paint(Editor editor, Graphics g, Rectangle r) {
                EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
                Graphics2D g2 = (Graphics2D)g;
                int x1 = gutter.getWhitespaceSeparatorOffset();
                int x2 = gutter.getWidth();
                int y = r.y;
                if (placement == SeparatorPlacement.BOTTOM) {
                    y += editor.getLineHeight();
                }
                DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y - 1, type2.getColor(editor), doubleLine, resolved);
            }

            @Override
            @NotNull
            public LineMarkerRendererEx.Position getPosition() {
                return LineMarkerRendererEx.Position.CUSTOM;
            }
        };
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, @Nullable List<DiffFragment> innerFragments) {
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list = new ArrayList<RangeHighlighter>();
        if (!inserted.isEmpty() && !deleted.isEmpty()) {
            list.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored));
            list.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored));
        } else if (!inserted.isEmpty()) {
            list.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored));
        } else if (!deleted.isEmpty()) {
            list.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored));
        }
        if (innerFragments != null) {
            int deletedStartOffset = editor.getDocument().getLineStartOffset(deleted.start);
            int insertedStartOffset = editor.getDocument().getLineStartOffset(inserted.start);
            for (DiffFragment fragment : innerFragments) {
                int deletedWordStart = deletedStartOffset + fragment.getStartOffset1();
                int deletedWordEnd = deletedStartOffset + fragment.getEndOffset1();
                list.addAll(DiffDrawUtil.createInlineHighlighter(editor, deletedWordStart, deletedWordEnd, TextDiffType.DELETED));
                int insertedWordStart = insertedStartOffset + fragment.getStartOffset2();
                int insertedWordEnd = insertedStartOffset + fragment.getEndOffset2();
                list.addAll(DiffDrawUtil.createInlineHighlighter(editor, insertedWordStart, insertedWordEnd, TextDiffType.INSERTED));
            }
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type2, boolean ignored) {
        return new LineHighlighterBuilder(editor, startLine, endLine, type2).withIgnored(ignored).done();
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type2, boolean ignored, boolean resolved, boolean hideWithoutLineNumbers) {
        return new LineHighlighterBuilder(editor, startLine, endLine, type2).withIgnored(ignored).withResolved(resolved).withHideWithoutLineNumbers(hideWithoutLineNumbers).done();
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type2) {
        return new InlineHighlighterBuilder(editor, start, end, type2).done();
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type2) {
        if (line == 0) {
            return Collections.emptyList();
        }
        return DiffDrawUtil.createLineMarker(editor, line - 1, type2, SeparatorPlacement.BOTTOM, false, false, true);
    }

    @NotNull
    private static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type2, @NotNull SeparatorPlacement placement, boolean doubleLine, boolean resolved, boolean paintFoldingOutline) {
        LineMarkerBuilder builder = new LineMarkerBuilder(editor, line, placement).withType(type2).withResolved(resolved).withDefaultRenderer(doubleLine);
        if (paintFoldingOutline) {
            builder.withDefaultGutterRenderer(doubleLine);
        }
        return builder.done();
    }

    @NotNull
    public static List<RangeHighlighter> createBorderLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
        return new LineMarkerBuilder(editor, line, placement).withRenderer(BORDER_LINE_RENDERER).done();
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition2) {
        RangeHighlighter marker = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
        DiffLineSeparatorRenderer renderer = new DiffLineSeparatorRenderer(editor, condition2);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        return Collections.singletonList(marker);
    }

    private static class LineMarkerBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        private final int line;
        private boolean resolved = false;
        @Nullable
        private TextDiffType type;
        @Nullable
        private LineSeparatorRenderer renderer;
        @Nullable
        private LineMarkerRenderer gutterRenderer;

        private LineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
            this.editor = editor;
            this.line = line;
            this.placement = placement;
        }

        @NotNull
        public LineMarkerBuilder withType(@NotNull TextDiffType type2) {
            this.type = type2;
            return this;
        }

        @NotNull
        public LineMarkerBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        @NotNull
        public LineMarkerBuilder withRenderer(@NotNull LineSeparatorRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        @NotNull
        public LineMarkerBuilder withDefaultRenderer(boolean doubleLine) {
            assert (this.type != null);
            this.renderer = DiffDrawUtil.createDiffLineRenderer(this.editor, this.type, this.placement, doubleLine, this.resolved);
            return this;
        }

        @NotNull
        public LineMarkerBuilder withDefaultGutterRenderer(boolean doubleLine) {
            assert (this.type != null);
            this.gutterRenderer = DiffDrawUtil.createFoldingGutterLineRenderer(this.type, this.placement, doubleLine, this.resolved);
            return this;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.editor.getDocument(), this.line);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(offset, offset, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
            highlighter.setLineSeparatorPlacement(this.placement);
            highlighter.setLineSeparatorRenderer(this.renderer);
            highlighter.setLineMarkerRenderer(this.gutterRenderer);
            if (this.type == null || this.resolved) {
                return Collections.singletonList(highlighter);
            }
            TextAttributes stripeAttributes = DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(offset, offset, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            return ContainerUtil.list((Object[])new RangeHighlighter[]{highlighter, stripeHighlighter});
        }
    }

    private static class InlineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int start;
        private final int end;

        private InlineHighlighterBuilder(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type2) {
            this.editor = editor;
            this.type = type2;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            TextAttributes attributes = DiffDrawUtil.getTextAttributes(this.type, this.editor, false);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(this.start, this.end, 5998, attributes, HighlighterTargetArea.EXACT_RANGE);
            if (this.start == this.end) {
                DiffDrawUtil.installEmptyRangeRenderer(highlighter, this.type);
            }
            return Collections.singletonList(highlighter);
        }
    }

    private static class LineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int startLine;
        private final int endLine;
        private boolean ignored = false;
        private boolean resolved = false;
        private boolean hideWithoutLineNumbers = false;

        private LineHighlighterBuilder(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type2) {
            this.editor = editor;
            this.type = type2;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @NotNull
        public LineHighlighterBuilder withIgnored(boolean ignored) {
            this.ignored = ignored;
            return this;
        }

        @NotNull
        public LineHighlighterBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        public LineHighlighterBuilder withHideWithoutLineNumbers(boolean hideWithoutLineNumbers) {
            this.hideWithoutLineNumbers = hideWithoutLineNumbers;
            return this;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
            boolean isEmptyRange = this.startLine == this.endLine;
            boolean isLastLine = this.endLine == DiffUtil.getLineCount(this.editor.getDocument());
            TextRange offsets = DiffUtil.getLinesRange(this.editor.getDocument(), this.startLine, this.endLine);
            int start = offsets.getStartOffset();
            int end = offsets.getEndOffset();
            TextAttributes attributes = isEmptyRange || this.resolved ? null : DiffDrawUtil.getTextAttributes(this.type, this.editor, this.ignored);
            TextAttributes stripeAttributes = isEmptyRange || this.resolved ? null : DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, 5997, attributes, HighlighterTargetArea.LINES_IN_RANGE);
            highlighters.add(highlighter);
            highlighter.setLineMarkerRenderer((LineMarkerRenderer)new DiffLineMarkerRenderer(highlighter, this.type, this.ignored, this.resolved, this.hideWithoutLineNumbers, isEmptyRange, isLastLine));
            if (isEmptyRange) {
                if (this.startLine == 0) {
                    highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, 0, this.type, SeparatorPlacement.TOP, true, this.resolved, false));
                } else {
                    highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.startLine - 1, this.type, SeparatorPlacement.BOTTOM, true, this.resolved, false));
                }
            } else if (this.resolved) {
                highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.startLine, this.type, SeparatorPlacement.TOP, false, this.resolved, false));
                highlighters.addAll(DiffDrawUtil.createLineMarker(this.editor, this.endLine - 1, this.type, SeparatorPlacement.BOTTOM, false, this.resolved, false));
            }
            if (stripeAttributes != null) {
                RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
                highlighters.add(stripeHighlighter);
            }
            return highlighters;
        }
    }
}

