/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.Graphics;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class DiffEmptyHighlighterRenderer
implements CustomHighlighterRenderer {
    @NotNull
    private final TextDiffType myDiffType;

    public DiffEmptyHighlighterRenderer(@NotNull TextDiffType diffType) {
        this.myDiffType = diffType;
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        g.setColor(this.myDiffType.getColor(editor));
        Point point = editor.logicalPositionToXY(editor.offsetToLogicalPosition(highlighter.getStartOffset()));
        int endy = point.y + editor.getLineHeight() - 1;
        g.drawLine(point.x, point.y, point.x, endy);
        g.drawLine(point.x - 1, point.y, point.x - 1, endy);
    }
}

