/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.diff.DiffContext;
import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffTool;
import com.intellij.diff.SuppressiveDiffTool;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DiffPsiFileSupport;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.fragments.MergeWordFragment;
import com.intellij.diff.impl.DiffSettingsHolder;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.util.base.TextDiffSettingsHolder;
import com.intellij.diff.tools.util.base.TextDiffViewerUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.MergeInnerDifferences;
import com.intellij.diff.tools.util.text.SimpleTextDiffProvider;
import com.intellij.diff.tools.util.text.SmartTextDiffProvider;
import com.intellij.diff.tools.util.text.TwosideTextDiffProvider;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.util.EmptyEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapperDialog;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.WindowWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUtil {
    private static final Logger LOG = Logger.getInstance(DiffUtil.class);
    @NotNull
    public static final String DIFF_CONFIG = "diff.xml";
    public static final int TITLE_GAP = JBUI.scale((int)2);

    public static boolean isDiffEditor(@NotNull Editor editor) {
        return editor.getUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY) != null;
    }

    @Nullable
    public static EditorHighlighter initEditorHighlighter(@Nullable Project project2, @NotNull DocumentContent content, @NotNull CharSequence text) {
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project2, content);
        if (highlighter == null) {
            return null;
        }
        highlighter.setText(text);
        return highlighter;
    }

    @NotNull
    public static EditorHighlighter initEmptyEditorHighlighter(@NotNull CharSequence text) {
        EditorHighlighter highlighter = DiffUtil.createEmptyEditorHighlighter();
        highlighter.setText(text);
        return highlighter;
    }

    @Nullable
    private static EditorHighlighter createEditorHighlighter(@Nullable Project project2, @NotNull DocumentContent content) {
        FileType type2 = content.getContentType();
        VirtualFile file2 = content.getHighlightFile();
        Language language = (Language)content.getUserData(DiffUserDataKeys.LANGUAGE);
        EditorHighlighterFactory highlighterFactory = EditorHighlighterFactory.getInstance();
        if (language != null) {
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)language, (Project)project2, (VirtualFile)file2);
            return highlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme());
        }
        if (file2 != null && file2.isValid() && (type2 == null || type2 == PlainTextFileType.INSTANCE || file2.getFileType() == type2 || file2 instanceof LightVirtualFile)) {
            return highlighterFactory.createEditorHighlighter(project2, file2);
        }
        if (type2 != null) {
            return highlighterFactory.createEditorHighlighter(project2, type2);
        }
        return null;
    }

    @NotNull
    private static EditorHighlighter createEmptyEditorHighlighter() {
        return new EmptyEditorHighlighter(EditorColorsManager.getInstance().getGlobalScheme().getAttributes(HighlighterColors.TEXT));
    }

    public static void setEditorHighlighter(@Nullable Project project2, @NotNull EditorEx editor, @NotNull DocumentContent content) {
        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(project2, content);
        if (highlighter != null) {
            editor.setHighlighter(highlighter);
        }
    }

    public static void setEditorCodeStyle(@Nullable Project project2, @NotNull EditorEx editor, @Nullable FileType fileType) {
        if (project2 != null && fileType != null) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project2);
            editor.getSettings().setTabSize(codeStyleFacade.getTabSize(fileType));
            editor.getSettings().setUseTabCharacter(codeStyleFacade.useTabCharacter(fileType));
        }
        editor.getSettings().setCaretRowShown(false);
        editor.reinitSettings();
    }

    public static void setFoldingModelSupport(@NotNull EditorEx editor) {
        editor.getSettings().setFoldingOutlineShown(true);
        editor.getSettings().setAutoCodeFoldingEnabled(false);
        editor.getColorsScheme().setAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES, null);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project2, boolean isViewer) {
        return DiffUtil.createEditor(document, project2, isViewer, false);
    }

    @NotNull
    public static EditorEx createEditor(@NotNull Document document, @Nullable Project project2, boolean isViewer, boolean enableFolding) {
        EditorFactory factory = EditorFactory.getInstance();
        EditorEx editor = (EditorEx)(isViewer ? factory.createViewer(document, project2) : factory.createEditor(document, project2));
        editor.putUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY, Boolean.TRUE);
        editor.getSettings().setShowIntentionBulb(false);
        ((EditorMarkupModel)((Object)editor.getMarkupModel())).setErrorStripeVisible(true);
        editor.getGutterComponentEx().setShowDefaultGutterPopup(false);
        if (enableFolding) {
            DiffUtil.setFoldingModelSupport(editor);
        } else {
            editor.getSettings().setFoldingOutlineShown(false);
            editor.getFoldingModel().setFoldingEnabled(false);
        }
        UIUtil.removeScrollBorder((Component)editor.getComponent());
        return editor;
    }

    public static void configureEditor(@NotNull EditorEx editor, @NotNull DocumentContent content, @Nullable Project project2) {
        DiffUtil.setEditorHighlighter(project2, editor, content);
        DiffUtil.setEditorCodeStyle(project2, editor, content.getContentType());
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(content.getDocument());
        if (virtualFile != null && Registry.is((String)"diff.enable.psi.highlighting")) {
            editor.setFile(virtualFile);
        }
    }

    public static boolean isMirrored(@NotNull Editor editor) {
        if (editor instanceof EditorEx) {
            return ((EditorEx)editor).getVerticalScrollbarOrientation() == 0;
        }
        return false;
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean canNavigateToFile(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (project2 == null || project2.isDefault()) {
            return false;
        }
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        return !DiffPsiFileSupport.isDiffFile(file2);
    }

    public static void disableBlitting(@NotNull EditorEx editor) {
        if (Registry.is((String)"diff.divider.repainting.disable.blitting")) {
            editor.getScrollPane().getViewport().setScrollMode(0);
        }
    }

    public static void moveCaret(@Nullable Editor editor, int line) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, 0));
    }

    public static void scrollEditor(@Nullable Editor editor, int line, boolean animated) {
        DiffUtil.scrollEditor(editor, line, 0, animated);
    }

    public static void scrollEditor(@Nullable Editor editor, int line, int column, boolean animated) {
        if (editor == null) {
            return;
        }
        editor.getCaretModel().removeSecondaryCarets();
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, column));
        DiffUtil.scrollToCaret(editor, animated);
    }

    public static void scrollToPoint(@Nullable Editor editor, @NotNull Point point, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollHorizontally(point.x);
        editor.getScrollingModel().scrollVertically(point.y);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    public static void scrollToCaret(@Nullable Editor editor, boolean animated) {
        if (editor == null) {
            return;
        }
        if (!animated) {
            editor.getScrollingModel().disableAnimation();
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        if (!animated) {
            editor.getScrollingModel().enableAnimation();
        }
    }

    @NotNull
    public static Point getScrollingPosition(@Nullable Editor editor) {
        if (editor == null) {
            return new Point(0, 0);
        }
        ScrollingModel model = editor.getScrollingModel();
        return new Point(model.getHorizontalScrollOffset(), model.getVerticalScrollOffset());
    }

    @NotNull
    public static LogicalPosition getCaretPosition(@Nullable Editor editor) {
        return editor != null ? editor.getCaretModel().getLogicalPosition() : new LogicalPosition(0, 0);
    }

    @NotNull
    public static Icon getArrowIcon(@NotNull Side sourceSide) {
        return (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRight, (Object)AllIcons.Diff.Arrow);
    }

    @NotNull
    public static Icon getArrowDownIcon(@NotNull Side sourceSide) {
        return (Icon)sourceSide.select((Object)AllIcons.Diff.ArrowRightDown, (Object)AllIcons.Diff.ArrowLeftDown);
    }

    public static void registerAction(@NotNull AnAction action, @NotNull JComponent component) {
        action.registerCustomShortcutSet(action.getShortcutSet(), component);
    }

    @NotNull
    public static JPanel createMessagePanel(@NotNull String message2) {
        String text = StringUtil.replace((String)message2, (String)"\n", (String)"<br>");
        JBLabel label = new JBLabel(text){

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                size.width = Math.min(size.width, 200);
                size.height = Math.min(size.height, 100);
                return size;
            }
        }.setCopyable(true);
        label.setForeground(UIUtil.getInactiveTextColor());
        return new CenteredPanel((JComponent)label, JBUI.Borders.empty((int)5));
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, AnAction ... actions) {
        DiffUtil.addActionBlock(group, Arrays.asList(actions));
    }

    public static void addActionBlock(@NotNull DefaultActionGroup group, @Nullable List<? extends AnAction> actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        group.addSeparator();
        Object[] children2 = group.getChildren(null);
        for (AnAction anAction : actions) {
            if (!(anAction instanceof Separator) && ArrayUtil.contains((Object)anAction, (Object[])children2)) continue;
            group.add(anAction);
        }
    }

    @NotNull
    public static String getSettingsConfigurablePath() {
        return "Settings | Tools | Diff";
    }

    @NotNull
    public static String createTooltipText(@NotNull String text, @Nullable String appendix) {
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text);
        if (appendix != null) {
            result2.append("<br><div style='margin-top: 5px'><font size='2'>");
            result2.append(appendix);
            result2.append("</font></div>");
        }
        result2.append("</body></html>");
        return result2.toString();
    }

    @NotNull
    public static String createNotificationText(@NotNull String text, @Nullable String appendix) {
        StringBuilder result2 = new StringBuilder();
        result2.append("<html><body>");
        result2.append(text);
        if (appendix != null) {
            result2.append("<br><span style='color:#").append(ColorUtil.toHex((Color)JBColor.gray)).append("'><small>");
            result2.append(appendix);
            result2.append("</small></span>");
        }
        result2.append("</body></html>");
        return result2.toString();
    }

    public static void showSuccessPopup(@NotNull String message2, @NotNull RelativePoint point, @NotNull Disposable disposable, final @Nullable Runnable hyperlinkHandler) {
        HyperlinkAdapter listener2 = null;
        if (hyperlinkHandler != null) {
            listener2 = new HyperlinkAdapter(){

                protected void hyperlinkActivated(HyperlinkEvent e) {
                    hyperlinkHandler.run();
                }
            };
        }
        Color bgColor = MessageType.INFO.getPopupBackground();
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message2, null, bgColor, (HyperlinkListener)listener2).setAnimationCycle(200).createBalloon();
        balloon.show(point, Balloon.Position.below);
        Disposer.register((Disposable)disposable, (Disposable)balloon);
    }

    @NotNull
    public static List<JComponent> createSimpleTitles(@NotNull ContentDiffRequest request) {
        List contents = request.getContents();
        List titles = request.getContentTitles();
        if (!ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            return Collections.nCopies(titles.size(), null);
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>(titles.size());
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i2))));
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i2));
            components.add(title);
        }
        return components;
    }

    @NotNull
    public static List<JComponent> createTextTitles(@NotNull ContentDiffRequest request, @NotNull List<? extends Editor> editors) {
        List contents = request.getContents();
        List titles = request.getContentTitles();
        boolean equalCharsets = TextDiffViewerUtil.areEqualCharsets(contents);
        boolean equalSeparators = TextDiffViewerUtil.areEqualLineSeparators(contents);
        ArrayList<JComponent> result2 = new ArrayList<JComponent>(contents.size());
        if (equalCharsets && equalSeparators && !ContainerUtil.exists((Iterable)titles, (Condition)Condition.NOT_NULL)) {
            return Collections.nCopies(titles.size(), null);
        }
        for (int i2 = 0; i2 < contents.size(); ++i2) {
            JComponent title = DiffUtil.createTitle(StringUtil.notNullize((String)((String)titles.get(i2))), (DiffContent)contents.get(i2), equalCharsets, equalSeparators, editors.get(i2));
            title = DiffUtil.createTitleWithNotifications(title, (DiffContent)contents.get(i2));
            result2.add(title);
        }
        return result2;
    }

    @Nullable
    private static JComponent createTitleWithNotifications(@Nullable JComponent title, @NotNull DiffContent content) {
        List<JComponent> notifications = DiffUtil.getCustomNotifications(content);
        if (notifications.isEmpty()) {
            return title;
        }
        ArrayList<JComponent> components = new ArrayList<JComponent>();
        if (title != null) {
            components.add(title);
        }
        components.addAll(notifications);
        return DiffUtil.createStackedComponents(components, TITLE_GAP);
    }

    @Nullable
    private static JComponent createTitle(@NotNull String title, @NotNull DiffContent content, boolean equalCharsets, boolean equalSeparators, @Nullable Editor editor) {
        if (content instanceof EmptyContent) {
            return null;
        }
        DocumentContent documentContent = (DocumentContent)content;
        Charset charset = equalCharsets ? null : documentContent.getCharset();
        Boolean bom = equalCharsets ? null : documentContent.hasBom();
        LineSeparator separator = equalSeparators ? null : documentContent.getLineSeparator();
        boolean isReadOnly = editor == null || editor.isViewer() || !DiffUtil.canMakeWritable(editor.getDocument());
        return DiffUtil.createTitle(title, separator, charset, bom, isReadOnly);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title) {
        return DiffUtil.createTitle(title, null, null, null, false);
    }

    @NotNull
    public static JComponent createTitle(@NotNull String title, @Nullable LineSeparator separator, @Nullable Charset charset, @Nullable Boolean bom, boolean readOnly) {
        if (readOnly) {
            title = title + " " + DiffBundle.message((String)"diff.content.read.only.content.title.suffix", (Object[])new Object[0]);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.setBorder(IdeBorderFactory.createEmptyBorder((int)0, (int)4, (int)0, (int)4));
        panel2.add((Component)new JBLabel(title).setCopyable(true), "Center");
        if (charset != null && separator != null) {
            JPanel panel22 = new JPanel();
            panel22.setLayout(new BoxLayout(panel22, 0));
            panel22.add(DiffUtil.createCharsetPanel(charset, bom));
            panel22.add(Box.createRigidArea(new Dimension(4, 0)));
            panel22.add(DiffUtil.createSeparatorPanel(separator));
            panel2.add((Component)panel22, "East");
        } else if (charset != null) {
            panel2.add((Component)DiffUtil.createCharsetPanel(charset, bom), "East");
        } else if (separator != null) {
            panel2.add((Component)DiffUtil.createSeparatorPanel(separator), "East");
        }
        return panel2;
    }

    @NotNull
    private static JComponent createCharsetPanel(@NotNull Charset charset, @Nullable Boolean bom) {
        String text = charset.displayName();
        if (bom != null && bom.booleanValue()) {
            text = text + " BOM";
        }
        JLabel label = new JLabel(text);
        if (charset.equals(Charset.forName("UTF-8"))) {
            label.setForeground((Color)JBColor.BLUE);
        } else if (charset.equals(Charset.forName("ISO-8859-1"))) {
            label.setForeground((Color)JBColor.RED);
        } else {
            label.setForeground((Color)JBColor.BLACK);
        }
        return label;
    }

    @NotNull
    private static JComponent createSeparatorPanel(@NotNull LineSeparator separator) {
        JLabel label = new JLabel(separator.name());
        Object color = separator == LineSeparator.CRLF ? JBColor.RED : (separator == LineSeparator.LF ? JBColor.BLUE : (separator == LineSeparator.CR ? JBColor.MAGENTA : JBColor.BLACK));
        label.setForeground((Color)color);
        return label;
    }

    @NotNull
    public static List<JComponent> createSyncHeightComponents(@NotNull List<JComponent> components) {
        if (!ContainerUtil.exists(components, (Condition)Condition.NOT_NULL)) {
            return components;
        }
        ArrayList<JComponent> result2 = new ArrayList<JComponent>();
        for (int i2 = 0; i2 < components.size(); ++i2) {
            result2.add(new SyncHeightComponent(components, i2));
        }
        return result2;
    }

    @NotNull
    public static JComponent createStackedComponents(@NotNull List<JComponent> components, int gap) {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        for (int i2 = 0; i2 < components.size(); ++i2) {
            if (i2 != 0) {
                panel2.add(Box.createVerticalStrut(JBUI.scale((int)gap)));
            }
            panel2.add(components.get(i2));
        }
        return panel2;
    }

    public static boolean isFocusedComponent(@Nullable Component component) {
        return DiffUtil.isFocusedComponent(null, component);
    }

    public static boolean isFocusedComponent(@Nullable Project project2, @Nullable Component component) {
        if (component == null) {
            return false;
        }
        return IdeFocusManager.getInstance((Project)project2).getFocusedDescendantFor(component) != null;
    }

    public static void requestFocus(@Nullable Project project2, @Nullable Component component) {
        if (component == null) {
            return;
        }
        IdeFocusManager.getInstance((Project)project2).requestFocus(component, true);
    }

    @NotNull
    public static TwosideTextDiffProvider createTextDiffProvider(@Nullable Project project2, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffUserDataKeysEx.DiffComputer diffComputer = (DiffUserDataKeysEx.DiffComputer)request.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER);
        if (diffComputer != null) {
            return new SimpleTextDiffProvider(settings, rediff, disposable, diffComputer);
        }
        TwosideTextDiffProvider smartProvider = SmartTextDiffProvider.create(project2, request, settings, rediff, disposable);
        if (smartProvider != null) {
            return smartProvider;
        }
        return new SimpleTextDiffProvider(settings, rediff, disposable);
    }

    @NotNull
    public static TwosideTextDiffProvider.NoIgnore createNoIgnoreTextDiffProvider(@Nullable Project project2, @NotNull ContentDiffRequest request, @NotNull TextDiffSettingsHolder.TextDiffSettings settings, @NotNull Runnable rediff, @NotNull Disposable disposable) {
        DiffUserDataKeysEx.DiffComputer diffComputer = (DiffUserDataKeysEx.DiffComputer)request.getUserData(DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER);
        if (diffComputer != null) {
            return new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable, diffComputer);
        }
        TwosideTextDiffProvider.NoIgnore smartProvider = SmartTextDiffProvider.createNoIgnore(project2, request, settings, rediff, disposable);
        if (smartProvider != null) {
            return smartProvider;
        }
        return new SimpleTextDiffProvider.NoIgnore(settings, rediff, disposable);
    }

    @Nullable
    public static MergeInnerDifferences compareThreesideInner(@NotNull List<CharSequence> chunks, @NotNull ComparisonPolicy comparisonPolicy, @NotNull ProgressIndicator indicator) {
        if (chunks.get(0) == null && chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (comparisonPolicy == ComparisonPolicy.IGNORE_WHITESPACES && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(1), comparisonPolicy) && DiffUtil.isChunksEquals(chunks.get(0), chunks.get(2), comparisonPolicy)) {
            return new MergeInnerDifferences(Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        if (chunks.get(0) == null && chunks.get(1) == null || chunks.get(0) == null && chunks.get(2) == null || chunks.get(1) == null && chunks.get(2) == null) {
            return null;
        }
        if (chunks.get(0) != null && chunks.get(1) != null && chunks.get(2) != null) {
            List<DiffFragment> fragments1 = ByWord.compare(chunks.get(1), chunks.get(0), comparisonPolicy, indicator);
            List<DiffFragment> fragments2 = ByWord.compare(chunks.get(1), chunks.get(2), comparisonPolicy, indicator);
            ArrayList<TextRange> left = new ArrayList<TextRange>();
            ArrayList<TextRange> base = new ArrayList<TextRange>();
            ArrayList<TextRange> right = new ArrayList<TextRange>();
            for (DiffFragment wordFragment : fragments1) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                left.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            for (DiffFragment wordFragment : fragments2) {
                base.add(new TextRange(wordFragment.getStartOffset1(), wordFragment.getEndOffset1()));
                right.add(new TextRange(wordFragment.getStartOffset2(), wordFragment.getEndOffset2()));
            }
            return new MergeInnerDifferences(left, base, right);
        }
        ThreeSide side1 = chunks.get(0) != null ? ThreeSide.LEFT : ThreeSide.BASE;
        ThreeSide side2 = chunks.get(2) != null ? ThreeSide.RIGHT : ThreeSide.BASE;
        CharSequence chunk1 = (CharSequence)side1.select(chunks);
        CharSequence chunk2 = (CharSequence)side2.select(chunks);
        List<DiffFragment> wordConflicts = ByWord.compare(chunk1, chunk2, comparisonPolicy, indicator);
        List textRanges = ThreeSide.map(side -> {
            if (side == side1) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset1(), fragment.getEndOffset1()));
            }
            if (side == side2) {
                return ContainerUtil.map((Collection)wordConflicts, fragment -> new TextRange(fragment.getStartOffset2(), fragment.getEndOffset2()));
            }
            return null;
        });
        return new MergeInnerDifferences((List)textRanges.get(0), (List)textRanges.get(1), (List)textRanges.get(2));
    }

    private static boolean isChunksEquals(@Nullable CharSequence chunk1, @Nullable CharSequence chunk2, @NotNull ComparisonPolicy comparisonPolicy) {
        if (chunk1 == null) {
            chunk1 = "";
        }
        if (chunk2 == null) {
            chunk2 = "";
        }
        return ComparisonManager.getInstance().isEquals(chunk1, chunk2, comparisonPolicy);
    }

    @NotNull
    public static <T> int[] getSortedIndexes(@NotNull List<T> values, @NotNull Comparator<T> comparator2) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(values.size());
        for (int i3 = 0; i3 < values.size(); ++i3) {
            indexes.add(i3);
        }
        ContainerUtil.sort(indexes, (i1, i2) -> {
            Object val1 = values.get((int)i1);
            Object val2 = values.get((int)i2);
            return comparator2.compare(val1, val2);
        });
        return ArrayUtil.toIntArray(indexes);
    }

    @NotNull
    public static int[] invertIndexes(@NotNull int[] indexes) {
        int[] inverted = new int[indexes.length];
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            inverted[indexes[i2]] = i2;
        }
        return inverted;
    }

    @NotNull
    public static BitSet getSelectedLines(@NotNull Editor editor) {
        Document document = editor.getDocument();
        int totalLines = DiffUtil.getLineCount(document);
        BitSet lines = new BitSet(totalLines + 1);
        for (Caret caret : editor.getCaretModel().getAllCarets()) {
            if (caret.hasSelection()) {
                int line1 = editor.offsetToLogicalPosition((int)caret.getSelectionStart()).line;
                int line2 = editor.offsetToLogicalPosition((int)caret.getSelectionEnd()).line;
                lines.set(line1, line2 + 1);
                if (caret.getSelectionEnd() != document.getTextLength()) continue;
                lines.set(totalLines);
                continue;
            }
            lines.set(caret.getLogicalPosition().line);
            if (caret.getOffset() != document.getTextLength()) continue;
            lines.set(totalLines);
        }
        return lines;
    }

    public static boolean isSelectedByLine(int line, int line1, int line2) {
        if (line1 == line2 && line == line1) {
            return true;
        }
        return line >= line1 && line < line2;
    }

    public static boolean isSelectedByLine(@NotNull BitSet selected, int line1, int line2) {
        if (line1 == line2) {
            return selected.get(line1);
        }
        int next = selected.nextSetBit(line1);
        return next != -1 && next < line2;
    }

    private static void deleteLines(@NotNull Document document, int line1, int line2) {
        TextRange range = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = range.getStartOffset();
        int offset2 = range.getEndOffset();
        if (offset1 > 0) {
            --offset1;
        } else if (offset2 < document.getTextLength()) {
            ++offset2;
        }
        document.deleteString(offset1, offset2);
    }

    private static void insertLines(@NotNull Document document, int line, @NotNull CharSequence text) {
        if (line == DiffUtil.getLineCount(document)) {
            document.insertString(document.getTextLength(), (CharSequence)("\n" + text));
        } else {
            document.insertString(document.getLineStartOffset(line), (CharSequence)(text + "\n"));
        }
    }

    private static void replaceLines(@NotNull Document document, int line1, int line2, @NotNull CharSequence text) {
        TextRange currentTextRange = DiffUtil.getLinesRange(document, line1, line2);
        int offset1 = currentTextRange.getStartOffset();
        int offset2 = currentTextRange.getEndOffset();
        document.replaceString(offset1, offset2, text);
    }

    public static void applyModification(@NotNull Document document, int line1, int line2, @NotNull List<? extends CharSequence> newLines) {
        if (line1 == line2 && newLines.isEmpty()) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document, line1, StringUtil.join(newLines, (String)"\n"));
        } else if (newLines.isEmpty()) {
            DiffUtil.deleteLines(document, line1, line2);
        } else {
            DiffUtil.replaceLines(document, line1, line2, StringUtil.join(newLines, (String)"\n"));
        }
    }

    public static void applyModification(@NotNull Document document1, int line1, int line2, @NotNull Document document2, int oLine1, int oLine2) {
        if (line1 == line2 && oLine1 == oLine2) {
            return;
        }
        if (line1 == line2) {
            DiffUtil.insertLines(document1, line1, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        } else if (oLine1 == oLine2) {
            DiffUtil.deleteLines(document1, line1, line2);
        } else {
            DiffUtil.replaceLines(document1, line1, line2, DiffUtil.getLinesContent(document2, oLine1, oLine2));
        }
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull Document document, int line1, int line2) {
        return DiffUtil.getLinesRange(document, line1, line2).subSequence(document.getImmutableCharSequence());
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2) {
        assert (sequence.length() == lineOffsets.getTextLength());
        return DiffUtil.getLinesRange(lineOffsets, line1, line2, false).subSequence(sequence);
    }

    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2) {
        return DiffUtil.getLinesRange(document, line1, line2, false);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull Document document, int line1, int line2, boolean includeNewline) {
        if (line1 == line2) {
            int lineStartOffset = line1 < DiffUtil.getLineCount(document) ? document.getLineStartOffset(line1) : document.getTextLength();
            return new TextRange(lineStartOffset, lineStartOffset);
        }
        int startOffset = document.getLineStartOffset(line1);
        int endOffset = document.getLineEndOffset(line2 - 1);
        if (includeNewline && endOffset < document.getTextLength()) {
            ++endOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (line1 == line2) {
            int lineStartOffset = line1 < lineOffsets.getLineCount() ? lineOffsets.getLineStart(line1) : lineOffsets.getTextLength();
            return new TextRange(lineStartOffset, lineStartOffset);
        }
        int startOffset = lineOffsets.getLineStart(line1);
        int endOffset = lineOffsets.getLineEnd(line2 - 1);
        if (includeNewline && endOffset < lineOffsets.getTextLength()) {
            ++endOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    public static int getOffset(@NotNull Document document, int line, int column) {
        if (line < 0) {
            return 0;
        }
        if (line >= DiffUtil.getLineCount(document)) {
            return document.getTextLength();
        }
        int start = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        return Math.min(start + column, end);
    }

    public static int getLineCount(@NotNull Document document) {
        return Math.max(document.getLineCount(), 1);
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document) {
        return DiffUtil.getLines(document, 0, DiffUtil.getLineCount(document));
    }

    @NotNull
    public static List<String> getLines(@NotNull Document document, int startLine, int endLine) {
        if (startLine < 0 || startLine > endLine || endLine > DiffUtil.getLineCount(document)) {
            throw new IndexOutOfBoundsException(String.format("Wrong line range: [%d, %d); lineCount: '%d'", startLine, endLine, document.getLineCount()));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i2 = startLine; i2 < endLine; ++i2) {
            int start = document.getLineStartOffset(i2);
            int end = document.getLineEndOffset(i2);
            result2.add(document.getText(new TextRange(start, end)));
        }
        return result2;
    }

    public static int bound(int value2, int lowerBound, int upperBound) {
        assert (lowerBound <= upperBound) : String.format("%s - [%s, %s]", value2, lowerBound, upperBound);
        return Math.max(Math.min(value2, upperBound), lowerBound);
    }

    @NotNull
    public static LineRange getAffectedLineRange(@NotNull DocumentEvent e) {
        int line1 = e.getDocument().getLineNumber(e.getOffset());
        int line2 = e.getDocument().getLineNumber(e.getOffset() + e.getOldLength()) + 1;
        return new LineRange(line1, line2);
    }

    public static int countLinesShift(@NotNull DocumentEvent e) {
        return StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift) {
        return DiffUtil.updateRangeOnModification(start, end, changeStart, changeEnd, shift, false);
    }

    @NotNull
    public static UpdatedLineRange updateRangeOnModification(int start, int end, int changeStart, int changeEnd, int shift, boolean greedy) {
        if (end <= changeStart) {
            return new UpdatedLineRange(start, end, false);
        }
        if (start >= changeEnd) {
            return new UpdatedLineRange(start + shift, end + shift, false);
        }
        if (start <= changeStart && end >= changeEnd) {
            return new UpdatedLineRange(start, end + shift, false);
        }
        int newChangeEnd = changeEnd + shift;
        if (start >= changeStart && end <= changeEnd) {
            return greedy ? new UpdatedLineRange(changeStart, newChangeEnd, true) : new UpdatedLineRange(newChangeEnd, newChangeEnd, true);
        }
        if (start < changeStart) {
            return greedy ? new UpdatedLineRange(start, newChangeEnd, true) : new UpdatedLineRange(start, changeStart, true);
        }
        return greedy ? new UpdatedLineRange(changeStart, end + shift, true) : new UpdatedLineRange(newChangeEnd, end + shift, true);
    }

    @NotNull
    public static TextDiffType getLineDiffType(@NotNull LineFragment fragment) {
        boolean left = fragment.getStartLine1() != fragment.getEndLine1();
        boolean right = fragment.getStartLine2() != fragment.getEndLine2();
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(@NotNull DiffFragment fragment) {
        boolean left = fragment.getEndOffset1() != fragment.getStartOffset1();
        boolean right = fragment.getEndOffset2() != fragment.getStartOffset2();
        return DiffUtil.getDiffType(left, right);
    }

    @NotNull
    public static TextDiffType getDiffType(boolean hasDeleted, boolean hasInserted) {
        if (hasDeleted && hasInserted) {
            return TextDiffType.MODIFIED;
        }
        if (hasDeleted) {
            return TextDiffType.DELETED;
        }
        if (hasInserted) {
            return TextDiffType.INSERTED;
        }
        LOG.error("Diff fragment should not be empty");
        return TextDiffType.MODIFIED;
    }

    @NotNull
    public static MergeConflictType getMergeType(@NotNull Condition<ThreeSide> emptiness, @NotNull Equality<ThreeSide> equality) {
        boolean isLeftEmpty = emptiness.value((Object)ThreeSide.LEFT);
        boolean isBaseEmpty = emptiness.value((Object)ThreeSide.BASE);
        boolean isRightEmpty = emptiness.value((Object)ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                return new MergeConflictType(TextDiffType.INSERTED, false, true);
            }
            if (isRightEmpty) {
                return new MergeConflictType(TextDiffType.INSERTED, true, false);
            }
            boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
            return new MergeConflictType(equalModifications ? TextDiffType.INSERTED : TextDiffType.CONFLICT);
        }
        if (isLeftEmpty && isRightEmpty) {
            return new MergeConflictType(TextDiffType.DELETED);
        }
        boolean unchangedLeft = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.LEFT);
        boolean unchangedRight = equality.equals((Object)ThreeSide.BASE, (Object)ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            return new MergeConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
        }
        if (unchangedRight) {
            return new MergeConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
        }
        boolean equalModifications = equality.equals((Object)ThreeSide.LEFT, (Object)ThreeSide.RIGHT);
        return new MergeConflictType(equalModifications ? TextDiffType.MODIFIED : TextDiffType.CONFLICT);
    }

    @NotNull
    public static MergeConflictType getLineMergeType(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy) {
        return DiffUtil.getMergeType((Condition<ThreeSide>)((Condition)side -> DiffUtil.isLineMergeIntervalEmpty(fragment, side)), (Equality<ThreeSide>)((Equality)(side1, side2) -> DiffUtil.compareLineMergeContents(fragment, sequences, lineOffsets, policy, side1, side2)));
    }

    private static boolean compareLineMergeContents(@NotNull MergeLineFragment fragment, @NotNull List<? extends CharSequence> sequences, @NotNull List<LineOffsets> lineOffsets, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        int start1 = fragment.getStartLine(side1);
        int end1 = fragment.getEndLine(side1);
        int start2 = fragment.getStartLine(side2);
        int end2 = fragment.getEndLine(side2);
        if (end2 - start2 != end1 - start1) {
            return false;
        }
        CharSequence sequence1 = (CharSequence)side1.select(sequences);
        CharSequence sequence2 = (CharSequence)side2.select(sequences);
        LineOffsets offsets1 = (LineOffsets)side1.select(lineOffsets);
        LineOffsets offsets2 = (LineOffsets)side2.select(lineOffsets);
        for (int i2 = 0; i2 < end1 - start1; ++i2) {
            int line1 = start1 + i2;
            int line2 = start2 + i2;
            CharSequence content1 = DiffUtil.getLinesContent(sequence1, offsets1, line1, line1 + 1);
            CharSequence content2 = DiffUtil.getLinesContent(sequence2, offsets2, line2, line2 + 1);
            if (ComparisonManager.getInstance().isEquals(content1, content2, policy)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLineMergeIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    @NotNull
    public static MergeConflictType getWordMergeType(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy) {
        return DiffUtil.getMergeType((Condition<ThreeSide>)((Condition)side -> DiffUtil.isWordMergeIntervalEmpty(fragment, side)), (Equality<ThreeSide>)((Equality)(side1, side2) -> DiffUtil.compareWordMergeContents(fragment, texts, policy, side1, side2)));
    }

    private static boolean compareWordMergeContents(@NotNull MergeWordFragment fragment, @NotNull List<? extends CharSequence> texts, @NotNull ComparisonPolicy policy, @NotNull ThreeSide side1, @NotNull ThreeSide side2) {
        int start1 = fragment.getStartOffset(side1);
        int end1 = fragment.getEndOffset(side1);
        int start2 = fragment.getStartOffset(side2);
        int end2 = fragment.getEndOffset(side2);
        CharSequence document1 = (CharSequence)side1.select(texts);
        CharSequence document2 = (CharSequence)side2.select(texts);
        CharSequence content1 = document1.subSequence(start1, end1);
        CharSequence content2 = document2.subSequence(start2, end2);
        return ComparisonUtil.isEquals(content1, content2, policy);
    }

    private static boolean isWordMergeIntervalEmpty(@NotNull MergeWordFragment fragment, @NotNull ThreeSide side) {
        return fragment.getStartOffset(side) == fragment.getEndOffset(side);
    }

    public static boolean executeWriteCommand(@Nullable Project project2, @NotNull Document document, @Nullable String commandName, @Nullable String commandGroupId, @NotNull UndoConfirmationPolicy confirmationPolicy, boolean underBulkUpdate, @NotNull Runnable task) {
        if (!DiffUtil.makeWritable(project2, document)) {
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            LOG.warn("Document is read-only" + (file2 != null ? ": " + file2.getPresentableName() : ""));
            return false;
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (underBulkUpdate) {
                DocumentUtil.executeInBulk(document, true, task);
            } else {
                task.run();
            }
        }, commandName, (Object)commandGroupId, confirmationPolicy, document));
        return true;
    }

    public static boolean executeWriteCommand(@NotNull Document document, @Nullable Project project2, @Nullable String commandName, @NotNull Runnable task) {
        return DiffUtil.executeWriteCommand(project2, document, commandName, null, UndoConfirmationPolicy.DEFAULT, false, task);
    }

    public static boolean isEditable(@NotNull Editor editor) {
        return !editor.isViewer() && DiffUtil.canMakeWritable(editor.getDocument());
    }

    public static boolean canMakeWritable(@NotNull Document document) {
        if (document.isWritable()) {
            return true;
        }
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null && file2.isValid() && file2.isInLocalFileSystem()) {
            return !file2.isWritable();
        }
        return false;
    }

    public static boolean makeWritable(@Nullable Project project2, @NotNull Document document) {
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 == null || !file2.isValid()) {
            return document.isWritable();
        }
        return DiffUtil.makeWritable(project2, file2) && document.isWritable();
    }

    public static boolean makeWritable(@Nullable Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        return !ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(new VirtualFile[]{file2}).hasReadonlyFiles();
    }

    public static void putNonundoableOperation(@Nullable Project project2, @NotNull Document document) {
        UndoManager undoManager;
        UndoManager undoManager2 = undoManager = project2 != null ? UndoManager.getInstance((Project)project2) : UndoManager.getGlobalInstance();
        if (undoManager != null) {
            DocumentReference ref = DocumentReferenceManager.getInstance().create(document);
            undoManager.nonundoableActionPerformed(ref, false);
        }
    }

    public static void markDirtyAndRefresh(boolean async, boolean recursive, boolean reloadChildren, VirtualFile ... files) {
        ModalityState modalityState = ApplicationManager.getApplication().getDefaultModalityState();
        VfsUtil.markDirty((boolean)recursive, (boolean)reloadChildren, (VirtualFile[])files);
        RefreshQueue.getInstance().refresh(async, recursive, null, modalityState, files);
    }

    @NotNull
    public static Dimension getDefaultDiffPanelSize() {
        return new Dimension(400, 200);
    }

    @NotNull
    public static Dimension getDefaultDiffWindowSize() {
        Rectangle screenBounds = ScreenUtil.getMainScreenBounds();
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        return new Dimension(width, height);
    }

    @NotNull
    public static WindowWrapper.Mode getWindowMode(@NotNull DiffDialogHints hints) {
        WindowWrapper.Mode mode = hints.getMode();
        if (mode == null) {
            boolean isUnderDialog = LaterInvocator.isInModalContext();
            mode = isUnderDialog ? WindowWrapper.Mode.MODAL : WindowWrapper.Mode.FRAME;
        }
        return mode;
    }

    public static void closeWindow(@Nullable Window window, boolean modalOnly, boolean recursive) {
        boolean isClosed;
        if (window == null) {
            return;
        }
        Container component = window;
        while (component != null && (!(component instanceof Window) || (isClosed = DiffUtil.closeWindow(component, modalOnly)))) {
            component = recursive ? component.getParent() : null;
        }
    }

    private static boolean closeWindow(@NotNull Window window, boolean modalOnly) {
        if (window instanceof IdeFrameImpl) {
            return false;
        }
        if (modalOnly && window instanceof Frame) {
            return false;
        }
        if (window instanceof DialogWrapperDialog) {
            ((DialogWrapperDialog)window).getDialogWrapper().doCancelAction();
            return !window.isVisible();
        }
        window.setVisible(false);
        window.dispose();
        return true;
    }

    public static <T> UserDataHolderBase createUserDataHolder(@NotNull Key<T> key2, @Nullable T value2) {
        UserDataHolderBase holder = new UserDataHolderBase();
        holder.putUserData(key2, value2);
        return holder;
    }

    public static boolean isUserDataFlagSet(@NotNull Key<Boolean> key2, UserDataHolder ... holders) {
        for (UserDataHolder holder : holders) {
            Boolean data;
            if (holder == null || (data = (Boolean)holder.getUserData(key2)) == null) continue;
            return data;
        }
        return false;
    }

    public static <T> T getUserData(@Nullable UserDataHolder first, @Nullable UserDataHolder second, @NotNull Key<T> key2) {
        Object data;
        if (first != null && (data = first.getUserData(key2)) != null) {
            return (T)data;
        }
        if (second != null && (data = second.getUserData(key2)) != null) {
            return (T)data;
        }
        return null;
    }

    public static void addNotification(@Nullable JComponent component, @NotNull UserDataHolder holder) {
        if (component == null) {
            return;
        }
        List oldComponents = ContainerUtil.notNullize((List)((List)holder.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
        holder.putUserData(DiffUserDataKeys.NOTIFICATIONS, (Object)ContainerUtil.append((List)oldComponents, (Object[])new JComponent[]{component}));
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull DiffContext context, @NotNull DiffRequest request) {
        List requestComponents = (List)request.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        List contextComponents = (List)context.getUserData(DiffUserDataKeys.NOTIFICATIONS);
        return ContainerUtil.concat((List)ContainerUtil.notNullize((List)contextComponents), (List)ContainerUtil.notNullize((List)requestComponents));
    }

    @NotNull
    public static List<JComponent> getCustomNotifications(@NotNull DiffContent content) {
        return ContainerUtil.notNullize((List)((List)content.getUserData(DiffUserDataKeys.NOTIFICATIONS)));
    }

    @Nullable
    public static Object getData(@Nullable DataProvider provider2, @Nullable DataProvider fallbackProvider, @NonNls String dataId) {
        Object data;
        if (provider2 != null && (data = provider2.getData(dataId)) != null) {
            return data;
        }
        if (fallbackProvider != null && (data = fallbackProvider.getData(dataId)) != null) {
            return data;
        }
        return null;
    }

    public static <T> void putDataKey(@NotNull UserDataHolder holder, @NotNull DataKey<T> key2, @Nullable T value2) {
        DataProvider dataProvider = (DataProvider)holder.getUserData(DiffUserDataKeys.DATA_PROVIDER);
        if (!(dataProvider instanceof GenericDataProvider)) {
            dataProvider = new GenericDataProvider(dataProvider);
            holder.putUserData(DiffUserDataKeys.DATA_PROVIDER, (Object)dataProvider);
        }
        ((GenericDataProvider)dataProvider).putData(key2, value2);
    }

    @NotNull
    public static DiffSettingsHolder.DiffSettings getDiffSettings(@NotNull DiffContext context) {
        DiffSettingsHolder.DiffSettings settings = (DiffSettingsHolder.DiffSettings)context.getUserData(DiffSettingsHolder.DiffSettings.KEY);
        if (settings == null) {
            settings = DiffSettingsHolder.DiffSettings.getSettings((String)context.getUserData(DiffUserDataKeys.PLACE));
            context.putUserData(DiffSettingsHolder.DiffSettings.KEY, (Object)settings);
        }
        return settings;
    }

    @NotNull
    public static <K, V> TreeMap<K, V> trimDefaultValues(@NotNull TreeMap<K, V> map2, @NotNull Convertor<K, V> defaultValue) {
        TreeMap<K, V> result2 = new TreeMap<K, V>();
        for (Map.Entry<K, V> it : map2.entrySet()) {
            K key2 = it.getKey();
            V value2 = it.getValue();
            if (value2.equals(defaultValue.convert(key2))) continue;
            result2.put(key2, value2);
        }
        return result2;
    }

    @NotNull
    public static <T extends DiffTool> List<T> filterSuppressedTools(@NotNull List<T> tools) {
        if (tools.size() < 2) {
            return tools;
        }
        ArrayList suppressedTools = new ArrayList();
        for (DiffTool tool2 : tools) {
            try {
                if (!(tool2 instanceof SuppressiveDiffTool)) continue;
                suppressedTools.addAll(((SuppressiveDiffTool)tool2).getSuppressedTools());
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
        if (suppressedTools.isEmpty()) {
            return tools;
        }
        List filteredTools = ContainerUtil.filter(tools, tool -> !suppressedTools.contains(tool.getClass()));
        return filteredTools.isEmpty() ? tools : filteredTools;
    }

    public static class CenteredPanel
    extends JPanel {
        private final JComponent myComponent;

        public CenteredPanel(@NotNull JComponent component) {
            this.myComponent = component;
            this.add(component);
        }

        public CenteredPanel(@NotNull JComponent component, @NotNull Border border) {
            this(component);
            this.setBorder(border);
        }

        @Override
        public void doLayout() {
            Dimension size = this.getSize();
            Dimension preferredSize = this.myComponent.getPreferredSize();
            Insets insets = this.getInsets();
            JBInsets.removeFrom((Dimension)size, (Insets)insets);
            int width = Math.min(size.width, preferredSize.width);
            int height = Math.min(size.height, preferredSize.height);
            int x = Math.max(0, (size.width - preferredSize.width) / 2);
            int y = Math.max(0, (size.height - preferredSize.height) / 2);
            this.myComponent.setBounds(insets.left + x, insets.top + y, width, height);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.addInsets(this.myComponent.getPreferredSize());
        }

        @Override
        public Dimension getMinimumSize() {
            return this.addInsets(this.myComponent.getMinimumSize());
        }

        @Override
        public Dimension getMaximumSize() {
            return this.addInsets(this.myComponent.getMaximumSize());
        }

        private Dimension addInsets(Dimension dimension) {
            JBInsets.addTo((Dimension)dimension, (Insets)this.getInsets());
            return dimension;
        }
    }

    private static class SyncHeightComponent
    extends JPanel {
        @NotNull
        private final List<JComponent> myComponents;

        public SyncHeightComponent(@NotNull List<JComponent> components, int index) {
            super(new BorderLayout());
            this.myComponents = components;
            JComponent delegate = components.get(index);
            if (delegate != null) {
                this.add((Component)delegate, "Center");
            }
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            size.height = this.getPreferredHeight();
            return size;
        }

        private int getPreferredHeight() {
            int height = 0;
            for (JComponent component : this.myComponents) {
                if (component == null) continue;
                height = Math.max(height, component.getPreferredSize().height);
            }
            return height;
        }
    }

    public static class UpdatedLineRange {
        public final int startLine;
        public final int endLine;
        public final boolean damaged;

        public UpdatedLineRange(int startLine, int endLine, boolean damaged) {
            this.startLine = startLine;
            this.endLine = endLine;
            this.damaged = damaged;
        }
    }
}

