/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import org.jetbrains.annotations.NotNull;

public class MergeConflictType {
    @NotNull
    private final TextDiffType myType;
    private final boolean myLeftChange;
    private final boolean myRightChange;

    public MergeConflictType(@NotNull TextDiffType type2) {
        this(type2, true, true);
    }

    public MergeConflictType(@NotNull TextDiffType type2, boolean leftChange, boolean rightChange) {
        this.myType = type2;
        this.myLeftChange = leftChange;
        this.myRightChange = rightChange;
    }

    @NotNull
    public TextDiffType getDiffType() {
        return this.myType;
    }

    public boolean isChange(@NotNull Side side) {
        return side.isLeft() ? this.myLeftChange : this.myRightChange;
    }

    public boolean isChange(@NotNull ThreeSide side) {
        switch (side) {
            case LEFT: {
                return this.myLeftChange;
            }
            case BASE: {
                return true;
            }
            case RIGHT: {
                return this.myRightChange;
            }
        }
        throw new IllegalArgumentException(side.toString());
    }
}

