/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.util.indexing.FileContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DuplicatesProfile {
    public static final ExtensionPointName<DuplicatesProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.duplicates.profile");
    private static final int FACTOR = 2;
    private static final int MAX_COST = 7000;

    @NotNull
    public abstract DuplocateVisitor createVisitor(@NotNull FragmentsCollector var1);

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        return this.createVisitor(collector);
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public abstract DuplocatorState getDuplocatorState(@NotNull Language var1);

    @Nullable
    public String getComment(@NotNull DupInfo info, int index) {
        return null;
    }

    public abstract boolean isMyDuplicate(@NotNull DupInfo var1, int var2);

    public boolean supportIndex() {
        return true;
    }

    public boolean supportDuplicatesIndex() {
        return false;
    }

    public boolean acceptsContentForIndexing(FileContent fileContent) {
        return true;
    }

    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        int lowerBound = state.getLowerBound();
        return cost >= 2 * lowerBound && cost <= 7000;
    }

    @Nullable
    public static DuplicatesProfile findProfileForLanguage(@NotNull Language language) {
        return DuplicatesProfile.findProfileForLanguage((DuplicatesProfile[])EP_NAME.getExtensions(), language);
    }

    @NotNull
    public static DuplicatesProfile[] getAllProfiles() {
        return (DuplicatesProfile[])Extensions.getExtensions(EP_NAME);
    }

    @Nullable
    public static DuplicatesProfile findProfileForLanguage(DuplicatesProfile[] profiles, @NotNull Language language) {
        for (DuplicatesProfile profile2 : profiles) {
            if (!profile2.isMyLanguage(language)) continue;
            return profile2;
        }
        return null;
    }

    @NotNull
    public Language getLanguage(@NotNull PsiElement element) {
        return element.getLanguage();
    }

    @Nullable
    public PsiElementRole getRole(@NotNull PsiElement element) {
        return null;
    }
}

