/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.index;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.index.TracingData;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplicatesIndex
extends FileBasedIndexExtension<Integer, TIntArrayList>
implements PsiDependentIndex {
    static boolean ourEnabled = SystemProperties.getBooleanProperty((String)"idea.enable.duplicates.online.calculation", (boolean)true);
    static final boolean ourEnabledLightProfiles = true;
    private static boolean ourEnabledOldProfiles = false;
    @NonNls
    public static final ID<Integer, TIntArrayList> NAME = ID.create((String)"DuplicatesIndex");
    private static final int myBaseVersion = 25;
    private final FileBasedIndex.InputFilter myInputFilter = new FileBasedIndex.InputFilter(){

        public boolean acceptInput(@NotNull VirtualFile file2) {
            if (!ourEnabled || !file2.isInLocalFileSystem()) {
                return false;
            }
            DuplicatesProfile duplicatesProfile = DuplicatesIndex.findDuplicatesProfile(file2.getFileType());
            if (duplicatesProfile instanceof LightDuplicateProfile) {
                return ((LightDuplicateProfile)((Object)duplicatesProfile)).acceptsFile(file2);
            }
            return duplicatesProfile != null;
        }
    };
    private final DataExternalizer<TIntArrayList> myValueExternalizer = new DataExternalizer<TIntArrayList>(){

        public void save(@NotNull DataOutput out, TIntArrayList list) throws IOException {
            if (list.size() == 2) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getQuick(0));
                DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getQuick(1));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-list.size()));
                int prev = 0;
                int len = list.size();
                for (int i2 = 0; i2 < len; i2 += 2) {
                    int value2 = list.getQuick(i2);
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)(value2 - prev));
                    prev = value2;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)list.getQuick(i2 + 1));
                }
            }
        }

        public TIntArrayList read(@NotNull DataInput in) throws IOException {
            int capacityOrValue = DataInputOutputUtil.readINT((DataInput)in);
            if (capacityOrValue >= 0) {
                TIntArrayList list = new TIntArrayList(2);
                list.add(capacityOrValue);
                list.add(DataInputOutputUtil.readINT((DataInput)in));
                return list;
            }
            TIntArrayList list = new TIntArrayList(capacityOrValue);
            int prev = 0;
            for (capacityOrValue = -capacityOrValue; capacityOrValue > 0; capacityOrValue -= 2) {
                int value2 = DataInputOutputUtil.readINT((DataInput)in) + prev;
                list.add(value2);
                prev = value2;
                list.add(DataInputOutputUtil.readINT((DataInput)in));
            }
            return list;
        }
    };
    private final DataIndexer<Integer, TIntArrayList, FileContent> myIndexer = new DataIndexer<Integer, TIntArrayList, FileContent>(){

        @NotNull
        public Map<Integer, TIntArrayList> map(@NotNull FileContent inputData) {
            FileType type2 = inputData.getFileType();
            DuplicatesProfile profile2 = DuplicatesIndex.findDuplicatesProfile(type2);
            if (profile2 == null || !profile2.acceptsContentForIndexing(inputData)) {
                return Collections.emptyMap();
            }
            try {
                FileContentImpl fileContent = (FileContentImpl)inputData;
                if (profile2 instanceof LightDuplicateProfile) {
                    final THashMap result2 = new THashMap();
                    LighterAST ast = fileContent.getLighterASTForPsiDependentIndex();
                    ((LightDuplicateProfile)((Object)profile2)).process(ast, new LightDuplicateProfile.Callback(){

                        @Override
                        public void process(int hash, int hash2, @NotNull LighterAST ast, LighterASTNode ... nodes) {
                            TIntArrayList list = (TIntArrayList)result2.get((Object)hash);
                            if (list == null) {
                                list = new TIntArrayList(2);
                                result2.put((Object)hash, (Object)list);
                            }
                            list.add(nodes[0].getStartOffset());
                            list.add(hash2);
                        }
                    });
                    return result2;
                }
                MyFragmentsCollector collector = new MyFragmentsCollector(profile2, ((LanguageFileType)type2).getLanguage());
                DuplocateVisitor visitor = profile2.createVisitor(collector, true);
                visitor.visitNode((PsiElement)fileContent.getPsiFileForPsiDependentIndex());
                return collector.getMap();
            }
            catch (StackOverflowError ae) {
                return Collections.emptyMap();
            }
        }
    };
    private static final TracingData myTracingData = null;

    @Nullable
    public static DuplicatesProfile findDuplicatesProfile(FileType fileType) {
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        Language language = ((LanguageFileType)fileType).getLanguage();
        DuplicatesProfile profile2 = DuplicatesProfile.findProfileForLanguage(language);
        return profile2 != null && (ourEnabledOldProfiles && profile2.supportDuplicatesIndex() || profile2 instanceof LightDuplicateProfile) ? profile2 : null;
    }

    public int getVersion() {
        return 25 + (ourEnabled ? 255 : 0) + 128 + (ourEnabledOldProfiles ? 33 : 0);
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public ID<Integer, TIntArrayList> getName() {
        return NAME;
    }

    @NotNull
    public DataIndexer<Integer, TIntArrayList, FileContent> getIndexer() {
        return this.myIndexer;
    }

    @NotNull
    public DataExternalizer<TIntArrayList> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        return EnumeratorIntegerDescriptor.INSTANCE;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return this.myInputFilter;
    }

    static boolean isIndexedFragment(@Nullable PsiFragment frag, int cost, DuplicatesProfile profile2, DuplocatorState duplocatorState) {
        if (frag == null) {
            return false;
        }
        return profile2.shouldPutInIndex(frag, cost, duplocatorState);
    }

    public static boolean setEnabled(boolean value2) {
        boolean old = ourEnabled;
        ourEnabled = value2;
        return old;
    }

    public static boolean setEnabledOldProfiles(boolean value2) {
        boolean old = ourEnabledOldProfiles;
        ourEnabledOldProfiles = value2;
        return old;
    }

    public boolean hasSnapshotMapping() {
        return true;
    }

    private static class MyFragmentsCollector
    implements FragmentsCollector {
        private final THashMap<Integer, TIntArrayList> myMap = new THashMap();
        private final DuplicatesProfile myProfile;
        private final DuplocatorState myDuplocatorState;

        public MyFragmentsCollector(DuplicatesProfile profile2, Language language) {
            this.myProfile = profile2;
            this.myDuplocatorState = profile2.getDuplocatorState(language);
        }

        @Override
        public void add(int hash, int cost, @Nullable PsiFragment frag) {
            TIntArrayList list;
            if (!DuplicatesIndex.isIndexedFragment(frag, cost, this.myProfile, this.myDuplocatorState)) {
                return;
            }
            if (myTracingData != null) {
                myTracingData.record(hash, cost, frag);
            }
            if ((list = (TIntArrayList)this.myMap.get((Object)hash)) == null) {
                list = new TIntArrayList();
                this.myMap.put((Object)hash, (Object)list);
            }
            list.add(frag.getStartOffset());
            list.add(0);
        }

        public THashMap<Integer, TIntArrayList> getMap() {
            return this.myMap;
        }
    }
}

