/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.repo.Repository;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsMultiRootBranchConfig<Repo extends Repository> {
    @NotNull
    protected final Collection<Repo> myRepositories;

    public DvcsMultiRootBranchConfig(@NotNull Collection<Repo> repositories) {
        this.myRepositories = repositories;
    }

    public boolean diverged() {
        return this.getCurrentBranch() == null;
    }

    @Nullable
    public String getCurrentBranch() {
        String commonBranch = null;
        for (Repository repository : this.myRepositories) {
            String branchName = repository.getCurrentBranchName();
            if (branchName == null) {
                return null;
            }
            if (commonBranch == null) {
                commonBranch = branchName;
                continue;
            }
            if (commonBranch.equals(branchName)) continue;
            return null;
        }
        return commonBranch;
    }

    @Nullable
    public Repository.State getState() {
        Repository.State commonState = null;
        for (Repository repository : this.myRepositories) {
            Repository.State state = repository.getState();
            if (commonState == null) {
                commonState = state;
                continue;
            }
            if (commonState.equals((Object)state)) continue;
            return null;
        }
        return commonState;
    }

    @NotNull
    public abstract Collection<String> getLocalBranchNames();
}

