/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.intellij.dvcs.cherrypick.VcsCherryPickManager;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.impl.VcsLogUtil;
import icons.DvcsImplIcons;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCherryPickAction
extends DumbAwareAction {
    private static final String NAME = "Cherry-Pick";
    private static final String SEVERAL_VCS_DESCRIPTION = "Selected commits are tracked by different vcses";

    public VcsCherryPickAction() {
        super(NAME, null, DvcsImplIcons.CherryPick);
    }

    public void actionPerformed(AnActionEvent e) {
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        VcsCherryPickManager.getInstance(project2).cherryPick(log);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().setVisible(true);
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        Project project2 = e.getProject();
        if (project2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsCherryPickManager cherryPickManager = VcsCherryPickManager.getInstance(project2);
        List<VcsCherryPicker> cherryPickers = VcsCherryPickAction.getActiveCherryPickersForProject(project2);
        if (log == null || cherryPickers.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        List<CommitId> commits = VcsLogUtil.collectFirstPack(log.getSelectedCommits(), 1000);
        if (commits.isEmpty() || cherryPickManager.isCherryPickAlreadyStartedFor(commits)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Map<VirtualFile, List<Hash>> groupedByRoot = VcsCherryPickAction.groupByRoot(commits);
        VcsCherryPicker activeCherryPicker = VcsCherryPickAction.getActiveCherryPicker(cherryPickers, groupedByRoot.keySet());
        String description = activeCherryPicker != null ? activeCherryPicker.getInfo(log, groupedByRoot) : SEVERAL_VCS_DESCRIPTION;
        e.getPresentation().setEnabled(description == null);
        e.getPresentation().setText(activeCherryPicker == null ? VcsCherryPickAction.concatActionNamesForAllAvailable(cherryPickers) : activeCherryPicker.getActionTitle());
        e.getPresentation().setDescription(description == null ? "" : description);
    }

    @Nullable
    private static VcsCherryPicker getActiveCherryPicker(@NotNull List<VcsCherryPicker> cherryPickers, @NotNull Collection<VirtualFile> roots) {
        return (VcsCherryPicker)ContainerUtil.find(cherryPickers, picker -> picker.canHandleForRoots(roots));
    }

    @NotNull
    private static Map<VirtualFile, List<Hash>> groupByRoot(@NotNull List<CommitId> details) {
        HashMap result2 = ContainerUtil.newHashMap();
        for (CommitId commit : details) {
            List hashes = (List)result2.get(commit.getRoot());
            if (hashes == null) {
                hashes = ContainerUtil.newArrayList();
                result2.put(commit.getRoot(), hashes);
            }
            hashes.add(commit.getHash());
        }
        return result2;
    }

    @NotNull
    private static String concatActionNamesForAllAvailable(@NotNull List<VcsCherryPicker> pickers) {
        return StringUtil.join(pickers, VcsCherryPicker::getActionTitle, (String)"/");
    }

    @NotNull
    private static List<VcsCherryPicker> getActiveCherryPickersForProject(@Nullable Project project2) {
        if (project2 != null) {
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
            Object[] vcss = projectLevelVcsManager.getAllActiveVcss();
            return ContainerUtil.mapNotNull((Object[])vcss, vcs -> vcs != null ? VcsCherryPickManager.getInstance(project2).getCherryPickerFor(vcs.getKeyInstanceMethod()) : null);
        }
        return ContainerUtil.emptyList();
    }
}

