/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRepositoryManager<T extends Repository>
implements RepositoryManager<T> {
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final String myRepoDirName;
    @NotNull
    private final VcsRepositoryManager myGlobalRepositoryManager;

    protected AbstractRepositoryManager(@NotNull VcsRepositoryManager globalRepositoryManager, @NotNull AbstractVcs vcs, @NotNull String repoDirName) {
        this.myGlobalRepositoryManager = globalRepositoryManager;
        this.myVcs = vcs;
        this.myRepoDirName = repoDirName;
    }

    @Nullable
    public T getRepositoryForRoot(@Nullable VirtualFile root) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRoot(root));
    }

    @Nullable
    public T getRepositoryForRootQuick(@Nullable VirtualFile root) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForRootQuick(root));
    }

    public void addExternalRepository(@NotNull VirtualFile root, @NotNull T repository) {
        this.myGlobalRepositoryManager.addExternalRepository(root, (Repository)repository);
    }

    public void removeExternalRepository(@NotNull VirtualFile root) {
        this.myGlobalRepositoryManager.removeExternalRepository(root);
    }

    public boolean isExternal(@NotNull T repository) {
        return this.myGlobalRepositoryManager.isExternal((Repository)repository);
    }

    @Nullable
    public T getRepositoryForFile(@NotNull VirtualFile file2) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFile(file2));
    }

    @Deprecated
    @Nullable
    public T getRepositoryForFileQuick(@NotNull VirtualFile file2) {
        return this.validateAndGetRepository(this.myGlobalRepositoryManager.getRepositoryForFileQuick(file2));
    }

    @Nullable
    public T getRepositoryForFile(@NotNull FilePath file2) {
        VirtualFile vFile = ChangesUtil.findValidParentAccurately((FilePath)file2);
        return vFile != null ? (T)this.getRepositoryForFile(vFile) : null;
    }

    @NotNull
    protected List<T> getRepositories(Class<T> type2) {
        return ContainerUtil.findAll(this.myGlobalRepositoryManager.getRepositories(), type2);
    }

    @NotNull
    public abstract List<T> getRepositories();

    public boolean moreThanOneRoot() {
        return this.getRepositories().size() > 1;
    }

    public void updateRepository(@Nullable VirtualFile root) {
        T repo = this.getRepositoryForRoot(root);
        if (repo != null) {
            repo.update();
        }
    }

    public void updateAllRepositories() {
        ContainerUtil.process(this.getRepositories(), (Processor)new Processor<T>(){

            public boolean process(T repo) {
                repo.update();
                return true;
            }
        });
    }

    @Nullable
    private T validateAndGetRepository(@Nullable Repository repository) {
        if (repository == null || !this.myVcs.equals((Object)repository.getVcs())) {
            return null;
        }
        VirtualFile vcsDir = repository.getRoot().findChild(this.myRepoDirName);
        return (T)(vcsDir != null && vcsDir.exists() ? repository : null);
    }

    @NotNull
    public AbstractVcs getVcs() {
        return this.myVcs;
    }
}

