/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.repo;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RepositoryImpl
implements Repository {
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myRootDir;
    @NotNull
    protected volatile Repository.State myState;
    @Nullable
    protected volatile String myCurrentRevision;

    protected RepositoryImpl(@NotNull Project project2, @NotNull VirtualFile dir, @NotNull Disposable parentDisposable) {
        this.myProject = project2;
        this.myRootDir = dir;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRootDir;
    }

    @NotNull
    public String getPresentableUrl() {
        return this.getRoot().getPresentableUrl();
    }

    public String toString() {
        return this.getPresentableUrl();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public Repository.State getState() {
        return this.myState;
    }

    @Nullable
    public String getCurrentRevision() {
        return this.myCurrentRevision;
    }

    public void dispose() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Repository that = (Repository)o;
        if (!this.getProject().equals(that.getProject())) {
            return false;
        }
        return this.getRoot().equals(that.getRoot());
    }

    public int hashCode() {
        int result2 = this.getProject().hashCode();
        result2 = 31 * result2 + this.getRoot().hashCode();
        return result2;
    }
}

