/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RootAction<T extends Repository>
extends ActionGroup
implements PopupElementWithAdditionalInfo {
    @NotNull
    protected final T myRepository;
    @NotNull
    private final ActionGroup myGroup;
    @NotNull
    private final String myBranchText;

    public RootAction(@NotNull T repository, @Nullable T currentRepository, @NotNull ActionGroup actionsGroup, @NotNull String branchText) {
        super("", true);
        this.myRepository = repository;
        this.myGroup = actionsGroup;
        this.myBranchText = branchText;
        if (repository.equals(currentRepository)) {
            this.getTemplatePresentation().setIcon(PlatformIcons.CHECK_ICON);
        }
        this.getTemplatePresentation().setText(DvcsUtil.getShortRepositoryName(repository), false);
    }

    @NotNull
    public String getCaption() {
        return "Current branch in " + DvcsUtil.getShortRepositoryName(this.myRepository) + ": " + this.getInfoText();
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        return this.myGroup.getChildren(e);
    }

    @Override
    @NotNull
    public String getInfoText() {
        return this.myBranchText;
    }
}

