/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.AppTopics;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayedDocumentWatcher
implements AutoTestWatcher {
    private final Project myProject;
    private final Alarm myAlarm;
    private final int myDelayMillis;
    private final Consumer<Integer> myModificationStampConsumer;
    private final Condition<VirtualFile> myChangedFileFilter;
    private final MyDocumentAdapter myListener;
    private final Runnable myAlarmRunnable;
    private final Set<VirtualFile> myChangedFiles = new THashSet();
    private boolean myDocumentSavingInProgress = false;
    private MessageBusConnection myConnection;
    private int myModificationStamp = 0;
    private Disposable myListenerDisposable;

    public DelayedDocumentWatcher(@NotNull Project project2, int delayMillis, @NotNull Consumer<Integer> modificationStampConsumer, @Nullable Condition<VirtualFile> changedFileFilter) {
        this.myProject = project2;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project2);
        this.myDelayMillis = delayMillis;
        this.myModificationStampConsumer = modificationStampConsumer;
        this.myChangedFileFilter = changedFileFilter;
        this.myListener = new MyDocumentAdapter();
        this.myAlarmRunnable = new MyRunnable();
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void activate() {
        if (this.myConnection == null) {
            this.myListenerDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.myProject, (Disposable)this.myListenerDisposable);
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.myListener, this.myListenerDisposable);
            this.myConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
            this.myConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

                public void beforeAllDocumentsSaving() {
                    DelayedDocumentWatcher.this.myDocumentSavingInProgress = true;
                    ApplicationManager.getApplication().invokeLater(() -> DelayedDocumentWatcher.this.myDocumentSavingInProgress = false, ModalityState.any());
                }
            });
        }
    }

    @Override
    public void deactivate() {
        if (this.myConnection != null) {
            if (this.myListenerDisposable != null) {
                Disposer.dispose((Disposable)this.myListenerDisposable);
                this.myListenerDisposable = null;
            }
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    @Override
    public boolean isUpToDate(int modificationStamp) {
        return this.myModificationStamp == modificationStamp;
    }

    private void asyncCheckErrors(final @NotNull Collection<VirtualFile> files, @NotNull Consumer<Boolean> errorsFoundConsumer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            boolean errorsFound = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    for (VirtualFile file2 : files) {
                        if (!PsiErrorElementUtil.hasErrors(DelayedDocumentWatcher.this.myProject, file2)) continue;
                        return true;
                    }
                    return false;
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> errorsFoundConsumer.consume((Object)errorsFound), ModalityState.any());
        });
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            int oldModificationStamp = DelayedDocumentWatcher.this.myModificationStamp;
            DelayedDocumentWatcher.this.asyncCheckErrors(DelayedDocumentWatcher.this.myChangedFiles, (Consumer<Boolean>)errorsFound -> {
                if (DelayedDocumentWatcher.this.myModificationStamp != oldModificationStamp) {
                    return;
                }
                if (errorsFound.booleanValue()) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.clear();
                DelayedDocumentWatcher.this.myModificationStampConsumer.consume((Object)DelayedDocumentWatcher.this.myModificationStamp);
            });
        }
    }

    private class MyDocumentAdapter
    extends DocumentAdapter {
        private MyDocumentAdapter() {
        }

        public void documentChanged(DocumentEvent event) {
            if (DelayedDocumentWatcher.this.myDocumentSavingInProgress) {
                return;
            }
            Document document = event.getDocument();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            if (file2 == null) {
                return;
            }
            if (!DelayedDocumentWatcher.this.myChangedFiles.contains(file2)) {
                if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
                    return;
                }
                if (DelayedDocumentWatcher.this.myChangedFileFilter != null && !DelayedDocumentWatcher.this.myChangedFileFilter.value((Object)file2)) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.add(file2);
            }
            DelayedDocumentWatcher.this.myAlarm.cancelRequest(DelayedDocumentWatcher.this.myAlarmRunnable);
            DelayedDocumentWatcher.this.myAlarm.addRequest(DelayedDocumentWatcher.this.myAlarmRunnable, DelayedDocumentWatcher.this.myDelayMillis);
            DelayedDocumentWatcher.this.myModificationStamp++;
        }
    }
}

