/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.Output;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class OutputListener
extends ProcessAdapter {
    private final StringBuilder out;
    private final StringBuilder err;
    private int myExitCode;

    public OutputListener() {
        this.out = new StringBuilder();
        this.err = new StringBuilder();
    }

    public OutputListener(@NotNull StringBuilder out, @NotNull StringBuilder err) {
        this.out = out;
        this.err = err;
    }

    public void onTextAvailable(ProcessEvent event, Key outputType) {
        if (outputType == ProcessOutputTypes.STDERR) {
            this.err.append(event.getText());
        } else if (outputType != ProcessOutputTypes.SYSTEM) {
            this.out.append(event.getText());
        }
    }

    public void processTerminated(ProcessEvent event) {
        this.myExitCode = event.getExitCode();
    }

    public Output getOutput() {
        return new Output(this.out.toString(), this.err.toString(), this.myExitCode);
    }
}

