/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.KillableProcess;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopProcessAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    private ProcessHandler myProcessHandler;

    public StopProcessAction(@NotNull String text, @Nullable String description, @Nullable ProcessHandler processHandler2) {
        super(text, description, AllIcons.Actions.Suspend);
        this.myProcessHandler = processHandler2;
    }

    public void setProcessHandler(@Nullable ProcessHandler processHandler2) {
        this.myProcessHandler = processHandler2;
    }

    public void update(AnActionEvent e) {
        StopProcessAction.update(e.getPresentation(), this.getTemplatePresentation(), this.myProcessHandler);
    }

    public static void update(@NotNull Presentation presentation, @NotNull Presentation templatePresentation, @Nullable ProcessHandler processHandler2) {
        boolean enable = false;
        Icon icon = templatePresentation.getIcon();
        String description = templatePresentation.getDescription();
        if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
            KillableProcess killableProcess;
            enable = true;
            if (processHandler2.isProcessTerminating() && processHandler2 instanceof KillableProcess && (killableProcess = (KillableProcess)processHandler2).canKillProcess()) {
                icon = AllIcons.Debugger.KillProcess;
                description = "Kill process";
            }
        }
        presentation.setEnabled(enable);
        presentation.setIcon(icon);
        presentation.setDescription(description);
    }

    public void actionPerformed(AnActionEvent e) {
        StopProcessAction.stopProcess(this.myProcessHandler);
    }

    public static void stopProcess(@Nullable ProcessHandler processHandler2) {
        ExecutionManagerImpl.stopProcess(processHandler2);
    }
}

