/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleExecuteAction
extends DumbAwareAction {
    static final String CONSOLE_EXECUTE_ACTION_ID = "Console.Execute";
    private final LanguageConsoleView myConsoleView;
    final ConsoleExecuteActionHandler myExecuteActionHandler;
    private final Condition<LanguageConsoleView> myEnabledCondition;

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler) {
        this(console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, (Condition<LanguageConsoleView>)Conditions.alwaysTrue());
    }

    ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull ConsoleExecuteActionHandler executeActionHandler, @Nullable Condition<LanguageConsoleView> enabledCondition) {
        this(console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, enabledCondition);
    }

    public ConsoleExecuteAction(@NotNull LanguageConsoleView console, @NotNull BaseConsoleExecuteActionHandler executeActionHandler, @Nullable Condition<LanguageConsoleView> enabledCondition) {
        this(console, executeActionHandler, CONSOLE_EXECUTE_ACTION_ID, enabledCondition);
    }

    public ConsoleExecuteAction(@NotNull LanguageConsoleView consoleView, @NotNull ConsoleExecuteActionHandler executeActionHandler, @NotNull String emptyExecuteActionId, @Nullable Condition<LanguageConsoleView> enabledCondition) {
        super(null, null, AllIcons.Actions.Execute);
        this.myConsoleView = consoleView;
        this.myExecuteActionHandler = executeActionHandler;
        this.myEnabledCondition = enabledCondition == null ? Conditions.alwaysTrue() : enabledCondition;
        EmptyAction.setupAction((AnAction)this, (String)emptyExecuteActionId, null);
    }

    public final void update(@NotNull AnActionEvent e) {
        boolean enabled;
        EditorEx editor = this.myConsoleView.getConsoleEditor();
        boolean bl = enabled = !editor.isRendererMode() && this.isEnabled() && (this.myExecuteActionHandler.isEmptyCommandExecutionAllowed() || !StringUtil.isEmptyOrSpaces((CharSequence)editor.getDocument().getCharsSequence()));
        if (enabled) {
            LookupEx lookup = LookupManager.getActiveLookup(editor);
            enabled = lookup == null || !lookup.isCompletion() || lookup.getCurrentItem() == null || lookup instanceof LookupImpl && ((LookupImpl)lookup).getFocusDegree() == LookupImpl.FocusDegree.UNFOCUSED;
        }
        e.getPresentation().setEnabled(enabled);
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        this.myExecuteActionHandler.runExecuteAction(this.myConsoleView);
    }

    public boolean isEnabled() {
        return this.myEnabledCondition.value((Object)this.myConsoleView);
    }

    public void execute(@Nullable TextRange range, @NotNull String text, @Nullable EditorEx editor) {
        if (range == null) {
            ((LanguageConsoleImpl)this.myConsoleView).doAddPromptToHistory();
            this.myConsoleView.print(text, ConsoleViewContentType.USER_INPUT);
            if (!text.endsWith("\n")) {
                this.myConsoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            }
        } else {
            assert (editor != null);
            ((LanguageConsoleImpl)this.myConsoleView).addTextRangeToHistory(range, editor, this.myExecuteActionHandler.myPreserveMarkup);
        }
        this.myExecuteActionHandler.addToCommandHistoryAndExecute(this.myConsoleView, text);
    }

    public static abstract class ConsoleExecuteActionHandler {
        private boolean myAddToHistory = true;
        final boolean myPreserveMarkup;
        boolean myUseProcessStdIn;

        public ConsoleExecuteActionHandler(boolean preserveMarkup) {
            this.myPreserveMarkup = preserveMarkup;
        }

        public boolean isEmptyCommandExecutionAllowed() {
            return true;
        }

        public final void setAddCurrentToHistory(boolean addCurrentToHistory) {
            this.myAddToHistory = addCurrentToHistory;
        }

        protected void beforeExecution(@NotNull LanguageConsoleView consoleView) {
        }

        public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
            if (!this.myUseProcessStdIn) {
                this.beforeExecution(consoleView);
            }
            String text = ((LanguageConsoleImpl)consoleView).prepareExecuteAction(this.myAddToHistory && !this.myUseProcessStdIn, this.myPreserveMarkup, true);
            ((UndoManagerImpl)UndoManager.getInstance((Project)consoleView.getProject())).invalidateActionsFor(DocumentReferenceManager.getInstance().create((Document)consoleView.getCurrentEditor().getDocument()));
            if (this.myUseProcessStdIn) {
                consoleView.print(text, ConsoleViewContentType.USER_INPUT);
                consoleView.print("\n", ConsoleViewContentType.USER_INPUT);
            } else {
                this.addToCommandHistoryAndExecute(consoleView, text);
            }
        }

        private void addToCommandHistoryAndExecute(@NotNull LanguageConsoleView consoleView, @NotNull String text) {
            ConsoleHistoryController.addToHistory(consoleView, text);
            this.doExecute(text, consoleView);
        }

        abstract void doExecute(@NotNull String var1, @NotNull LanguageConsoleView var2);
    }
}

