/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.console.ConsoleHistoryController;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DuplexConsoleView<S extends ConsoleView, T extends ConsoleView>
extends JPanel
implements ConsoleView,
ObservableConsoleView,
DataProvider {
    private static final String PRIMARY_CONSOLE_PANEL = "PRIMARY_CONSOLE_PANEL";
    private static final String SECONDARY_CONSOLE_PANEL = "SECONDARY_CONSOLE_PANEL";
    @NotNull
    private final S myPrimaryConsoleView;
    @NotNull
    private final T mySecondaryConsoleView;
    @Nullable
    private final String myStateStorageKey;
    private boolean myPrimary;
    @Nullable
    private ProcessHandler myProcessHandler;
    @NotNull
    private final SwitchDuplexConsoleViewAction mySwitchConsoleAction;
    private boolean myDisableSwitchConsoleActionOnProcessEnd = true;

    public DuplexConsoleView(@NotNull S primaryConsoleView, @NotNull T secondaryConsoleView) {
        this(primaryConsoleView, secondaryConsoleView, null);
    }

    public DuplexConsoleView(@NotNull S primaryConsoleView, @NotNull T secondaryConsoleView, @Nullable String stateStorageKey) {
        super(new CardLayout());
        this.myPrimaryConsoleView = primaryConsoleView;
        this.mySecondaryConsoleView = secondaryConsoleView;
        this.myStateStorageKey = stateStorageKey;
        this.add((Component)this.myPrimaryConsoleView.getComponent(), PRIMARY_CONSOLE_PANEL);
        this.add((Component)this.mySecondaryConsoleView.getComponent(), SECONDARY_CONSOLE_PANEL);
        this.mySwitchConsoleAction = new SwitchDuplexConsoleViewAction();
        this.myPrimary = true;
        this.enableConsole(this.getStoredState());
        Disposer.register((Disposable)this, this.myPrimaryConsoleView);
        Disposer.register((Disposable)this, this.mySecondaryConsoleView);
    }

    public static <S extends ConsoleView, T extends ConsoleView> DuplexConsoleView<S, T> create(@NotNull S primary, @NotNull T secondary, @Nullable String stateStorageKey) {
        return new DuplexConsoleView<S, T>(primary, secondary, stateStorageKey);
    }

    private void setStoredState(boolean primary) {
        if (this.myStateStorageKey != null) {
            PropertiesComponent.getInstance().setValue(this.myStateStorageKey, primary);
        }
    }

    private boolean getStoredState() {
        if (this.myStateStorageKey == null) {
            return false;
        }
        return PropertiesComponent.getInstance().getBoolean(this.myStateStorageKey);
    }

    public void enableConsole(boolean primary) {
        if (primary == this.myPrimary) {
            return;
        }
        CardLayout cl = (CardLayout)this.getLayout();
        cl.show(this, primary ? PRIMARY_CONSOLE_PANEL : SECONDARY_CONSOLE_PANEL);
        this.getSubConsoleView(primary).getComponent().requestFocus();
        this.myPrimary = primary;
    }

    public boolean isPrimaryConsoleEnabled() {
        return this.myPrimary;
    }

    @NotNull
    public S getPrimaryConsoleView() {
        return this.myPrimaryConsoleView;
    }

    @NotNull
    public T getSecondaryConsoleView() {
        return this.mySecondaryConsoleView;
    }

    public ConsoleView getSubConsoleView(boolean primary) {
        return primary ? this.getPrimaryConsoleView() : this.getSecondaryConsoleView();
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        this.myPrimaryConsoleView.print(s, contentType);
        this.mySecondaryConsoleView.print(s, contentType);
    }

    public void clear() {
        this.myPrimaryConsoleView.clear();
        this.mySecondaryConsoleView.clear();
    }

    public void scrollTo(int offset) {
        this.myPrimaryConsoleView.scrollTo(offset);
        this.mySecondaryConsoleView.scrollTo(offset);
    }

    public void attachToProcess(ProcessHandler processHandler2) {
        this.myProcessHandler = processHandler2;
        this.myPrimaryConsoleView.attachToProcess(processHandler2);
        this.mySecondaryConsoleView.attachToProcess(processHandler2);
    }

    public void setOutputPaused(boolean value2) {
        this.myPrimaryConsoleView.setOutputPaused(value2);
        this.mySecondaryConsoleView.setOutputPaused(value2);
    }

    public boolean isOutputPaused() {
        return false;
    }

    public boolean hasDeferredOutput() {
        return this.myPrimaryConsoleView.hasDeferredOutput() && this.mySecondaryConsoleView.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
    }

    public void setHelpId(@NotNull String helpId) {
        this.myPrimaryConsoleView.setHelpId(helpId);
        this.mySecondaryConsoleView.setHelpId(helpId);
    }

    public void addMessageFilter(@NotNull Filter filter) {
        this.myPrimaryConsoleView.addMessageFilter(filter);
        this.mySecondaryConsoleView.addMessageFilter(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, HyperlinkInfo info) {
        this.myPrimaryConsoleView.printHyperlink(hyperlinkText, info);
        this.mySecondaryConsoleView.printHyperlink(hyperlinkText, info);
    }

    public int getContentSize() {
        return this.myPrimaryConsoleView.getContentSize();
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        ConsoleHistoryController controller;
        ArrayList actions = Lists.newArrayList();
        actions.addAll(this.mergeConsoleActions(Arrays.asList(this.myPrimaryConsoleView.createConsoleActions()), Arrays.asList(this.mySecondaryConsoleView.createConsoleActions())));
        actions.add(this.mySwitchConsoleAction);
        LanguageConsoleView langConsole = (LanguageConsoleView)ContainerUtil.findInstance(Arrays.asList(this.myPrimaryConsoleView, this.mySecondaryConsoleView), LanguageConsoleView.class);
        ConsoleHistoryController consoleHistoryController = controller = langConsole != null ? ConsoleHistoryController.getController(langConsole) : null;
        if (controller != null) {
            actions.add(controller.getBrowseHistory());
        }
        return (AnAction[])ArrayUtil.toObjectArray((Collection)actions, AnAction.class);
    }

    public void allowHeavyFilters() {
        this.myPrimaryConsoleView.allowHeavyFilters();
    }

    public JComponent getComponent() {
        return this;
    }

    public JComponent getPreferredFocusableComponent() {
        return this;
    }

    public void dispose() {
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener2, @NotNull Disposable parent) {
        if (this.myPrimaryConsoleView instanceof ObservableConsoleView) {
            ((ObservableConsoleView)this.myPrimaryConsoleView).addChangeListener(listener2, parent);
        }
        if (this.mySecondaryConsoleView instanceof ObservableConsoleView) {
            ((ObservableConsoleView)this.mySecondaryConsoleView).addChangeListener(listener2, parent);
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        ConsoleView consoleView = this.getSubConsoleView(this.isPrimaryConsoleEnabled());
        if (consoleView instanceof DataProvider) {
            return ((DataProvider)consoleView).getData(dataId);
        }
        return null;
    }

    @NotNull
    public Presentation getSwitchConsoleActionPresentation() {
        return this.mySwitchConsoleAction.getTemplatePresentation();
    }

    public void setDisableSwitchConsoleActionOnProcessEnd(boolean disableSwitchConsoleActionOnProcessEnd) {
        this.myDisableSwitchConsoleActionOnProcessEnd = disableSwitchConsoleActionOnProcessEnd;
    }

    @NotNull
    private List<AnAction> mergeConsoleActions(@NotNull List<AnAction> actions1, @NotNull Collection<AnAction> actions2) {
        return ContainerUtil.map(actions1, action1 -> {
            AnAction action2 = (AnAction)ContainerUtil.find((Iterable)actions2, action -> action1.getClass() == action.getClass() && StringUtil.equals((CharSequence)action1.getTemplatePresentation().getText(), (CharSequence)action.getTemplatePresentation().getText()));
            if (action2 instanceof ToggleUseSoftWrapsToolbarAction) {
                return new MergedWrapTextAction((ToggleUseSoftWrapsToolbarAction)((Object)action1), (ToggleUseSoftWrapsToolbarAction)action2);
            }
            if (action2 instanceof ScrollToTheEndToolbarAction) {
                return new MergedToggleAction((ToggleAction)action1, (ToggleAction)action2);
            }
            if (action2 instanceof ConsoleViewImpl.ClearAllAction) {
                return new MergedAction((AnAction)action1, action2);
            }
            return action1;
        });
    }

    private static class MergedAction
    extends AnAction
    implements DumbAware {
        @NotNull
        private final AnAction myAction1;
        @NotNull
        private final AnAction myAction2;

        private MergedAction(@NotNull AnAction action1, @NotNull AnAction action2) {
            this.myAction1 = action1;
            this.myAction2 = action2;
            this.copyFrom(action1);
        }

        public void actionPerformed(AnActionEvent e) {
            this.myAction1.actionPerformed(e);
            this.myAction2.actionPerformed(e);
        }
    }

    private static class MergedToggleAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final ToggleAction myAction1;
        @NotNull
        private final ToggleAction myAction2;

        private MergedToggleAction(@NotNull ToggleAction action1, @NotNull ToggleAction action2) {
            this.myAction1 = action1;
            this.myAction2 = action2;
            this.copyFrom((AnAction)action1);
        }

        public boolean isSelected(AnActionEvent e) {
            return this.myAction1.isSelected(e);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            this.myAction1.setSelected(e, state);
            this.myAction2.setSelected(e, state);
        }
    }

    private class SwitchDuplexConsoleViewAction
    extends ToggleAction
    implements DumbAware {
        public SwitchDuplexConsoleViewAction() {
            super(ExecutionBundle.message((String)"run.configuration.show.command.line.action.name", (Object[])new Object[0]), null, AllIcons.Debugger.ToolConsole);
        }

        public boolean isSelected(AnActionEvent event) {
            return !DuplexConsoleView.this.isPrimaryConsoleEnabled();
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DuplexConsoleView.this.enableConsole(!flag);
            DuplexConsoleView.this.setStoredState(!flag);
            ApplicationManager.getApplication().invokeLater(() -> this.update(event));
        }

        public void update(@NotNull AnActionEvent event) {
            boolean isRunning;
            super.update(event);
            if (!DuplexConsoleView.this.myDisableSwitchConsoleActionOnProcessEnd) {
                return;
            }
            Presentation presentation = event.getPresentation();
            boolean bl = isRunning = DuplexConsoleView.this.myProcessHandler != null && !DuplexConsoleView.this.myProcessHandler.isProcessTerminated();
            if (isRunning) {
                presentation.setEnabled(true);
            } else {
                DuplexConsoleView.this.enableConsole(true);
                presentation.putClientProperty("selected", (Object)false);
                presentation.setEnabled(false);
            }
        }
    }

    private class MergedWrapTextAction
    extends MergedToggleAction {
        private MergedWrapTextAction(@NotNull ToggleUseSoftWrapsToolbarAction action1, ToggleUseSoftWrapsToolbarAction action2) {
            super(action1, action2);
        }

        @Override
        public void setSelected(AnActionEvent e, boolean state) {
            super.setSelected(e, state);
            DuplexConsoleView.this.getComponent().revalidate();
        }
    }
}

