/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.execution.console.ConsoleRootType;
import com.intellij.execution.console.RunIdeConsoleAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.JBUI;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeConsoleRootType
extends ConsoleRootType {
    IdeConsoleRootType() {
        super("ide", "IDE Scripting");
    }

    @NotNull
    public static IdeConsoleRootType getInstance() {
        return IdeConsoleRootType.findByClass(IdeConsoleRootType.class);
    }

    @Override
    @Nullable
    public Icon substituteIcon(@NotNull Project project2, @NotNull VirtualFile file2) {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
        if (fileType == UnknownFileType.INSTANCE || fileType == PlainTextFileType.INSTANCE) {
            return AllIcons.Debugger.ToolConsole;
        }
        Icon icon = fileType.getIcon();
        Icon subscript = ((ScalableIcon)AllIcons.Debugger.ToolConsole).scale(0.5f);
        LayeredIcon icons = new LayeredIcon(2);
        icons.setIcon(icon, 0);
        icons.setIcon(subscript, 1, 8, 8);
        return JBUI.scale((JBUI.JBIcon)icons);
    }

    @Override
    public void fileOpened(@NotNull VirtualFile file2, @NotNull FileEditorManager source) {
        RunIdeConsoleAction.configureConsole(file2, source);
    }
}

