/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.actions.RunDashboardTreeAction;
import com.intellij.execution.dashboard.tree.GroupingNode;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class RunDashboardTreeLeafAction<T extends DashboardNode>
extends RunDashboardTreeAction<T> {
    protected RunDashboardTreeLeafAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    protected final boolean isMultiSelectionAllowed() {
        return true;
    }

    @NotNull
    protected Set<?> collectNodes(@NotNull AbstractTreeBuilder treeBuilder) {
        Set selectedElement = treeBuilder.getSelectedElements();
        ArrayList<AbstractTreeNode> nodes = new ArrayList<AbstractTreeNode>();
        for (Object o : selectedElement) {
            if (!(o instanceof AbstractTreeNode)) {
                return Collections.emptySet();
            }
            nodes.add((AbstractTreeNode)o);
        }
        return RunDashboardTreeLeafAction.getLeaves(nodes);
    }

    private static Set<AbstractTreeNode> getLeaves(Collection<? extends AbstractTreeNode> nodes) {
        HashSet<AbstractTreeNode> result2 = new HashSet<AbstractTreeNode>();
        for (AbstractTreeNode abstractTreeNode : nodes) {
            Collection children2 = abstractTreeNode.getChildren();
            if (children2.isEmpty()) {
                if (abstractTreeNode instanceof GroupingNode) continue;
                result2.add(abstractTreeNode);
                continue;
            }
            result2.addAll(RunDashboardTreeLeafAction.getLeaves(children2));
        }
        return result2;
    }
}

