/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.JavaPatchableProgramRunner;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.execution.runners.ProcessProxyFactory;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpConsoleFactory;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.text.DateFormatUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;

public class DefaultJavaProgramRunner
extends JavaPatchableProgramRunner {
    private static final String ourWiseThreadDumpProperty = "idea.java.run.wise.thread.dump";
    public static final String DEFAULT_JAVA_RUNNER_ID = "Run";

    public static ProgramRunner getInstance() {
        return RunnerRegistry.getInstance().findRunnerById(DEFAULT_JAVA_RUNNER_ID);
    }

    @NotNull
    public String getRunnerId() {
        return DEFAULT_JAVA_RUNNER_ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        return executorId.equals(DefaultRunExecutor.EXECUTOR_ID) && profile2 instanceof ModuleRunProfile && !(profile2 instanceof RunConfigurationWithSuppressedDefaultRunAction);
    }

    public void patch(JavaParameters javaParameters, RunnerSettings settings, RunProfile runProfile, boolean beforeExecution) throws ExecutionException {
        DefaultJavaProgramRunner.runCustomPatchers((JavaParameters)javaParameters, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)runProfile);
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        ExecutionResult executionResult;
        FileDocumentManager.getInstance().saveAllDocuments();
        boolean shouldAddDefaultActions = true;
        if (state instanceof JavaCommandLine) {
            JavaParameters parameters2 = ((JavaCommandLine)state).getJavaParameters();
            this.patch(parameters2, env.getRunnerSettings(), env.getRunProfile(), true);
            final ProcessProxy proxy = ProcessProxyFactory.getInstance().createCommandLineProxy((JavaCommandLine)state);
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
            if (proxy != null) {
                ProcessHandler handler2;
                ProcessHandler processHandler2 = handler2 = executionResult != null ? executionResult.getProcessHandler() : null;
                if (handler2 != null) {
                    proxy.attach(handler2);
                    handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(ProcessEvent event) {
                            proxy.destroy();
                        }
                    });
                } else {
                    proxy.destroy();
                }
            }
            if (state instanceof JavaCommandLineState && !((JavaCommandLineState)state).shouldAddJavaProgramRunnerActions()) {
                shouldAddDefaultActions = false;
            }
        } else {
            executionResult = state.execute(env.getExecutor(), (ProgramRunner)this);
        }
        if (executionResult == null) {
            return null;
        }
        this.onProcessStarted(env.getRunnerSettings(), executionResult);
        RunContentBuilder contentBuilder = new RunContentBuilder(executionResult, env);
        if (shouldAddDefaultActions) {
            DefaultJavaProgramRunner.addDefaultActions(contentBuilder, executionResult);
        }
        return contentBuilder.showRunContent(env.getContentToReuse());
    }

    private static void addDefaultActions(@NotNull RunContentBuilder contentBuilder, @NotNull ExecutionResult executionResult) {
        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
        final JComponent consoleComponent = executionConsole != null ? executionConsole.getComponent() : null;
        final ControlBreakAction controlBreakAction = new ControlBreakAction(executionResult.getProcessHandler());
        if (consoleComponent != null) {
            controlBreakAction.registerCustomShortcutSet(controlBreakAction.getShortcutSet(), consoleComponent);
            final ProcessHandler processHandler2 = executionResult.getProcessHandler();
            assert (processHandler2 != null) : executionResult;
            processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    processHandler2.removeProcessListener((ProcessListener)this);
                    controlBreakAction.unregisterCustomShortcutSet(consoleComponent);
                }
            });
        }
        contentBuilder.addAction(controlBreakAction);
        contentBuilder.addAction(new SoftExitAction(executionResult.getProcessHandler()));
    }

    protected static class SoftExitAction
    extends ProxyBasedAction {
        public SoftExitAction(ProcessHandler processHandler2) {
            super(ExecutionBundle.message((String)"run.configuration.exit.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Exit, processHandler2);
        }

        @Override
        protected boolean available(ProcessProxy proxy) {
            return proxy.canSendStop();
        }

        @Override
        protected void perform(AnActionEvent e, ProcessProxy proxy) {
            proxy.sendStop();
        }
    }

    private static class WiseDumpThreadsListener {
        private final Project myProject;
        private final ProcessHandler myProcessHandler;
        private final CapturingProcessAdapter myListener;

        public WiseDumpThreadsListener(Project project2, ProcessHandler processHandler2) {
            this.myProject = project2;
            this.myProcessHandler = processHandler2;
            this.myListener = new CapturingProcessAdapter();
            this.myProcessHandler.addProcessListener((ProcessListener)this.myListener);
        }

        public void after() {
            if (this.myProject == null) {
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                String stdout;
                if (this.myProcessHandler.isProcessTerminated() || this.myProcessHandler.isProcessTerminating()) {
                    return;
                }
                List<ThreadState> threadStates = null;
                long start = System.currentTimeMillis();
                while (System.currentTimeMillis() - start < 1000L && ((threadStates = ThreadDumpParser.parse(stdout = this.myListener.getOutput().getStdout())) == null || threadStates.isEmpty())) {
                    TimeoutUtil.sleep((long)50L);
                    threadStates = null;
                }
                this.myProcessHandler.removeProcessListener((ProcessListener)this.myListener);
                if (threadStates != null && !threadStates.isEmpty()) {
                    this.showThreadDump(this.myListener.getOutput().getStdout(), threadStates);
                }
            });
        }

        private void showThreadDump(String out, List<ThreadState> states) {
            ThreadDumpConsoleFactory factory = states.size() > 1 ? new ThreadDumpConsoleFactory(this.myProject, states) : null;
            String title = "<Stacktrace> " + DateFormatUtil.formatDateTime((long)System.currentTimeMillis());
            ApplicationManager.getApplication().invokeLater(() -> AnalyzeStacktraceUtil.addConsole(this.myProject, factory, title, out), ModalityState.NON_MODAL);
        }
    }

    protected static class ControlBreakAction
    extends ProxyBasedAction {
        public ControlBreakAction(ProcessHandler processHandler2) {
            super(ExecutionBundle.message((String)"run.configuration.dump.threads.action.name", (Object[])new Object[0]), null, AllIcons.Actions.Dump, processHandler2);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(3, 128)));
        }

        @Override
        protected boolean available(ProcessProxy proxy) {
            return proxy.canSendBreak();
        }

        @Override
        protected void perform(AnActionEvent e, ProcessProxy proxy) {
            boolean wise = Boolean.getBoolean(DefaultJavaProgramRunner.ourWiseThreadDumpProperty);
            WiseDumpThreadsListener wiseListener = wise ? new WiseDumpThreadsListener(e.getProject(), this.myProcessHandler) : null;
            proxy.sendBreak();
            if (wiseListener != null) {
                wiseListener.after();
            }
        }
    }

    private static abstract class ProxyBasedAction
    extends AnAction {
        protected final ProcessHandler myProcessHandler;

        protected ProxyBasedAction(String text, String description, Icon icon, ProcessHandler processHandler2) {
            super(text, description, icon);
            this.myProcessHandler = processHandler2;
        }

        public final void update(@NotNull AnActionEvent event) {
            ProcessProxy proxy = ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler);
            boolean available = proxy != null && this.available(proxy);
            Presentation presentation = event.getPresentation();
            if (!available) {
                presentation.setEnabledAndVisible(false);
            } else {
                presentation.setVisible(true);
                presentation.setEnabled(!this.myProcessHandler.isProcessTerminated());
            }
        }

        public final void actionPerformed(@NotNull AnActionEvent e) {
            ProcessProxy proxy = ProcessProxyFactory.getInstance().getAttachedProxy(this.myProcessHandler);
            if (proxy != null) {
                this.perform(e, proxy);
            }
        }

        protected abstract boolean available(ProcessProxy var1);

        protected abstract void perform(AnActionEvent var1, ProcessProxy var2);
    }
}

