/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.util.Consumer;
import com.intellij.util.ui.EmptyIcon;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewRunConfigurationPopup {
    @NotNull
    public static ListPopup createAddPopup(final @NotNull List<ConfigurationType> typesToShow, final @NotNull String defaultText, final @NotNull Consumer<ConfigurationFactory> creator, final @Nullable ConfigurationType selectedConfigurationType, final @NotNull Runnable finalStep, boolean showTitle) {
        return JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<ConfigurationType>(showTitle ? ExecutionBundle.message((String)"add.new.run.configuration.acrtion.name", (Object[])new Object[0]) : null, typesToShow){

            @NotNull
            public String getTextFor(ConfigurationType type2) {
                return type2 != null ? type2.getDisplayName() : defaultText;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public boolean canBeHidden(ConfigurationType value2) {
                return true;
            }

            public Icon getIconFor(ConfigurationType type2) {
                return type2 != null ? type2.getIcon() : EmptyIcon.ICON_16;
            }

            public PopupStep onChosen(ConfigurationType type2, boolean finalChoice) {
                if (this.hasSubstep(type2)) {
                    return this.getSupStep(type2);
                }
                if (type2 == null) {
                    return this.doFinalStep(finalStep);
                }
                ConfigurationFactory[] factories = type2.getConfigurationFactories();
                if (factories.length > 0) {
                    creator.consume((Object)factories[0]);
                }
                return FINAL_CHOICE;
            }

            public int getDefaultOptionIndex() {
                return selectedConfigurationType != null ? typesToShow.indexOf(selectedConfigurationType) : super.getDefaultOptionIndex();
            }

            private ListPopupStep getSupStep(ConfigurationType type2) {
                ConfigurationFactory[] factories = type2.getConfigurationFactories();
                Arrays.sort(factories, (factory1, factory2) -> factory1.getName().compareToIgnoreCase(factory2.getName()));
                return new BaseListPopupStep<ConfigurationFactory>(ExecutionBundle.message((String)"add.new.run.configuration.action.name", (Object[])new Object[]{type2.getDisplayName()}), factories){

                    @NotNull
                    public String getTextFor(ConfigurationFactory value2) {
                        return value2.getName();
                    }

                    public Icon getIconFor(ConfigurationFactory factory) {
                        return factory.getIcon();
                    }

                    public PopupStep onChosen(ConfigurationFactory factory, boolean finalChoice) {
                        creator.consume((Object)factory);
                        return FINAL_CHOICE;
                    }
                };
            }

            public boolean hasSubstep(ConfigurationType type2) {
                return type2 != null && type2.getConfigurationFactories().length > 1;
            }
        });
    }
}

