/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.ProjectTopics;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerConfig;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.UnknownConfigurationType;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.impl.UnknownBeforeRunTaskProvider;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.WeakHashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RunManager", defaultStateAsResource=true, storages={@Storage(value="$WORKSPACE_FILE$")})
public class RunManagerImpl
extends RunManagerEx
implements PersistentStateComponent<Element>,
NamedComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance(RunManagerImpl.class);
    private final Project myProject;
    private final Map<String, ConfigurationType> myTypesByName = new LinkedHashMap<String, ConfigurationType>();
    private final Map<String, RunnerAndConfigurationSettings> myTemplateConfigurationsMap = new ConcurrentSkipListMap<String, RunnerAndConfigurationSettings>();
    private final Map<String, RunnerAndConfigurationSettings> myConfigurations = new LinkedHashMap<String, RunnerAndConfigurationSettings>();
    private final Map<String, Boolean> mySharedConfigurations = new ConcurrentHashMap<String, Boolean>();
    private final Map<RunConfiguration, List<BeforeRunTask>> myConfigurationToBeforeTasksMap = new WeakHashMap();
    @Nullable
    private String myLoadedSelectedConfigurationUniqueName = null;
    @Nullable
    private String mySelectedConfigurationId = null;
    private final Map<String, Icon> myIdToIcon = new HashMap();
    private final Map<String, Long> myIconCheckTimes = new HashMap();
    private final Map<String, Long> myIconCalcTime = Collections.synchronizedMap(new HashMap());
    @NonNls
    protected static final String CONFIGURATION = "configuration";
    protected static final String RECENT = "recent_temporary";
    private ConfigurationType[] myTypes;
    private final RunManagerConfig myConfig;
    @NonNls
    protected static final String NAME_ATTR = "name";
    @NonNls
    protected static final String SELECTED_ATTR = "selected";
    @NonNls
    private static final String METHOD = "method";
    @NonNls
    private static final String OPTION = "option";
    private List<Element> myUnknownElements = null;
    private final JDOMExternalizableStringList myOrder = new JDOMExternalizableStringList();
    private final ArrayList<RunConfiguration> myRecentlyUsedTemporaries = new ArrayList();
    private boolean myOrdered = true;
    private final EventDispatcher<RunManagerListener> myDispatcher = EventDispatcher.create(RunManagerListener.class);
    private Map<Key<? extends BeforeRunTask>, BeforeRunTaskProvider> myBeforeStepsMap;
    private Map<String, Key<? extends BeforeRunTask>> myProviderKeysMap;

    public RunManagerImpl(@NotNull Project project2, @NotNull PropertiesComponent propertiesComponent) {
        this.myConfig = new RunManagerConfig(propertiesComponent);
        this.myProject = project2;
        this.initializeConfigurationTypes((ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions());
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                RunnerAndConfigurationSettings configuration = RunManagerImpl.this.getSelectedConfiguration();
                if (configuration != null) {
                    RunManagerImpl.this.myIconCheckTimes.remove(configuration.getUniqueID());
                }
            }
        });
    }

    public final void initializeConfigurationTypes(@NotNull ConfigurationType[] factories) {
        Arrays.sort(factories, (o1, o2) -> o1.getDisplayName().compareTo(o2.getDisplayName()));
        ArrayList<ConfigurationType> types = new ArrayList<ConfigurationType>(Arrays.asList(factories));
        types.add((ConfigurationType)UnknownConfigurationType.INSTANCE);
        this.myTypes = types.toArray(new ConfigurationType[types.size()]);
        for (ConfigurationType type2 : factories) {
            this.myTypesByName.put(type2.getId(), type2);
        }
        UnknownConfigurationType broken = UnknownConfigurationType.INSTANCE;
        this.myTypesByName.put(broken.getId(), (ConfigurationType)broken);
    }

    @Override
    @NotNull
    public RunnerAndConfigurationSettings createConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory) {
        return this.createConfiguration(this.doCreateConfiguration(name, factory, true), factory);
    }

    protected RunConfiguration doCreateConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory, boolean fromTemplate) {
        if (fromTemplate) {
            return factory.createConfiguration(name, this.getConfigurationTemplate(factory).getConfiguration());
        }
        RunConfiguration configuration = factory.createTemplateConfiguration(this.myProject, (RunManager)this);
        configuration.setName(name);
        return configuration;
    }

    @NotNull
    public RunnerAndConfigurationSettings createConfiguration(@NotNull RunConfiguration runConfiguration, @NotNull ConfigurationFactory factory) {
        RunnerAndConfigurationSettings template = this.getConfigurationTemplate(factory);
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this, runConfiguration, false);
        settings.importRunnerAndConfigurationSettings((RunnerAndConfigurationSettingsImpl)template);
        if (!this.mySharedConfigurations.containsKey(settings.getUniqueID())) {
            this.shareConfiguration(settings, this.isConfigurationShared(template));
        }
        return settings;
    }

    public void dispose() {
        this.myTemplateConfigurationsMap.clear();
    }

    @Override
    public RunManagerConfig getConfig() {
        return this.myConfig;
    }

    @NotNull
    public ConfigurationType[] getConfigurationFactories() {
        return (ConfigurationType[])this.myTypes.clone();
    }

    public ConfigurationType[] getConfigurationFactories(boolean includeUnknown) {
        ConfigurationType[] configurationTypes = (ConfigurationType[])this.myTypes.clone();
        if (!includeUnknown) {
            ArrayList<ConfigurationType> types = new ArrayList<ConfigurationType>();
            for (ConfigurationType configurationType : configurationTypes) {
                if (configurationType instanceof UnknownConfigurationType) continue;
                types.add(configurationType);
            }
            return types.toArray(new ConfigurationType[types.size()]);
        }
        return configurationTypes;
    }

    @NotNull
    public List<RunConfiguration> getConfigurationsList(@NotNull ConfigurationType type2) {
        List result2 = null;
        for (RunnerAndConfigurationSettings settings : this.getSortedConfigurations()) {
            RunConfiguration configuration = settings.getConfiguration();
            if (!type2.getId().equals(configuration.getType().getId())) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(configuration);
        }
        return ContainerUtil.notNullize(result2);
    }

    @NotNull
    public List<RunConfiguration> getAllConfigurationsList() {
        Collection<RunnerAndConfigurationSettings> sortedConfigurations = this.getSortedConfigurations();
        if (sortedConfigurations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RunConfiguration> result2 = new ArrayList<RunConfiguration>(sortedConfigurations.size());
        for (RunnerAndConfigurationSettings settings : sortedConfigurations) {
            result2.add(settings.getConfiguration());
        }
        return result2;
    }

    @NotNull
    public RunConfiguration[] getAllConfigurations() {
        List<RunConfiguration> list = this.getAllConfigurationsList();
        return list.toArray(new RunConfiguration[list.size()]);
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getAllSettings() {
        return new ArrayList<RunnerAndConfigurationSettings>(this.getSortedConfigurations());
    }

    @Nullable
    public RunnerAndConfigurationSettings getSettings(@Nullable RunConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        for (RunnerAndConfigurationSettings settings : this.getSortedConfigurations()) {
            if (settings.getConfiguration() != configuration) continue;
            return settings;
        }
        return null;
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getConfigurationSettingsList(@NotNull ConfigurationType type2) {
        SmartList result2 = new SmartList();
        for (RunnerAndConfigurationSettings configuration : this.getSortedConfigurations()) {
            ConfigurationType configurationType = configuration.getType();
            if (configurationType == null || !type2.getId().equals(configurationType.getId())) continue;
            result2.add(configuration);
        }
        return result2;
    }

    @NotNull
    public RunnerAndConfigurationSettings[] getConfigurationSettings(@NotNull ConfigurationType type2) {
        List<RunnerAndConfigurationSettings> list = this.getConfigurationSettingsList(type2);
        return list.toArray(new RunnerAndConfigurationSettings[list.size()]);
    }

    @NotNull
    public RunConfiguration[] getConfigurations(@NotNull ConfigurationType type2) {
        RunnerAndConfigurationSettings[] settings = this.getConfigurationSettings(type2);
        RunConfiguration[] result2 = new RunConfiguration[settings.length];
        for (int i = 0; i < settings.length; ++i) {
            result2[i] = settings[i].getConfiguration();
        }
        return result2;
    }

    @Override
    @NotNull
    public Map<String, List<RunnerAndConfigurationSettings>> getStructure(@NotNull ConfigurationType type2) {
        LinkedHashMap<String, ArrayList<RunnerAndConfigurationSettings>> map2 = new LinkedHashMap<String, ArrayList<RunnerAndConfigurationSettings>>();
        ArrayList<RunnerAndConfigurationSettings> typeList = new ArrayList<RunnerAndConfigurationSettings>();
        List<RunnerAndConfigurationSettings> settings = this.getConfigurationSettingsList(type2);
        for (RunnerAndConfigurationSettings setting : settings) {
            String folderName = setting.getFolderName();
            if (folderName == null) {
                typeList.add(setting);
                continue;
            }
            ArrayList<RunnerAndConfigurationSettings> list = (ArrayList<RunnerAndConfigurationSettings>)map2.get(folderName);
            if (list == null) {
                list = new ArrayList<RunnerAndConfigurationSettings>();
                map2.put(folderName, list);
            }
            list.add(setting);
        }
        LinkedHashMap result2 = new LinkedHashMap();
        for (Map.Entry entry : map2.entrySet()) {
            result2.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        result2.put(null, Collections.unmodifiableList(typeList));
        return Collections.unmodifiableMap(result2);
    }

    @NotNull
    public RunnerAndConfigurationSettings getConfigurationTemplate(@NotNull ConfigurationFactory factory) {
        RunnerAndConfigurationSettings template = this.myTemplateConfigurationsMap.get(factory.getType().getId() + "." + factory.getName());
        if (template == null) {
            template = new RunnerAndConfigurationSettingsImpl(this, factory.createTemplateConfiguration(this.myProject, (RunManager)this), true);
            template.setSingleton(factory.isConfigurationSingletonByDefault());
            if (template.getConfiguration() instanceof UnknownRunConfiguration) {
                ((UnknownRunConfiguration)template.getConfiguration()).setDoNotStore(true);
            }
            this.myTemplateConfigurationsMap.put(factory.getType().getId() + "." + factory.getName(), template);
        }
        return template;
    }

    @Override
    public void addConfiguration(RunnerAndConfigurationSettings settings, boolean shared, List<BeforeRunTask> tasks, boolean addEnabledTemplateTasksIfAbsent) {
        String existingId = this.findExistingConfigurationId(settings);
        String newId = settings.getUniqueID();
        RunnerAndConfigurationSettings existingSettings = null;
        if (existingId != null) {
            existingSettings = this.myConfigurations.remove(existingId);
            this.mySharedConfigurations.remove(existingId);
        }
        if (this.mySelectedConfigurationId != null && this.mySelectedConfigurationId.equals(existingId)) {
            this.setSelectedConfigurationId(newId);
        }
        this.myConfigurations.put(newId, settings);
        RunConfiguration configuration = settings.getConfiguration();
        if (existingId == null) {
            this.refreshUsagesList((RunProfile)configuration);
        }
        this.checkRecentsLimit();
        this.mySharedConfigurations.put(newId, shared);
        if (shared) {
            settings.setTemporary(false);
        }
        this.setBeforeRunTasks(configuration, tasks, addEnabledTemplateTasksIfAbsent);
        if (existingSettings == settings) {
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationChanged(settings, existingId);
        } else {
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationAdded(settings);
        }
    }

    public void refreshUsagesList(RunProfile profile2) {
        if (!(profile2 instanceof RunConfiguration)) {
            return;
        }
        RunnerAndConfigurationSettings settings = this.getSettings((RunConfiguration)profile2);
        if (settings != null && settings.isTemporary()) {
            this.myRecentlyUsedTemporaries.remove((RunConfiguration)profile2);
            this.myRecentlyUsedTemporaries.add(0, (RunConfiguration)profile2);
            this.trimUsagesListToLimit();
        }
    }

    private void trimUsagesListToLimit() {
        while (this.myRecentlyUsedTemporaries.size() > this.getConfig().getRecentsLimit()) {
            this.myRecentlyUsedTemporaries.remove(this.myRecentlyUsedTemporaries.size() - 1);
        }
    }

    void checkRecentsLimit() {
        this.trimUsagesListToLimit();
        SmartList removed = new SmartList();
        block0: while (this.getTempConfigurationsList().size() > this.getConfig().getRecentsLimit()) {
            Iterator<RunnerAndConfigurationSettings> it = this.myConfigurations.values().iterator();
            while (it.hasNext()) {
                RunnerAndConfigurationSettings configuration = it.next();
                if (!configuration.isTemporary() || this.myRecentlyUsedTemporaries.contains(configuration.getConfiguration())) continue;
                removed.add(configuration);
                it.remove();
                continue block0;
            }
        }
        this.fireRunConfigurationsRemoved((List<RunnerAndConfigurationSettings>)removed);
    }

    public void setOrdered(boolean ordered) {
        this.myOrdered = ordered;
    }

    public void saveOrder() {
        this.setOrder(null);
    }

    private void doSaveOrder(@Nullable Comparator<RunnerAndConfigurationSettings> comparator2) {
        ArrayList<RunnerAndConfigurationSettings> sorted = new ArrayList<RunnerAndConfigurationSettings>(ContainerUtil.filter(this.myConfigurations.values(), o -> !(o.getType() instanceof UnknownConfigurationType)));
        if (comparator2 != null) {
            sorted.sort(comparator2);
        }
        this.myOrder.clear();
        for (RunnerAndConfigurationSettings each : sorted) {
            this.myOrder.add((Object)each.getUniqueID());
        }
    }

    public void setOrder(@Nullable Comparator<RunnerAndConfigurationSettings> comparator2) {
        this.doSaveOrder(comparator2);
        this.setOrdered(false);
    }

    @Override
    public void removeConfiguration(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            return;
        }
        Iterator<RunnerAndConfigurationSettings> it = this.getSortedConfigurations().iterator();
        while (it.hasNext()) {
            RunnerAndConfigurationSettings configuration = it.next();
            if (!configuration.equals(settings)) continue;
            if (this.mySelectedConfigurationId != null && this.mySelectedConfigurationId == settings.getUniqueID()) {
                this.setSelectedConfiguration(null);
            }
            it.remove();
            this.mySharedConfigurations.remove(settings.getUniqueID());
            this.myConfigurationToBeforeTasksMap.remove(settings.getConfiguration());
            this.myRecentlyUsedTemporaries.remove(settings.getConfiguration());
            ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationRemoved(configuration);
            break;
        }
        for (Map.Entry<RunConfiguration, List<BeforeRunTask>> entry : this.myConfigurationToBeforeTasksMap.entrySet()) {
            Iterator<BeforeRunTask> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                BeforeRunTask task = iterator.next();
                if (!(task instanceof RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask) || !settings.equals(((RunConfigurationBeforeRunProvider.RunConfigurableBeforeRunTask)task).getSettings())) continue;
                iterator.remove();
                RunnerAndConfigurationSettings changedSettings = this.getSettings(entry.getKey());
                if (changedSettings == null) continue;
                ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationChanged(changedSettings, null);
            }
        }
    }

    @Nullable
    public RunnerAndConfigurationSettings getSelectedConfiguration() {
        if (this.mySelectedConfigurationId == null && this.myLoadedSelectedConfigurationUniqueName != null) {
            this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        }
        return this.mySelectedConfigurationId == null ? null : this.myConfigurations.get(this.mySelectedConfigurationId);
    }

    public void setSelectedConfiguration(@Nullable RunnerAndConfigurationSettings settings) {
        this.setSelectedConfigurationId(settings == null ? null : settings.getUniqueID());
        this.fireRunConfigurationSelected();
    }

    private void setSelectedConfigurationId(@Nullable String id) {
        this.mySelectedConfigurationId = id;
        if (this.mySelectedConfigurationId != null) {
            this.myLoadedSelectedConfigurationUniqueName = null;
        }
    }

    @Override
    @NotNull
    public Collection<RunnerAndConfigurationSettings> getSortedConfigurations() {
        if (this.myOrdered) {
            return this.myConfigurations.values();
        }
        ArrayList<Pair> order = new ArrayList<Pair>(this.myConfigurations.size());
        SmartList folderNames = new SmartList();
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myConfigurations.values()) {
            order.add(Pair.create((Object)runnerAndConfigurationSettings.getUniqueID(), (Object)runnerAndConfigurationSettings));
            String folderName = runnerAndConfigurationSettings.getFolderName();
            if (folderName == null || folderNames.contains(folderName)) continue;
            folderNames.add(folderName);
        }
        folderNames.add(null);
        this.myConfigurations.clear();
        if (this.myOrder.isEmpty()) {
            Collections.sort(order, (o1, o2) -> {
                boolean temporary2;
                boolean temporary1 = ((RunnerAndConfigurationSettings)o1.getSecond()).isTemporary();
                if (temporary1 == (temporary2 = ((RunnerAndConfigurationSettings)o2.getSecond()).isTemporary())) {
                    return ((String)o1.first).compareTo((String)o2.first);
                }
                return temporary1 ? 1 : -1;
            });
        } else {
            Collections.sort(order, (arg_0, arg_1) -> this.lambda$getSortedConfigurations$3((List)folderNames, arg_0, arg_1));
        }
        for (Pair pair : order) {
            RunnerAndConfigurationSettings setting = (RunnerAndConfigurationSettings)pair.second;
            this.myConfigurations.put(setting.getUniqueID(), setting);
        }
        this.myOrdered = true;
        return this.myConfigurations.values();
    }

    public static boolean canRunConfiguration(@NotNull ExecutionEnvironment environment) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        return runnerAndConfigurationSettings != null && RunManagerImpl.canRunConfiguration(runnerAndConfigurationSettings, environment.getExecutor());
    }

    public static boolean canRunConfiguration(@NotNull RunnerAndConfigurationSettings configuration, @NotNull Executor executor) {
        try {
            configuration.checkSettings(executor);
        }
        catch (IndexNotReadyException ignored) {
            return Registry.is((String)"dumb.aware.run.configurations");
        }
        catch (RuntimeConfigurationError ignored) {
            return false;
        }
        catch (RuntimeConfigurationException ignored) {
            return true;
        }
        return true;
    }

    @Nullable
    public Element getState() {
        Element parentNode = new Element("state");
        this.writeContext(parentNode);
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myTemplateConfigurationsMap.values()) {
            if (runnerAndConfigurationSettings.getConfiguration() instanceof UnknownRunConfiguration && ((UnknownRunConfiguration)runnerAndConfigurationSettings.getConfiguration()).isDoNotStore()) continue;
            this.addConfigurationElement(parentNode, runnerAndConfigurationSettings);
        }
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.getStableConfigurations(false)) {
            this.addConfigurationElement(parentNode, runnerAndConfigurationSettings);
        }
        JDOMExternalizableStringList order = null;
        for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : this.myConfigurations.values()) {
            if (runnerAndConfigurationSettings.getType() instanceof UnknownConfigurationType) continue;
            if (order == null) {
                order = new JDOMExternalizableStringList();
            }
            order.add((Object)runnerAndConfigurationSettings.getUniqueID());
        }
        if (order != null) {
            order.writeExternal(parentNode);
        }
        JDOMExternalizableStringList jDOMExternalizableStringList = new JDOMExternalizableStringList();
        for (RunConfiguration each : this.myRecentlyUsedTemporaries) {
            RunnerAndConfigurationSettings settings;
            if (each.getType() instanceof UnknownConfigurationType || (settings = this.getSettings(each)) == null) continue;
            jDOMExternalizableStringList.add((Object)settings.getUniqueID());
        }
        if (!jDOMExternalizableStringList.isEmpty()) {
            Element element = new Element(RECENT);
            parentNode.addContent(element);
            jDOMExternalizableStringList.writeExternal(element);
        }
        if (this.myUnknownElements != null) {
            for (Element unloadedElement : this.myUnknownElements) {
                parentNode.addContent(unloadedElement.clone());
            }
        }
        return parentNode;
    }

    public void writeContext(@NotNull Element parentNode) {
        ArrayList<RunnerAndConfigurationSettings> values = new ArrayList<RunnerAndConfigurationSettings>(this.myConfigurations.values());
        for (RunnerAndConfigurationSettings configurationSettings : values) {
            if (!configurationSettings.isTemporary()) continue;
            this.addConfigurationElement(parentNode, configurationSettings, CONFIGURATION);
        }
        RunnerAndConfigurationSettings selected = this.getSelectedConfiguration();
        if (selected != null) {
            parentNode.setAttribute(SELECTED_ATTR, selected.getUniqueID());
        }
    }

    void addConfigurationElement(@NotNull Element parentNode, RunnerAndConfigurationSettings template) {
        this.addConfigurationElement(parentNode, template, CONFIGURATION);
    }

    private void addConfigurationElement(@NotNull Element parentNode, RunnerAndConfigurationSettings settings, String elementType) {
        Element configurationElement = new Element(elementType);
        parentNode.addContent(configurationElement);
        try {
            ((RunnerAndConfigurationSettingsImpl)settings).writeExternal(configurationElement);
        }
        catch (WriteExternalException e) {
            throw new RuntimeException(e);
        }
        if (settings.getConfiguration() instanceof UnknownRunConfiguration) {
            return;
        }
        ArrayList<BeforeRunTask> tasks = new ArrayList<BeforeRunTask>(this.getBeforeRunTasks(settings.getConfiguration()));
        THashMap templateTasks = new THashMap();
        List<BeforeRunTask> beforeRunTasks = settings.isTemplate() ? this.getHardcodedBeforeRunTasks(settings.getConfiguration()) : this.getBeforeRunTasks(this.getConfigurationTemplate(settings.getFactory()).getConfiguration());
        for (BeforeRunTask templateTask : beforeRunTasks) {
            templateTasks.put(templateTask.getProviderId(), templateTask);
            if (!templateTask.isEnabled()) continue;
            boolean found = false;
            for (BeforeRunTask realTask : tasks) {
                if (realTask.getProviderId() != templateTask.getProviderId()) continue;
                found = true;
                break;
            }
            if (found) continue;
            BeforeRunTask clone = templateTask.clone();
            clone.setEnabled(false);
            tasks.add(0, clone);
        }
        Element methodsElement = new Element(METHOD);
        int size = tasks.size();
        for (int i = 0; i < size; ++i) {
            BeforeRunTask task = (BeforeRunTask)tasks.get(i);
            int j = 0;
            BeforeRunTask templateTask = null;
            for (Map.Entry entry : templateTasks.entrySet()) {
                if (entry.getKey() == task.getProviderId()) {
                    templateTask = (BeforeRunTask)entry.getValue();
                    break;
                }
                ++j;
            }
            if (task.equals(templateTask) && i == j) continue;
            Element child = new Element(OPTION);
            child.setAttribute(NAME_ATTR, task.getProviderId().toString());
            task.writeExternal(child);
            methodsElement.addContent(child);
        }
        configurationElement.addContent(methodsElement);
    }

    public void loadState(Element parentNode) {
        this.clear(false);
        List children2 = parentNode.getChildren(CONFIGURATION);
        Element[] sortedElements = children2.toArray(new Element[children2.size()]);
        Arrays.sort(sortedElements, (a, b) -> {
            boolean bDefault;
            boolean aDefault = Boolean.valueOf(a.getAttributeValue("default", "false"));
            return aDefault == (bDefault = Boolean.valueOf(b.getAttributeValue("default", "false")).booleanValue()) ? 0 : (aDefault ? -1 : 1);
        });
        for (Element element : sortedElements) {
            RunnerAndConfigurationSettings configurationSettings;
            try {
                configurationSettings = this.loadConfiguration(element, false);
            }
            catch (ProcessCanceledException e) {
                configurationSettings = null;
            }
            catch (Throwable e) {
                LOG.error(e);
                continue;
            }
            if (configurationSettings != null) continue;
            if (this.myUnknownElements == null) {
                this.myUnknownElements = new SmartList();
            }
            this.myUnknownElements.add((Element)element.detach());
        }
        this.myOrder.readExternal(parentNode);
        this.readList(this.myOrder);
        this.myRecentlyUsedTemporaries.clear();
        Element recentNode = parentNode.getChild(RECENT);
        if (recentNode != null) {
            JDOMExternalizableStringList list = new JDOMExternalizableStringList();
            list.readExternal(recentNode);
            this.readList(list);
            for (String name : list) {
                RunnerAndConfigurationSettings settings = this.myConfigurations.get(name);
                if (settings == null) continue;
                this.myRecentlyUsedTemporaries.add(settings.getConfiguration());
            }
        }
        this.myOrdered = false;
        this.myLoadedSelectedConfigurationUniqueName = parentNode.getAttributeValue(SELECTED_ATTR);
        this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        this.fireBeforeRunTasksUpdated();
        this.fireRunConfigurationSelected();
    }

    private void readList(@NotNull JDOMExternalizableStringList list) {
        block0: for (int i = 0; i < list.size(); ++i) {
            for (RunnerAndConfigurationSettings settings : this.myConfigurations.values()) {
                RunConfiguration configuration = settings.getConfiguration();
                if (configuration == null || !((String)list.get(i)).equals(configuration.getType().getDisplayName() + "." + configuration.getName() + (configuration instanceof UnknownRunConfiguration ? Integer.valueOf(configuration.getUniqueID()) : ""))) continue;
                list.set(i, (Object)settings.getUniqueID());
                continue block0;
            }
        }
    }

    public void readContext(Element parentNode) throws InvalidDataException {
        this.myLoadedSelectedConfigurationUniqueName = parentNode.getAttributeValue(SELECTED_ATTR);
        for (Object aChildren : parentNode.getChildren()) {
            Element element = (Element)aChildren;
            RunnerAndConfigurationSettings config = this.loadConfiguration(element, false);
            if (this.myLoadedSelectedConfigurationUniqueName != null || config == null || !Boolean.valueOf(element.getAttributeValue(SELECTED_ATTR)).booleanValue()) continue;
            this.myLoadedSelectedConfigurationUniqueName = config.getUniqueID();
        }
        this.setSelectedConfigurationId(this.myLoadedSelectedConfigurationUniqueName);
        this.fireRunConfigurationSelected();
    }

    @Nullable
    String findExistingConfigurationId(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null) {
            for (Map.Entry<String, RunnerAndConfigurationSettings> entry : this.myConfigurations.entrySet()) {
                if (entry.getValue() != settings) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void clearAll() {
        this.clear(true);
        this.myTypesByName.clear();
        this.initializeConfigurationTypes(new ConfigurationType[0]);
    }

    private void clear(boolean allConfigurations) {
        Object configurations;
        if (allConfigurations) {
            this.myConfigurations.clear();
            this.mySharedConfigurations.clear();
            this.myConfigurationToBeforeTasksMap.clear();
            this.mySelectedConfigurationId = null;
            configurations = new ArrayList<RunnerAndConfigurationSettings>(this.myConfigurations.values());
        } else {
            configurations = new SmartList();
            Iterator<RunnerAndConfigurationSettings> iterator = this.myConfigurations.values().iterator();
            while (iterator.hasNext()) {
                RunnerAndConfigurationSettings configuration = iterator.next();
                if (!configuration.isTemporary() && this.isConfigurationShared(configuration)) continue;
                iterator.remove();
                this.mySharedConfigurations.remove(configuration.getUniqueID());
                this.myConfigurationToBeforeTasksMap.remove(configuration.getConfiguration());
                configurations.add(configuration);
            }
            if (this.mySelectedConfigurationId != null && this.myConfigurations.containsKey(this.mySelectedConfigurationId)) {
                this.mySelectedConfigurationId = null;
            }
        }
        this.myUnknownElements = null;
        this.myTemplateConfigurationsMap.clear();
        this.myLoadedSelectedConfigurationUniqueName = null;
        this.myIdToIcon.clear();
        this.myIconCheckTimes.clear();
        this.myIconCalcTime.clear();
        this.myRecentlyUsedTemporaries.clear();
        this.fireRunConfigurationsRemoved((List<RunnerAndConfigurationSettings>)configurations);
    }

    @Nullable
    public RunnerAndConfigurationSettings loadConfiguration(@NotNull Element element, boolean isShared) {
        RunnerAndConfigurationSettingsImpl settings = new RunnerAndConfigurationSettingsImpl(this);
        try {
            settings.readExternal(element);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        ConfigurationFactory factory = settings.getFactory();
        if (factory == null) {
            return null;
        }
        List<BeforeRunTask> tasks = this.readStepsBeforeRun(element.getChild(METHOD), settings);
        if (settings.isTemplate()) {
            this.myTemplateConfigurationsMap.put(factory.getType().getId() + "." + factory.getName(), settings);
            this.setBeforeRunTasks(settings.getConfiguration(), tasks, true);
        } else {
            this.addConfiguration(settings, isShared, tasks, true);
            if (Boolean.valueOf(element.getAttributeValue(SELECTED_ATTR)).booleanValue()) {
                this.setSelectedConfiguration(settings);
            }
        }
        return settings;
    }

    @NotNull
    private List<BeforeRunTask> readStepsBeforeRun(@Nullable Element child, @NotNull RunnerAndConfigurationSettings settings) {
        List result2 = null;
        if (child != null) {
            for (Element methodElement : child.getChildren(OPTION)) {
                Key<? extends BeforeRunTask> id = this.getProviderKey(methodElement.getAttributeValue(NAME_ATTR));
                BeforeRunTask beforeRunTask = this.getProvider(id).createTask(settings.getConfiguration());
                if (beforeRunTask == null) continue;
                beforeRunTask.readExternal(methodElement);
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(beforeRunTask);
            }
        }
        return ContainerUtil.notNullize(result2);
    }

    @Nullable
    public ConfigurationType getConfigurationType(String typeName) {
        return this.myTypesByName.get(typeName);
    }

    @Nullable
    public ConfigurationFactory getFactory(String typeName, String factoryName) {
        return this.getFactory(typeName, factoryName, false);
    }

    @Nullable
    public ConfigurationFactory getFactory(String typeName, String factoryName, boolean checkUnknown) {
        ConfigurationType type2 = this.myTypesByName.get(typeName);
        if (type2 == null && checkUnknown && typeName != null) {
            UnknownFeaturesCollector.getInstance(this.myProject).registerUnknownRunConfiguration(typeName);
        }
        if (factoryName == null) {
            factoryName = type2 != null ? type2.getConfigurationFactories()[0].getName() : null;
        }
        return this.findFactoryOfTypeNameByName(typeName, factoryName);
    }

    @Nullable
    private ConfigurationFactory findFactoryOfTypeNameByName(String typeName, String factoryName) {
        ConfigurationType type2 = this.myTypesByName.get(typeName);
        if (type2 == null) {
            type2 = this.myTypesByName.get("Unknown");
        }
        return RunManagerImpl.findFactoryOfTypeByName(type2, factoryName);
    }

    @Nullable
    private static ConfigurationFactory findFactoryOfTypeByName(ConfigurationType type2, String factoryName) {
        ConfigurationFactory[] factories;
        if (factoryName == null) {
            return null;
        }
        if (type2 instanceof UnknownConfigurationType) {
            return type2.getConfigurationFactories()[0];
        }
        for (ConfigurationFactory factory : factories = type2.getConfigurationFactories()) {
            if (!factoryName.equals(factory.getName())) continue;
            return factory;
        }
        return null;
    }

    @NotNull
    public String getComponentName() {
        return "RunManager";
    }

    @Override
    public void setTemporaryConfiguration(@Nullable RunnerAndConfigurationSettings tempConfiguration) {
        if (tempConfiguration == null) {
            return;
        }
        tempConfiguration.setTemporary(true);
        this.addConfiguration(tempConfiguration, this.isConfigurationShared(tempConfiguration), this.getBeforeRunTasks(tempConfiguration.getConfiguration()), false);
        if (Registry.is((String)"select.run.configuration.from.context")) {
            this.setSelectedConfiguration(tempConfiguration);
        }
    }

    @NotNull
    Collection<RunnerAndConfigurationSettings> getStableConfigurations(boolean shared) {
        List result2 = null;
        for (RunnerAndConfigurationSettings configuration : this.myConfigurations.values()) {
            if (configuration.isTemporary() || this.isConfigurationShared(configuration) != shared) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(configuration);
        }
        return ContainerUtil.notNullize(result2);
    }

    @NotNull
    Collection<? extends RunnerAndConfigurationSettings> getConfigurationSettings() {
        return this.myConfigurations.values();
    }

    public boolean isTemporary(@NotNull RunConfiguration configuration) {
        return Arrays.asList(this.getTempConfigurations()).contains(configuration);
    }

    @NotNull
    public List<RunnerAndConfigurationSettings> getTempConfigurationsList() {
        List configurations = ContainerUtil.filter(this.myConfigurations.values(), RunnerAndConfigurationSettings::isTemporary);
        return Collections.unmodifiableList(configurations);
    }

    @NotNull
    public RunConfiguration[] getTempConfigurations() {
        List<RunnerAndConfigurationSettings> list = this.getTempConfigurationsList();
        RunConfiguration[] result2 = new RunConfiguration[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result2[i] = list.get(i).getConfiguration();
        }
        return result2;
    }

    public void makeStable(@NotNull RunnerAndConfigurationSettings settings) {
        settings.setTemporary(false);
        this.myRecentlyUsedTemporaries.remove(settings.getConfiguration());
        if (!this.myOrder.isEmpty()) {
            this.setOrdered(false);
        }
        this.fireRunConfigurationChanged(settings);
    }

    public void makeStable(@NotNull RunConfiguration configuration) {
        RunnerAndConfigurationSettings settings = this.getSettings(configuration);
        if (settings != null) {
            this.makeStable(settings);
        }
    }

    @NotNull
    public RunnerAndConfigurationSettings createRunConfiguration(@NotNull String name, @NotNull ConfigurationFactory factory) {
        return this.createConfiguration(name, factory);
    }

    @Override
    public boolean isConfigurationShared(RunnerAndConfigurationSettings settings) {
        Boolean shared = this.mySharedConfigurations.get(settings.getUniqueID());
        if (shared == null) {
            RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
            shared = this.mySharedConfigurations.get(template.getUniqueID());
        }
        return shared != null && shared != false;
    }

    @Override
    @NotNull
    public <T extends BeforeRunTask> List<T> getBeforeRunTasks(Key<T> taskProviderID) {
        ArrayList<BeforeRunTask> tasks = new ArrayList<BeforeRunTask>();
        ArrayList<RunnerAndConfigurationSettings> checkedTemplates = new ArrayList<RunnerAndConfigurationSettings>();
        ArrayList<RunnerAndConfigurationSettings> settingsList = new ArrayList<RunnerAndConfigurationSettings>(this.myConfigurations.values());
        for (RunnerAndConfigurationSettings settings : settingsList) {
            List<BeforeRunTask> runTasks = this.getBeforeRunTasks(settings.getConfiguration());
            for (BeforeRunTask task : runTasks) {
                if (task != null && task.isEnabled() && task.getProviderId() == taskProviderID) {
                    tasks.add(task);
                    continue;
                }
                RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
                if (checkedTemplates.contains(template)) continue;
                checkedTemplates.add(template);
                List<BeforeRunTask> templateTasks = this.getBeforeRunTasks(template.getConfiguration());
                for (BeforeRunTask templateTask : templateTasks) {
                    if (templateTask == null || !templateTask.isEnabled() || templateTask.getProviderId() != taskProviderID) continue;
                    tasks.add(templateTask);
                }
            }
        }
        return tasks;
    }

    @Override
    public Icon getConfigurationIcon(@NotNull RunnerAndConfigurationSettings settings, boolean withLiveIndicator) {
        Icon icon;
        String selectedId;
        String uniqueID = settings.getUniqueID();
        RunnerAndConfigurationSettings selectedConfiguration = this.getSelectedConfiguration();
        String string = selectedId = selectedConfiguration != null ? selectedConfiguration.getUniqueID() : "";
        if (selectedId.equals(uniqueID)) {
            Long lastCheckTime = this.myIconCheckTimes.get(uniqueID);
            Long calcTime = this.myIconCalcTime.get(uniqueID);
            if (calcTime == null || calcTime < 150L) {
                calcTime = 150L;
            }
            if (lastCheckTime == null || System.currentTimeMillis() - lastCheckTime > calcTime * 10L) {
                this.myIdToIcon.remove(uniqueID);
            }
        }
        if ((icon = this.myIdToIcon.get(uniqueID)) == null) {
            icon = IconDeferrer.getInstance().deferAutoUpdatable(settings.getConfiguration().getIcon(), (Object)(this.myProject.hashCode() ^ settings.hashCode()), param -> {
                Icon icon1;
                if (this.myProject.isDisposed()) {
                    return null;
                }
                this.myIconCalcTime.remove(uniqueID);
                long startTime = System.currentTimeMillis();
                if (DumbService.isDumb((Project)this.myProject) && !Registry.is((String)"dumb.aware.run.configurations")) {
                    icon1 = IconLoader.getDisabledIcon((Icon)ProgramRunnerUtil.getRawIcon(settings));
                    if (settings.isTemporary()) {
                        icon1 = ProgramRunnerUtil.getTemporaryIcon(icon1);
                    }
                } else {
                    try {
                        DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(true);
                        settings.checkSettings();
                        icon1 = ProgramRunnerUtil.getConfigurationIcon(settings, false);
                    }
                    catch (IndexNotReadyException e) {
                        icon1 = ProgramRunnerUtil.getConfigurationIcon(settings, !Registry.is((String)"dumb.aware.run.configurations"));
                    }
                    catch (RuntimeConfigurationException ignored) {
                        icon1 = ProgramRunnerUtil.getConfigurationIcon(settings, true);
                    }
                    finally {
                        DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(false);
                    }
                }
                this.myIconCalcTime.put(uniqueID, System.currentTimeMillis() - startTime);
                return icon1;
            });
            this.myIdToIcon.put(uniqueID, icon);
            this.myIconCheckTimes.put(uniqueID, System.currentTimeMillis());
        }
        if (withLiveIndicator) {
            List<RunContentDescriptor> runningDescriptors = ExecutionManagerImpl.getInstance(this.myProject).getRunningDescriptors((Condition<RunnerAndConfigurationSettings>)((Condition)s -> s == settings));
            if (runningDescriptors.size() == 1) {
                icon = ExecutionUtil.getLiveIndicator((Icon)icon);
            }
            if (runningDescriptors.size() > 1) {
                icon = IconUtil.addText((Icon)icon, (String)String.valueOf(runningDescriptors.size()));
            }
        }
        return icon;
    }

    public RunnerAndConfigurationSettings getConfigurationById(@NotNull String id) {
        return this.myConfigurations.get(id);
    }

    @Override
    @Nullable
    public RunnerAndConfigurationSettings findConfigurationByName(@Nullable String name) {
        if (name == null) {
            return null;
        }
        for (RunnerAndConfigurationSettings each : this.myConfigurations.values()) {
            if (!name.equals(each.getName())) continue;
            return each;
        }
        return null;
    }

    @Nullable
    public RunnerAndConfigurationSettings findConfigurationByTypeAndName(@NotNull String typeId, @NotNull String name) {
        for (RunnerAndConfigurationSettings settings : this.getSortedConfigurations()) {
            ConfigurationType t = settings.getType();
            if (t == null || !typeId.equals(t.getId()) || !name.equals(settings.getName())) continue;
            return settings;
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends BeforeRunTask> List<T> getBeforeRunTasks(@NotNull RunConfiguration settings, Key<T> taskProviderID) {
        if (settings instanceof WrappingRunConfiguration) {
            return this.getBeforeRunTasks(((WrappingRunConfiguration)settings).getPeer(), taskProviderID);
        }
        List<BeforeRunTask> tasks = this.myConfigurationToBeforeTasksMap.get(settings);
        if (tasks == null) {
            tasks = this.getBeforeRunTasks(settings);
            this.myConfigurationToBeforeTasksMap.put(settings, tasks);
        }
        SmartList result2 = new SmartList();
        for (BeforeRunTask task : tasks) {
            if (task.getProviderId() != taskProviderID) continue;
            result2.add(task);
        }
        return result2;
    }

    @Override
    @NotNull
    public List<BeforeRunTask> getBeforeRunTasks(RunConfiguration settings) {
        if (settings instanceof WrappingRunConfiguration) {
            return this.getBeforeRunTasks(((WrappingRunConfiguration)settings).getPeer());
        }
        List<BeforeRunTask> tasks = this.myConfigurationToBeforeTasksMap.get(settings);
        return tasks == null ? this.getTemplateBeforeRunTasks(settings) : RunManagerImpl.getCopies(tasks);
    }

    private List<BeforeRunTask> getTemplateBeforeRunTasks(@NotNull RunConfiguration settings) {
        RunnerAndConfigurationSettings template = this.getConfigurationTemplate(settings.getFactory());
        List<BeforeRunTask> templateTasks = this.myConfigurationToBeforeTasksMap.get(template.getConfiguration());
        return templateTasks == null ? this.getHardcodedBeforeRunTasks(settings) : RunManagerImpl.getCopies(templateTasks);
    }

    @NotNull
    private List<BeforeRunTask> getHardcodedBeforeRunTasks(@NotNull RunConfiguration settings) {
        SmartList _tasks = new SmartList();
        for (BeforeRunTaskProvider provider2 : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject)) {
            BeforeRunTask task = provider2.createTask(settings);
            if (task == null || !task.isEnabled()) continue;
            Key providerID = provider2.getId();
            settings.getFactory().configureBeforeRunTaskDefaults(providerID, task);
            if (!task.isEnabled()) continue;
            _tasks.add(task);
        }
        return _tasks;
    }

    @NotNull
    private static List<BeforeRunTask> getCopies(@NotNull List<BeforeRunTask> original) {
        SmartList result2 = new SmartList();
        for (BeforeRunTask task : original) {
            if (!task.isEnabled()) continue;
            result2.add(task.clone());
        }
        return result2;
    }

    public void shareConfiguration(RunnerAndConfigurationSettings settings, boolean shareConfiguration) {
        boolean shouldFire;
        boolean bl = shouldFire = settings != null && this.isConfigurationShared(settings) != shareConfiguration;
        if (shareConfiguration && settings.isTemporary()) {
            this.makeStable(settings);
        }
        this.mySharedConfigurations.put(settings.getUniqueID(), shareConfiguration);
        if (shouldFire) {
            this.fireRunConfigurationChanged(settings);
        }
    }

    @Override
    public final void setBeforeRunTasks(RunConfiguration runConfiguration, @NotNull List<BeforeRunTask> tasks, boolean addEnabledTemplateTasksIfAbsent) {
        SmartList result2 = new SmartList(tasks);
        if (addEnabledTemplateTasksIfAbsent) {
            List<BeforeRunTask> templates = this.getTemplateBeforeRunTasks(runConfiguration);
            THashSet idsToSet = new THashSet();
            for (BeforeRunTask task : tasks) {
                idsToSet.add(task.getProviderId());
            }
            int i = 0;
            for (BeforeRunTask template : templates) {
                if (idsToSet.contains(template.getProviderId())) continue;
                result2.add(i, template);
                ++i;
            }
        }
        this.myConfigurationToBeforeTasksMap.put(runConfiguration, (List<BeforeRunTask>)result2);
        this.fireBeforeRunTasksUpdated();
    }

    public final void resetBeforeRunTasks(RunConfiguration runConfiguration) {
        this.myConfigurationToBeforeTasksMap.remove(runConfiguration);
        this.fireBeforeRunTasksUpdated();
    }

    public void addConfiguration(RunnerAndConfigurationSettings settings, boolean isShared) {
        this.addConfiguration(settings, isShared, this.getTemplateBeforeRunTasks(settings.getConfiguration()), false);
    }

    public static RunManagerImpl getInstanceImpl(Project project2) {
        return (RunManagerImpl)RunManager.getInstance((Project)project2);
    }

    void removeNotExistingSharedConfigurations(@NotNull Set<String> existing) {
        List removed = null;
        Iterator<Map.Entry<String, RunnerAndConfigurationSettings>> it = this.myConfigurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RunnerAndConfigurationSettings> entry = it.next();
            RunnerAndConfigurationSettings settings = entry.getValue();
            if (settings.isTemplate() || !this.isConfigurationShared(settings) || existing.contains(settings.getUniqueID())) continue;
            if (removed == null) {
                removed = new SmartList();
            }
            removed.add(settings);
            it.remove();
        }
        this.fireRunConfigurationsRemoved(removed);
    }

    public void fireBeginUpdate() {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).beginUpdate();
    }

    public void fireEndUpdate() {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).endUpdate();
    }

    public void fireRunConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationChanged(settings, null);
    }

    private void fireRunConfigurationsRemoved(@Nullable List<RunnerAndConfigurationSettings> removed) {
        if (!ContainerUtil.isEmpty(removed)) {
            this.myRecentlyUsedTemporaries.removeAll(removed);
            for (RunnerAndConfigurationSettings settings : removed) {
                ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationRemoved(settings);
            }
        }
    }

    private void fireRunConfigurationSelected() {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).runConfigurationSelected();
    }

    @Override
    public void addRunManagerListener(RunManagerListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void removeRunManagerListener(RunManagerListener listener2) {
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void fireBeforeRunTasksUpdated() {
        ((RunManagerListener)this.myDispatcher.getMulticaster()).beforeRunTasksChanged();
    }

    @NotNull
    private synchronized BeforeRunTaskProvider getProvider(Key<? extends BeforeRunTask> providerId) {
        if (this.myBeforeStepsMap == null) {
            this.initProviderMaps();
        }
        return this.myBeforeStepsMap.get(providerId);
    }

    @NotNull
    private synchronized Key<? extends BeforeRunTask> getProviderKey(String keyString) {
        Key<? extends BeforeRunTask> id;
        if (this.myProviderKeysMap == null) {
            this.initProviderMaps();
        }
        if ((id = this.myProviderKeysMap.get(keyString)) == null) {
            UnknownBeforeRunTaskProvider provider2 = new UnknownBeforeRunTaskProvider(keyString);
            id = provider2.getId();
            this.myProviderKeysMap.put(keyString, id);
            this.myBeforeStepsMap.put(id, provider2);
        }
        return id;
    }

    private void initProviderMaps() {
        this.myBeforeStepsMap = new LinkedHashMap<Key<? extends BeforeRunTask>, BeforeRunTaskProvider>();
        this.myProviderKeysMap = new LinkedHashMap<String, Key<? extends BeforeRunTask>>();
        for (BeforeRunTaskProvider provider2 : (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject)) {
            Key id = provider2.getId();
            this.myBeforeStepsMap.put((Key<? extends BeforeRunTask>)id, provider2);
            this.myProviderKeysMap.put(id.toString(), (Key<? extends BeforeRunTask>)id);
        }
    }

    private /* synthetic */ int lambda$getSortedConfigurations$3(List folderNames, Pair o1, Pair o2) {
        boolean temporary2;
        int i2;
        int i1 = folderNames.indexOf(((RunnerAndConfigurationSettings)o1.getSecond()).getFolderName());
        if (i1 != (i2 = folderNames.indexOf(((RunnerAndConfigurationSettings)o2.getSecond()).getFolderName()))) {
            return i1 - i2;
        }
        boolean temporary1 = ((RunnerAndConfigurationSettings)o1.getSecond()).isTemporary();
        if (temporary1 == (temporary2 = ((RunnerAndConfigurationSettings)o2.getSecond()).isTemporary())) {
            int index1 = this.myOrder.indexOf(o1.first);
            int index2 = this.myOrder.indexOf(o2.first);
            if (index1 == -1 && index2 == -1) {
                return ((RunnerAndConfigurationSettings)o1.second).getName().compareTo(((RunnerAndConfigurationSettings)o2.second).getName());
            }
            return index1 - index2;
        }
        return temporary1 ? 1 : -1;
    }
}

